/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.jmi.xmi;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import javax.jmi.reflect.RefPackage;
import javax.jmi.xmi.MalformedXMIException;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.mdr.XMIReader;
import org.netbeans.lib.jmi.util.Logger;
import org.netbeans.lib.jmi.xmi.XmiSAXReader;
import org.xml.sax.SAXException;

public class XMISaxReaderImpl
extends XMIReader {
    public Collection read(InputStream stream, String uri, RefPackage extent) throws IOException, MalformedXMIException {
        try {
            return new XmiSAXReader().read(stream, uri, new RefPackage[]{extent}, null);
        }
        catch (ParserConfigurationException e) {
            MalformedXMIException ne = new MalformedXMIException(e.getMessage());
            Logger.getDefault().annotate((Throwable)ne, (Throwable)e);
            throw ne;
        }
        catch (SAXException e) {
            MalformedXMIException ne = new MalformedXMIException(e.getMessage());
            Logger.getDefault().annotate((Throwable)ne, (Throwable)e);
            throw ne;
        }
    }

    public Collection read(String uri, RefPackage extent) throws IOException, MalformedXMIException {
        return this.read(new URL(uri), new RefPackage[]{extent}, null);
    }

    public Collection read(String uri, RefPackage[] extents) throws IOException, MalformedXMIException {
        try {
            return this.read(new URL(uri), extents, null);
        }
        catch (MalformedURLException e) {
            IOException ne = new IOException(e.toString());
            Logger.getDefault().annotate((Throwable)ne, (Throwable)e);
            throw ne;
        }
    }

    private Collection read(URL url, RefPackage[] extents, String encoding) throws IOException, MalformedXMIException {
        try {
            return new XmiSAXReader().read(url, extents, encoding);
        }
        catch (ParserConfigurationException e) {
            MalformedXMIException ne = new MalformedXMIException(e.toString());
            Logger.getDefault().annotate((Throwable)ne, (Throwable)e);
            throw ne;
        }
        catch (SAXException e) {
            MalformedXMIException ne = new MalformedXMIException(e.toString());
            Logger.getDefault().annotate((Throwable)ne, (Throwable)e);
            throw ne;
        }
    }
}

