/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.jmi.xmi;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jmi.model.AliasType;
import javax.jmi.model.Attribute;
import javax.jmi.model.Classifier;
import javax.jmi.model.CollectionType;
import javax.jmi.model.DataTypeClass;
import javax.jmi.model.EnumerationType;
import javax.jmi.model.EnumerationTypeClass;
import javax.jmi.model.Feature;
import javax.jmi.model.GeneralizableElement;
import javax.jmi.model.Import;
import javax.jmi.model.ModelElement;
import javax.jmi.model.ModelPackage;
import javax.jmi.model.MofClass;
import javax.jmi.model.MofPackage;
import javax.jmi.model.MofPackageClass;
import javax.jmi.model.MultiplicityType;
import javax.jmi.model.NameNotFoundException;
import javax.jmi.model.NameNotResolvedException;
import javax.jmi.model.Namespace;
import javax.jmi.model.PrimitiveType;
import javax.jmi.model.PrimitiveTypeClass;
import javax.jmi.model.Reference;
import javax.jmi.model.ScopeKindEnum;
import javax.jmi.model.StructuralFeature;
import javax.jmi.model.StructureField;
import javax.jmi.model.StructureFieldClass;
import javax.jmi.model.StructureType;
import javax.jmi.model.StructureTypeClass;
import javax.jmi.model.Tag;
import javax.jmi.model.VisibilityKind;
import javax.jmi.model.VisibilityKindEnum;
import javax.jmi.reflect.InvalidCallException;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefEnum;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.jmi.xmi.MalformedXMIException;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.xmi.XMIInputConfig;
import org.netbeans.api.xmi.XMIReferenceProvider;
import org.netbeans.api.xmi.XMIReferenceResolver;
import org.netbeans.lib.jmi.util.DebugException;
import org.netbeans.lib.jmi.util.Logger;
import org.netbeans.lib.jmi.xmi.InputConfig;
import org.netbeans.lib.jmi.xmi.XMIHeaderConsumer;
import org.netbeans.lib.jmi.xmi.XmiElement;
import org.netbeans.lib.jmi.xmi.XmiSAXReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XmiContext
implements XMIReferenceResolver {
    private static final String ANNOTATION = "";
    private static final String[] PRIMITIVE_TYPES = new String[]{"Boolean", "Double", "Float", "Integer", "Long", "String"};
    XmiElement.PrimitiveValue PRIMITIVE_VALUE = new XmiElement.PrimitiveValue(this);
    XmiElement.EnumerationValue ENUMERATION_VALUE = new XmiElement.EnumerationValue(this);
    XmiElement.ReferenceValue REFERENCE_VALUE = new XmiElement.ReferenceValue(this);
    String XMI_HREF;
    String XMI_IDREF;
    String XMI_ID;
    boolean isXmi20;
    String xmiNsPrefix;
    String xmlNsPrefix;
    private HashMap nsURIToPrefix = new HashMap();
    private HashMap outermostPackages = new HashMap();
    private HashMap namespaces = new HashMap();
    private RefPackage[] extents;
    private ModelPackage modelPackage = null;
    private MofPackage primitiveTypesPackage = null;
    private HashMap primitiveTypes = null;
    private List aliasesInsteadOfCorbaPrimitives = new LinkedList();
    private HashMap instanceAttributes_cache = new HashMap();
    private HashMap instanceReferences_cache = new HashMap();
    private HashMap instanceElementsByName_cache = new HashMap();
    private HashMap classAttributes_cache = new HashMap();
    private HashMap classElementsByName_cache = new HashMap();
    private HashMap structureFields_cache = new HashMap();
    private HashMap labelPrefix_cache = new HashMap();
    private Collection outermostInstances = new LinkedList();
    private HashMap resolvedNames_cache = new HashMap();
    private HashMap allXmiReferences = new HashMap();
    private HashMap unresolvedRefs = new HashMap();
    private HashMap unresolvedExternalRefs = new HashMap();
    private List listOfUnresolvedHRefs = new LinkedList();
    private Set allUnresolvedHRefs = new HashSet();
    private HashMap hrefClients = new HashMap();
    boolean isMain = true;
    private Set readDocuments = new HashSet();
    private String thisSystemId = null;
    private HashMap systemIds = new HashMap();
    private URL docURL = null;
    private HashMap trackedPackages;
    private HashMap proxies_cache = new HashMap();
    private XMIInputConfig config;
    public int instancesCounter = 0;
    private XMIReferenceResolver resolver = this;
    private XMIHeaderConsumer headerConsumer = null;

    public XmiContext(RefPackage[] extents, URL docURL, XMIInputConfig config) {
        this(extents, config);
        this.docURL = docURL;
        this.thisSystemId = docURL == null ? ANNOTATION : docURL.toString();
        this.readDocuments.add(this.thisSystemId);
    }

    public XmiContext(RefPackage[] extents, XMIInputConfig config) {
        this.extents = extents;
        this.config = config;
        this.resolver = config.getReferenceResolver();
        if (this.resolver == null) {
            this.resolver = this;
        }
        if (config instanceof InputConfig) {
            this.headerConsumer = ((InputConfig)config).getHeaderConsumer();
        }
        int i = 0;
        while (i < extents.length) {
            if (extents[i] instanceof ModelPackage) {
                this.modelPackage = (ModelPackage)extents[i];
                break;
            }
            ++i;
        }
        this.isMain = true;
        this.unresolvedRefs = new HashMap();
        this.allUnresolvedHRefs = new HashSet();
        this.allXmiReferences = new HashMap();
    }

    public void setVersion(Attributes attrs) {
        int x;
        this.xmiNsPrefix = null;
        String version = attrs.getValue("xmi.version");
        if (version != null) {
            if (!(version.equals("1.0") || version.equals("1.1") || version.equals("1.2"))) {
                throw new DebugException("Malformed version parameter or unsupported verion of XMI: version = " + version);
            }
            this.isXmi20 = false;
        } else {
            this.isXmi20 = true;
            this.xmiNsPrefix = ANNOTATION;
            x = 0;
            while (x < attrs.getLength()) {
                String attrName;
                String attrValue = attrs.getValue(x);
                if (attrValue.equals("http://www.omg.org/XMI") && (attrName = attrs.getQName(x)).startsWith("xmlns:")) {
                    this.xmiNsPrefix = attrName.substring(6, attrName.length()) + ":";
                    break;
                }
                ++x;
            }
            version = attrs.getValue(this.xmiNsPrefix + "version");
            if (version == null) {
                throw new DebugException("XMI version attribute is missing.");
            }
            if (!version.equals("2.0")) {
                throw new DebugException("Malformed version parameter or unsupported verion of XMI: " + this.xmiNsPrefix + "version" + " = " + version);
            }
        }
        if (this.isXmi20) {
            this.XMI_HREF = this.xmiNsPrefix + "href";
            this.XMI_ID = this.xmiNsPrefix + "id";
            this.XMI_IDREF = this.xmiNsPrefix + "idref";
            x = 0;
            while (x < attrs.getLength()) {
                String attrName = attrs.getQName(x);
                String attrValue = attrs.getValue(x);
                if (attrName.equals("xmlns")) {
                    if (attrValue.equals("http://www.w3.org/XMLSchema-instance")) {
                        this.xmlNsPrefix = ANNOTATION;
                    } else {
                        this.nsURIToPrefix.put(attrValue, null);
                    }
                } else if (attrName.startsWith("xmlns:")) {
                    String name = attrName.substring(6, attrName.length());
                    if (attrValue.equals("http://www.w3.org/XMLSchema-instance")) {
                        this.xmlNsPrefix = name + ":";
                    } else {
                        this.nsURIToPrefix.put(attrValue, name);
                    }
                }
                ++x;
            }
        } else {
            this.XMI_HREF = "href";
            this.XMI_ID = "xmi.id";
            this.XMI_IDREF = "xmi.idref";
        }
        this.trackedPackages = new HashMap();
        int i = 0;
        while (i < this.extents.length) {
            this.findOutermostPackages(this.extents[i].refOutermostPackage());
            ++i;
        }
    }

    private void findOutermostPackages(RefPackage pkg) {
        String name;
        Iterator iter;
        if (this.trackedPackages.get(pkg) != null) {
            return;
        }
        MofPackage metaObj = (MofPackage)pkg.refMetaObject();
        if (metaObj.getContainer() == null) {
            iter = metaObj.getQualifiedName().iterator();
            String fqName = (String)iter.next();
            while (iter.hasNext()) {
                fqName = fqName.concat(".").concat((String)iter.next());
            }
            this.outermostPackages.put(fqName, pkg);
        }
        if (this.isXmi20) {
            String uri = XmiContext.getTagValue((ModelElement)metaObj, "org.omg.xmi.nsURI");
            if (uri == null) {
                throw new DebugException("No tag specifying a namespace uri is attached to MofPackage " + metaObj.getName());
            }
            name = (String)this.nsURIToPrefix.get(uri);
            if (name == null) {
                throw new DebugException("XMI document does not contain namespace declaration for " + uri + ", MofPackage " + metaObj.getName());
            }
        } else {
            name = XmiContext.getTagValue((ModelElement)metaObj, "org.omg.xmi.namespace");
        }
        if (name != null) {
            LinkedList<RefPackage> list = (LinkedList<RefPackage>)this.namespaces.get(name);
            if (list == null) {
                list = new LinkedList<RefPackage>();
                this.namespaces.put(name, list);
            }
            list.add(pkg);
        }
        this.trackedPackages.put(pkg, pkg);
        iter = pkg.refAllPackages().iterator();
        while (iter.hasNext()) {
            this.findOutermostPackages((RefPackage)iter.next());
        }
    }

    public static String getTagValue(ModelElement element, String tagId) {
        List tags = ((ModelPackage)element.refOutermostPackage()).getAttachesTo().getTag(element);
        Tag tag = null;
        Iterator it = tags.iterator();
        while (it.hasNext()) {
            Tag temp;
            Object obj = it.next();
            if (!(obj instanceof Tag) || !tagId.equals((temp = (Tag)obj).getTagId())) continue;
            tag = temp;
            break;
        }
        if (tag == null) {
            return null;
        }
        List values = tag.getValues();
        if (values.size() == 0) {
            return null;
        }
        return (String)values.iterator().next();
    }

    public void resolveDifferences(String href, HashMap diffs) {
        if (href == null) {
            throw new DebugException("External document to applay differences on is not specified.");
        }
        try {
            URL doc;
            XmiSAXReader reader = new XmiSAXReader(this.config);
            if (this.docURL != null) {
                String path = this.docURL.getPath();
                int copyTo = path.lastIndexOf("/");
                if (copyTo > -1) {
                    href = path.substring(0, copyTo) + "/" + href;
                }
                doc = new URL(this.docURL.getProtocol(), this.docURL.getHost(), href);
            } else {
                doc = new URL(href);
            }
            Collection res = reader.read(doc, this.extents, null, diffs);
            this.outermostInstances.addAll(res);
        }
        catch (Exception e) {
            throw new DebugException(e.getMessage());
        }
    }

    private void cacheContainedElements(RefClass proxyClass) {
        LinkedList temp = new LinkedList();
        MofClass metaProxyClass = (MofClass)proxyClass.refMetaObject();
        List superClasses = metaProxyClass.allSupertypes();
        Namespace namespace = null;
        Iterator it = superClasses.iterator();
        while (it.hasNext()) {
            namespace = (Namespace)it.next();
            temp.addAll(namespace.getContents());
        }
        temp.addAll(metaProxyClass.getContents());
        LinkedList<RefObject> instanceAttributes = new LinkedList<RefObject>();
        LinkedList<RefObject> instanceReferences = new LinkedList<RefObject>();
        LinkedList<RefObject> classAttributes = new LinkedList<RefObject>();
        HashMap<String, RefObject> instanceElementsByName = new HashMap<String, RefObject>();
        HashMap<String, RefObject> classElementsByName = new HashMap<String, RefObject>();
        it = temp.iterator();
        while (it.hasNext()) {
            RefObject refObject = (RefObject)it.next();
            if (!(refObject instanceof Feature)) continue;
            boolean instanceLevel = ((Feature)refObject).getScope().equals((Object)ScopeKindEnum.INSTANCE_LEVEL);
            if (refObject instanceof Attribute && !((Attribute)refObject).isDerived()) {
                if (instanceLevel) {
                    instanceAttributes.add(refObject);
                    instanceElementsByName.put(((Attribute)refObject).getName(), refObject);
                    continue;
                }
                classAttributes.add(refObject);
                classElementsByName.put(((Attribute)refObject).getName(), refObject);
                continue;
            }
            if (!(refObject instanceof Reference) || !instanceLevel) continue;
            instanceReferences.add(refObject);
            instanceElementsByName.put(((Reference)refObject).getName(), refObject);
        }
        this.instanceAttributes_cache.put(proxyClass, instanceAttributes);
        this.instanceReferences_cache.put(proxyClass, instanceReferences);
        this.instanceElementsByName_cache.put(proxyClass, instanceElementsByName);
        this.classAttributes_cache.put(proxyClass, classAttributes);
        this.classElementsByName_cache.put(proxyClass, instanceElementsByName);
    }

    public List instanceAttributes(RefClass refClass) {
        List list = (List)this.instanceAttributes_cache.get(refClass);
        if (list == null) {
            this.cacheContainedElements(refClass);
            list = (List)this.instanceAttributes_cache.get(refClass);
        }
        return list;
    }

    public List instanceReferences(RefClass refClass) {
        List list = (List)this.instanceReferences_cache.get(refClass);
        if (list == null) {
            this.cacheContainedElements(refClass);
            list = (List)this.instanceReferences_cache.get(refClass);
        }
        return list;
    }

    public StructuralFeature instanceElementByName(RefClass refClass, String name) {
        StructuralFeature feature;
        HashMap map = (HashMap)this.instanceElementsByName_cache.get(refClass);
        if (map == null) {
            this.cacheContainedElements(refClass);
            map = (HashMap)this.instanceElementsByName_cache.get(refClass);
        }
        if ((feature = (StructuralFeature)map.get(name)) == null) {
            // empty if block
        }
        return feature;
    }

    public List staticAttributes(RefClass refClass) {
        List list = (List)this.classAttributes_cache.get(refClass);
        if (list == null) {
            this.cacheContainedElements(refClass);
            list = (List)this.classAttributes_cache.get(refClass);
        }
        return list;
    }

    public Attribute staticAttributeByName(RefClass refClass, String name) {
        HashMap map = (HashMap)this.classElementsByName_cache.get(refClass);
        if (map == null) {
            this.cacheContainedElements(refClass);
            map = (HashMap)this.classElementsByName_cache.get(refClass);
        }
        return (Attribute)map.get(name);
    }

    public List structureFields(StructureType type) {
        LinkedList fields = (LinkedList)this.structureFields_cache.get(type);
        if (fields != null) {
            return fields;
        }
        fields = new LinkedList();
        Iterator content = type.getContents().iterator();
        while (content.hasNext()) {
            Object element = content.next();
            if (!(element instanceof StructureField)) continue;
            fields.add(element);
        }
        this.structureFields_cache.put(type, fields);
        return fields;
    }

    public String labelPrefix(EnumerationType type) {
        if (this.isXmi20) {
            return ANNOTATION;
        }
        String prefix = (String)this.labelPrefix_cache.get(type);
        if (prefix != null) {
            return prefix;
        }
        prefix = XmiContext.getTagValue((ModelElement)type, "org.omg.xmi.enumerationUnprefix");
        if (prefix == null) {
            prefix = ANNOTATION;
        }
        this.labelPrefix_cache.put(type, prefix);
        return prefix;
    }

    public Object resolveElementName(String fqName) {
        Object result;
        block17: {
            result = this.resolvedNames_cache.get(fqName);
            if (result != null) {
                return result;
            }
            int pos = fqName.indexOf(":");
            RefPackage outermostPackage = null;
            if (pos < 0 && !this.isXmi20) {
                int index = fqName.indexOf(".");
                String packageName = fqName;
                while (index > -1) {
                    outermostPackage = (RefPackage)this.outermostPackages.get(packageName = packageName.substring(0, index));
                    if (outermostPackage != null) break;
                    index = packageName.indexOf(".");
                }
                if (outermostPackage == null) {
                    throw new DebugException("Element name cannot be resolved, unknown package: " + fqName);
                }
                StringTokenizer tokenizer = new StringTokenizer(fqName, ".");
                LinkedList<String> nameParts = new LinkedList<String>();
                tokenizer.nextToken();
                while (tokenizer.hasMoreTokens()) {
                    nameParts.add(tokenizer.nextToken());
                }
                Namespace namespace = (Namespace)outermostPackage.refMetaObject();
                try {
                    ModelElement obj = namespace.resolveQualifiedName(nameParts);
                    if (obj instanceof MofClass) {
                        RefPackage refPkg = (RefPackage)this.findProxy((ModelElement)((MofClass)obj));
                        if (refPkg != null) {
                            result = refPkg.refClass((RefObject)obj);
                        }
                        break block17;
                    }
                    result = obj;
                }
                catch (NameNotResolvedException e) {}
            } else {
                String nsPrefixName = pos < 0 ? ANNOTATION : fqName.substring(0, pos);
                List packages = (List)this.namespaces.get(nsPrefixName);
                if (packages == null) {
                    throw new DebugException("Namespace cannot be resolved: " + nsPrefixName);
                }
                int pos2 = fqName.indexOf(".");
                Iterator iter = packages.iterator();
                while (iter.hasNext()) {
                    outermostPackage = (RefPackage)iter.next();
                    try {
                        if (pos2 == -1) {
                            ModelElement metaClass = ((GeneralizableElement)outermostPackage.refMetaObject()).lookupElementExtended(fqName.substring(pos + 1, fqName.length()));
                            result = metaClass instanceof MofClass ? outermostPackage.refClass((RefObject)metaClass) : metaClass;
                        } else {
                            Classifier element = (Classifier)((GeneralizableElement)outermostPackage.refMetaObject()).lookupElementExtended(fqName.substring(pos + 1, pos2));
                            if (element == null) continue;
                            result = element.lookupElementExtended(fqName.substring(pos2 + 1, fqName.length()));
                        }
                    }
                    catch (NameNotFoundException e) {
                        // empty catch block
                    }
                    if (result != null) break;
                }
            }
        }
        if (result == null) {
            throw new DebugException("Name cannot be resolved: " + fqName);
        }
        this.resolvedNames_cache.put(fqName, result);
        return result;
    }

    public void receiveHeader(String header) {
        if (this.headerConsumer != null) {
            byte[] bytes = new byte[header.length()];
            int x = 0;
            while (x < bytes.length) {
                bytes[x] = (byte)header.charAt(x);
                ++x;
            }
            this.headerConsumer.consumeHeader(new ByteArrayInputStream(bytes));
        }
    }

    public void finish() {
        if (!this.isMain) {
            return;
        }
        HashMap<MofPackage, MofPackage> checkedPackages = new HashMap<MofPackage, MofPackage>();
        Iterator iter = this.aliasesInsteadOfCorbaPrimitives.iterator();
        while (iter.hasNext()) {
            ModelElement element = (ModelElement)iter.next();
            Namespace container = element.getContainer();
            Namespace owner = container.getContainer();
            while (owner != null) {
                container = owner;
                owner = owner.getContainer();
            }
            while (container.getContainer() != null) {
                container = container.getContainer();
            }
            if (!(container instanceof MofPackage) || checkedPackages.get(container) != null) continue;
            MofPackage pkg = (MofPackage)container;
            Iterator content = pkg.getContents().iterator();
            boolean found = false;
            while (content.hasNext()) {
                ModelElement el = (ModelElement)content.next();
                if (!(el instanceof Import) || !this.primitiveTypesPackage.equals((Object)((Import)el).getImportedNamespace())) continue;
                found = true;
                break;
            }
            if (!found) {
                Import imp = this.modelPackage.getImport().createImport("PrimitiveTypes", ANNOTATION, (VisibilityKind)VisibilityKindEnum.PUBLIC_VIS, false);
                imp.setImportedNamespace((Namespace)this.primitiveTypesPackage);
                imp.setContainer((Namespace)pkg);
            }
            checkedPackages.put(pkg, pkg);
        }
        checkedPackages = null;
        Logger.getDefault().log("Number of created instances: " + this.instancesCounter);
    }

    public XmiElement resolveInstanceOrReference(XmiElement parent, String qName, Attributes attrs) {
        String idRef = attrs.getValue(this.XMI_IDREF);
        if (idRef != null) {
            this.REFERENCE_VALUE.init(parent, idRef);
            return this.REFERENCE_VALUE;
        }
        idRef = attrs.getValue(this.XMI_HREF);
        if (idRef != null) {
            this.REFERENCE_VALUE.initExternal(parent, idRef);
            return this.REFERENCE_VALUE;
        }
        Object ref = this.resolveElementName(qName);
        if (ref instanceof DataTypeClass) {
            return new XmiElement.DataTypeElement(parent, this, qName, attrs);
        }
        return new XmiElement.Instance(parent, this, qName, (RefClass)ref, attrs);
    }

    public void addOutermostObject(RefObject obj) {
        this.outermostInstances.add(obj);
    }

    public Collection getOutermostObjects() {
        return this.outermostInstances;
    }

    public void register(String systemId, String xmiId, RefObject object) {
        String href = systemId + '#' + xmiId;
        List list = (List)this.hrefClients.remove(href);
        if (list != null) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                ((Client)iter.next()).resolvedReference(href, object, true);
            }
        }
    }

    public void resolve(XMIReferenceResolver.Client client, RefPackage extent, String systemId, XMIInputConfig configuration, Collection hrefs) throws MalformedXMIException, IOException {
        String href;
        this.listOfUnresolvedHRefs = new LinkedList();
        this.unresolvedExternalRefs = new HashMap();
        Iterator iter = hrefs.iterator();
        while (iter.hasNext()) {
            href = (String)iter.next();
            LinkedList<XMIReferenceResolver.Client> list = (LinkedList<XMIReferenceResolver.Client>)this.hrefClients.get(href);
            if (list == null) {
                list = new LinkedList<XMIReferenceResolver.Client>();
                this.hrefClients.put(href, list);
            }
            list.add(client);
        }
        iter = hrefs.iterator();
        while (iter.hasNext()) {
            URL url;
            String xmiId;
            href = (String)iter.next();
            XMIReferenceProvider.XMIReference ref = this.toXMIReference(href);
            String systId = ref.getSystemId();
            RefObject obj = this.getReference(systId, xmiId = ref.getXmiId());
            if (obj != null) {
                this.register(systId, xmiId, obj);
                continue;
            }
            if (this.readDocuments.contains(systId) || (url = this.toURL(systId)) != null && this.readDocuments.contains(url.toString())) continue;
            this.readExternalDocument(systId);
        }
    }

    public RefObject getReference(String xmiId) {
        return this.getReference(this.thisSystemId, xmiId);
    }

    public RefObject getReference(String docId, String xmiId) {
        HashMap map = (HashMap)this.allXmiReferences.get(this.absoluteSystemId(docId));
        return map != null ? (RefObject)map.get(xmiId) : null;
    }

    public void putReference(String systemId, String xmiId, RefObject obj) {
        List list;
        Map map = (HashMap<String, RefObject>)this.allXmiReferences.get(systemId = this.absoluteSystemId(systemId));
        if (map == null) {
            map = new HashMap<String, RefObject>();
            this.allXmiReferences.put(systemId, map);
        }
        if (map.put(xmiId, obj) != null) {
            throw new DebugException("The same value of xmi.idref used second time: " + xmiId + ", " + systemId);
        }
        map = (Map)this.unresolvedRefs.get(systemId);
        if (map != null && (list = (List)map.remove(xmiId)) != null) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                ((XmiElement.UnresolvedReference)iter.next()).referenceResolved(obj);
            }
            if (map.size() == 0) {
                this.unresolvedRefs.remove(systemId);
            }
        }
        this.resolver.register(systemId, xmiId, obj);
    }

    public void registerUnresolvedRef(String xmiId, XmiElement.UnresolvedReference element) {
        LinkedList<XmiElement.UnresolvedReference> list;
        HashMap<String, LinkedList<XmiElement.UnresolvedReference>> map = (HashMap<String, LinkedList<XmiElement.UnresolvedReference>>)this.unresolvedRefs.get(this.thisSystemId);
        if (map == null) {
            map = new HashMap<String, LinkedList<XmiElement.UnresolvedReference>>();
            this.unresolvedRefs.put(this.thisSystemId, map);
        }
        if ((list = (LinkedList<XmiElement.UnresolvedReference>)map.get(xmiId)) == null) {
            list = new LinkedList<XmiElement.UnresolvedReference>();
            map.put(xmiId, list);
        }
        list.add(element);
    }

    public void registerUnresolvedExternalRef(String docId, String xmiId, XmiElement.UnresolvedReference element) {
        String href = this.absoluteSystemId(docId) + '#' + xmiId;
        LinkedList<XmiElement.UnresolvedReference> list = (LinkedList<XmiElement.UnresolvedReference>)this.unresolvedExternalRefs.get(href);
        if (list == null) {
            list = new LinkedList<XmiElement.UnresolvedReference>();
            this.unresolvedExternalRefs.put(href, list);
            this.listOfUnresolvedHRefs.add(href);
            this.allUnresolvedHRefs.add(href);
        }
        list.add(element);
    }

    public void resolveExternalReferences() {
        try {
            if (this.listOfUnresolvedHRefs.size() > 0) {
                this.resolver.resolve((XMIReferenceResolver.Client)new Client(this.unresolvedExternalRefs), this.extents[0], this.thisSystemId, this.config, (Collection)this.listOfUnresolvedHRefs);
                this.listOfUnresolvedHRefs = new LinkedList();
                this.unresolvedExternalRefs = new HashMap();
            }
        }
        catch (MalformedXMIException e) {
            throw new DebugException(e.getMessage());
        }
        catch (IOException e) {
            throw new DebugException(e.getMessage());
        }
    }

    public XMIReferenceProvider.XMIReference toXMIReference(String href) {
        int index = href.lastIndexOf(35);
        if (index < 0) {
            index = href.lastIndexOf(124);
        }
        if (index < 0) {
            throw new DebugException("Bad href, # delimiter character missing: " + href);
        }
        String docId = href.substring(0, index);
        String xmiId = href.substring(index + 1, href.length());
        if (xmiId.length() == 0) {
            throw new DebugException("Invalid href format: " + href);
        }
        return new XMIReferenceProvider.XMIReference(docId, xmiId);
    }

    public URL toURL(String systemId) {
        URL doc;
        block7: {
            doc = null;
            try {
                doc = new URL(systemId);
            }
            catch (MalformedURLException e) {
                if (this.docURL == null) break block7;
                String path = this.docURL.getPath();
                String href = systemId;
                int copyTo = path.lastIndexOf("/");
                if (copyTo > -1) {
                    href = path.substring(0, copyTo) + "/" + href;
                }
                try {
                    doc = new URL(this.docURL.getProtocol(), this.docURL.getHost(), href);
                    try {
                        doc.openStream().close();
                    }
                    catch (IOException ioe) {}
                }
                catch (MalformedURLException mue) {}
            }
        }
        return doc;
    }

    public String absoluteSystemId(String id) {
        String result = (String)this.systemIds.get(id);
        if (result == null) {
            URL url = this.toURL(id);
            result = url == null ? id : url.toString();
            this.systemIds.put(id, result);
        }
        return result;
    }

    public void readExternalDocument(String systemId) {
        try {
            boolean temp_isMain = this.isMain;
            String temp_thisSystemId = this.thisSystemId;
            this.isMain = false;
            this.thisSystemId = this.absoluteSystemId(systemId);
            URL doc = this.toURL(systemId);
            if (doc == null) {
                throw new DebugException("Cannot create URL: " + systemId);
            }
            XmiSAXReader reader = new XmiSAXReader(this, this.config);
            this.readDocuments.add(this.thisSystemId);
            reader.read(doc, this.extents, null);
            this.isMain = temp_isMain;
            this.thisSystemId = temp_thisSystemId;
        }
        catch (MalformedURLException e) {
            throw new DebugException(e.getMessage());
        }
        catch (IOException e) {
            throw new DebugException(e.getMessage());
        }
        catch (SAXException e) {
            throw new DebugException(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new DebugException(e.getMessage());
        }
    }

    public String getCurrentDocId() {
        return this.thisSystemId;
    }

    public boolean allReferencesResolved() {
        return this.unresolvedRefs.size() == 0 && this.allUnresolvedHRefs.size() == 0;
    }

    public String getUnresolvedRefId() {
        if (this.unresolvedRefs.size() > 0) {
            Map map = (Map)this.unresolvedRefs.entrySet().iterator().next().getValue();
            return (String)map.keySet().iterator().next();
        }
        if (this.allUnresolvedHRefs.size() > 0) {
            return (String)this.allUnresolvedHRefs.iterator().next();
        }
        return null;
    }

    public static Object resolvePrimitiveValue(PrimitiveType type, String asText) {
        String typeName = type.getName();
        if ("Boolean".equals(typeName)) {
            return Boolean.valueOf(asText.toString());
        }
        if ("Double".equals(typeName)) {
            return new Double(asText.toString());
        }
        if ("Float".equals(typeName)) {
            return new Float(asText.toString());
        }
        if ("Integer".equals(typeName)) {
            return new Integer(asText.toString());
        }
        if ("Long".equals(typeName)) {
            return new Long(asText.toString());
        }
        if ("String".equals(typeName)) {
            return asText == null ? ANNOTATION : asText.toString();
        }
        throw new DebugException("unrecognized type name: " + typeName);
    }

    public RefEnum resolveEnumerationValue(EnumerationType type, String asText) {
        RefBaseObject proxy = this.findProxy((ModelElement)type);
        if (proxy == null) {
            throw new DebugException("Proxy not found: " + type.getName());
        }
        asText = this.labelPrefix(type) + asText;
        try {
            if (proxy instanceof RefClass) {
                return ((RefClass)proxy).refGetEnum((RefObject)type, asText);
            }
            return ((RefPackage)proxy).refGetEnum((RefObject)type, asText);
        }
        catch (InvalidCallException e) {
            throw new DebugException("Error creating literal '" + asText + "'. Probably invalid literal name for enumeration " + type.getName());
        }
    }

    public RefBaseObject findProxy(ModelElement element) {
        RefBaseObject proxy = (RefBaseObject)this.proxies_cache.get(element);
        if (proxy != null) {
            return proxy;
        }
        LinkedList<Namespace> path = new LinkedList<Namespace>();
        Namespace container = element.getContainer();
        while (container != null) {
            path.add(container);
            container = container.getContainer();
        }
        MofPackage mofPackage = (MofPackage)path.removeLast();
        RefPackage refPackage = (RefPackage)this.outermostPackages.get(mofPackage.getName());
        if (refPackage == null) {
            Iterator iter = this.outermostPackages.entrySet().iterator();
            while (iter.hasNext()) {
                RefPackage ref = (RefPackage)iter.next().getValue();
                MofPackage meta = (MofPackage)ref.refMetaObject();
                if (!meta.allSupertypes().contains(mofPackage)) continue;
                refPackage = ref;
                break;
            }
        }
        if (refPackage == null) {
            return null;
        }
        if (path.size() == 0) {
            proxy = refPackage;
        }
        while (path.size() > 0) {
            ModelElement elem = (ModelElement)path.removeLast();
            if (elem instanceof MofPackage) {
                refPackage = refPackage.refPackage((RefObject)elem);
                if (path.size() != 0) continue;
                proxy = refPackage;
                continue;
            }
            if (!(elem instanceof MofClass) || path.size() != 0) break;
            RefClass refClass = refPackage.refClass((RefObject)elem);
            proxy = refClass;
        }
        if (proxy != null) {
            this.proxies_cache.put(element, proxy);
        }
        return proxy;
    }

    public static boolean isMultivalued(StructuralFeature attr) {
        MultiplicityType multType = attr.getMultiplicity();
        int upper = multType.getUpper();
        return upper != 1;
    }

    public static String getQualifiedName(Classifier type) {
        List list = type.getQualifiedName();
        Iterator iter = list.iterator();
        String name = (String)iter.next();
        while (iter.hasNext()) {
            name = name + '.' + (String)iter.next();
        }
        return name;
    }

    public XmiElement resolveValue(XmiElement parent, Classifier type, Attributes attrs) {
        while (type instanceof AliasType) {
            type = ((AliasType)type).getType();
        }
        if (type instanceof PrimitiveType) {
            this.PRIMITIVE_VALUE.init(parent, (PrimitiveType)type, attrs);
            return this.PRIMITIVE_VALUE;
        }
        if (type instanceof EnumerationType) {
            this.ENUMERATION_VALUE.init(parent, (EnumerationType)type, attrs);
            return this.ENUMERATION_VALUE;
        }
        if (type instanceof MofClass) {
            boolean isNull = false;
            if (this.isXmi20) {
                String value = attrs.getValue(this.xmlNsPrefix + "nil");
                isNull = value != null && value.equals("true");
            }
            return new XmiElement.ObjectValues(parent, this, (XmiElement.ReferencesCounter)((Object)parent), isNull);
        }
        if (type instanceof StructureType) {
            return new XmiElement.StructureValues(parent, this, (StructureType)type);
        }
        if (type instanceof CollectionType) {
            throw new DebugException("Collection values are not supported.");
        }
        throw new DebugException("Type not resolved: " + type.getName());
    }

    public static Object defaultValue(Attribute attr) {
        Classifier type = attr.getType();
        if (!(type instanceof PrimitiveType)) {
            return null;
        }
        MultiplicityType multType = attr.getMultiplicity();
        boolean isMultivalued = multType.getUpper() != 1;
        int lower = multType.getLower();
        if (lower == 0) {
            if (isMultivalued) {
                return new LinkedList();
            }
            return null;
        }
        return XmiContext.defaultValue((PrimitiveType)type, isMultivalued, lower);
    }

    public static Object defaultValue(Classifier type) {
        if (type instanceof PrimitiveType) {
            return XmiContext.defaultValue((PrimitiveType)type, false, 1);
        }
        return null;
    }

    private static Object defaultValue(PrimitiveType type, boolean multiValued, int card) {
        Object baseValue = null;
        String typeName = type.getName();
        if ("Boolean".equals(typeName)) {
            baseValue = Boolean.FALSE;
        } else if ("Double".equals(typeName)) {
            baseValue = new Double(0.0);
        } else if ("Float".equals(typeName)) {
            baseValue = new Float(0.0f);
        } else if ("Integer".equals(typeName)) {
            baseValue = new Integer(0);
        } else if ("Long".equals(typeName)) {
            baseValue = new Long(0L);
        } else if ("String".equals(typeName)) {
            baseValue = ANNOTATION;
        }
        if (baseValue == null) {
            return null;
        }
        if (!multiValued) {
            return baseValue;
        }
        LinkedList<Boolean> multiValue = new LinkedList<Boolean>();
        int x = 0;
        while (x < card) {
            multiValue.add((Boolean)baseValue);
            ++x;
        }
        return multiValue;
    }

    public Classifier resolveCorbaType(XmiElement.DataTypeElement.Node node) {
        node = node.firstSubNode();
        String id = node.name;
        if (id.equals("XMI.CorbaTcShort")) {
            return this.resolveCorbaPrimitive(node, "Integer");
        }
        if (id.equals("XMI.CorbaTcLong")) {
            return this.resolveCorbaPrimitive(node, "Integer");
        }
        if (id.equals("XMI.CorbaTcUShort")) {
            return this.resolveCorbaPrimitive(node, "Integer");
        }
        if (id.equals("XMI.CorbaTcULong")) {
            return this.resolveCorbaPrimitive(node, "Integer");
        }
        if (id.equals("XMI.CorbaTcFloat")) {
            return this.resolveCorbaPrimitive(node, "Float");
        }
        if (id.equals("XMI.CorbaTcDouble")) {
            return this.resolveCorbaPrimitive(node, "Double");
        }
        if (id.equals("XMI.CorbaTcBoolean")) {
            return this.resolveCorbaPrimitive(node, "Boolean");
        }
        if (id.equals("XMI.CorbaTcChar")) {
            return this.resolveCorbaPrimitive(node, "Integer");
        }
        if (id.equals("XMI.CorbaTcWChar")) {
            return this.resolveCorbaPrimitive(node, "Integer");
        }
        if (id.equals("XMI.CorbaTcOctet")) {
            return this.resolveCorbaPrimitive(node, "Integer");
        }
        if (id.equals("XMI.CorbaTcString")) {
            return this.resolveCorbaPrimitive(node, "String");
        }
        if (id.equals("XMI.CorbaTcWString")) {
            return this.resolveCorbaPrimitive(node, "String");
        }
        if (id.equals("XMI.CorbaTcLongLong")) {
            return this.resolveCorbaPrimitive(node, "Long");
        }
        if (id.equals("XMI.CorbaTcULongLong")) {
            return this.resolveCorbaPrimitive(node, "Long");
        }
        if (id.equals("XMI.CorbaTcLongDouble")) {
            return this.resolveCorbaPrimitive(node, "Double");
        }
        if (id.equals("XMI.CorbaTcStruct")) {
            return this.resolveCorbaStruct(node);
        }
        if (id.equals("XMI.CorbaTcEnum")) {
            return this.resolveCorbaEnum(node);
        }
        if (id.equals("XMI.CorbaTcAlias")) {
            return this.resolveCorbaAlias(node);
        }
        if (id.equals("XMI.CorbaTcAny")) {
            return this.resolveCorbaPrimitive(node, "String");
        }
        throw new DebugException("Unsupported Corba type: " + id);
    }

    private Classifier resolveCorbaStruct(XmiElement.DataTypeElement.Node node) {
        StructureField field;
        String name = node.tcName;
        StructureFieldClass fieldProxy = this.modelPackage.getStructureField();
        LinkedList<StructureField> fields = new LinkedList<StructureField>();
        Iterator iter = node.subnodes.iterator();
        while (iter.hasNext()) {
            XmiElement.DataTypeElement.Node fieldNode = (XmiElement.DataTypeElement.Node)iter.next();
            String fieldName = fieldNode.tcName;
            Classifier fieldType = this.resolveCorbaType(fieldNode.firstSubNode());
            field = fieldProxy.createStructureField(fieldName, ANNOTATION);
            field.setType(fieldType);
            fields.add(field);
        }
        StructureTypeClass proxyClass = this.modelPackage.getStructureType();
        StructureType struct = proxyClass.createStructureType(name, ANNOTATION, false, false, false, (VisibilityKind)VisibilityKindEnum.PUBLIC_VIS);
        iter = fields.iterator();
        while (iter.hasNext()) {
            field = (StructureField)iter.next();
            field.setContainer((Namespace)struct);
            field.getType().setContainer((Namespace)struct);
        }
        return struct;
    }

    private Classifier resolveCorbaEnum(XmiElement.DataTypeElement.Node node) {
        String name = node.tcName;
        LinkedList<String> labels = new LinkedList<String>();
        Iterator iter = node.subnodes.iterator();
        while (iter.hasNext()) {
            XmiElement.DataTypeElement.Node labelNode = (XmiElement.DataTypeElement.Node)iter.next();
            labels.add(labelNode.tcName);
        }
        EnumerationTypeClass proxyClass = this.modelPackage.getEnumerationType();
        return proxyClass.createEnumerationType(name, ANNOTATION, false, false, false, (VisibilityKind)VisibilityKindEnum.PUBLIC_VIS, labels);
    }

    private Classifier resolveCorbaAlias(XmiElement.DataTypeElement.Node node) {
        String name = node.tcName;
        Classifier type = this.resolveCorbaType(node.firstSubNode());
        AliasType alias = this.modelPackage.getAliasType().createAliasType(name, ANNOTATION, false, false, false, (VisibilityKind)VisibilityKindEnum.PUBLIC_VIS);
        alias.setType(type);
        type.setContainer((Namespace)alias);
        return alias;
    }

    private AliasType resolveCorbaPrimitive(XmiElement.DataTypeElement.Node node, String name) {
        PrimitiveType primitive = this.substCorbaPrimitive(node, name);
        AliasType alias = this.modelPackage.getAliasType().createAliasType(name, ANNOTATION, false, false, false, (VisibilityKind)VisibilityKindEnum.PUBLIC_VIS);
        alias.setType((Classifier)primitive);
        this.aliasesInsteadOfCorbaPrimitives.add(alias);
        return alias;
    }

    private PrimitiveType substCorbaPrimitive(XmiElement.DataTypeElement.Node node, String name) {
        PrimitiveType type;
        if (this.primitiveTypes == null) {
            if (this.modelPackage == null) {
                throw new DebugException("Unable to create PrimitiveType for " + name);
            }
            MofPackageClass proxy = this.modelPackage.getMofPackage();
            Iterator iter = proxy.refAllOfType().iterator();
            while (iter.hasNext()) {
                MofPackage pckg = (MofPackage)iter.next();
                if (!"PrimitiveTypes".equals(pckg.getName())) continue;
                this.primitiveTypesPackage = pckg;
                break;
            }
            this.primitiveTypes = new HashMap();
            if (this.primitiveTypesPackage == null) {
                this.primitiveTypesPackage = proxy.createMofPackage("PrimitiveTypes", ANNOTATION, false, false, false, (VisibilityKind)VisibilityKindEnum.PUBLIC_VIS);
                Tag tag = this.modelPackage.getTag().createTag();
                tag.setTagId("javax.jmi.packagePrefix");
                tag.getValues().add("javax.jmi");
                tag.getElements().add(this.primitiveTypesPackage);
                PrimitiveTypeClass typeProxy = this.modelPackage.getPrimitiveType();
                int x = 0;
                while (x < PRIMITIVE_TYPES.length) {
                    PrimitiveType type2 = typeProxy.createPrimitiveType(PRIMITIVE_TYPES[x], ANNOTATION, false, false, false, (VisibilityKind)VisibilityKindEnum.PUBLIC_VIS);
                    type2.setContainer((Namespace)this.primitiveTypesPackage);
                    this.primitiveTypes.put(PRIMITIVE_TYPES[x], type2);
                    ++x;
                }
            } else {
                Iterator contents = this.primitiveTypesPackage.getContents().iterator();
                while (contents.hasNext()) {
                    ModelElement type3 = (ModelElement)contents.next();
                    if (!(type3 instanceof PrimitiveType)) continue;
                    this.primitiveTypes.put(type3.getName(), type3);
                }
            }
        }
        if ((type = (PrimitiveType)this.primitiveTypes.get(name)) == null) {
            type = this.modelPackage.getPrimitiveType().createPrimitiveType(name, ANNOTATION, false, false, false, (VisibilityKind)VisibilityKindEnum.PUBLIC_VIS);
            type.setContainer((Namespace)this.primitiveTypesPackage);
            this.primitiveTypes.put(name, type);
        }
        return type;
    }

    public void countInstance() {
        ++this.instancesCounter;
    }

    public class Client
    implements XMIReferenceResolver.Client {
        private HashMap refs;

        public Client(HashMap refs) {
            this.refs = refs;
        }

        public void resolvedReference(String href, RefObject obj) {
            this.resolvedReference(href, obj, false);
        }

        public void resolvedReference(String href, RefObject obj, boolean internalCall) {
            if (!internalCall) {
                XMIReferenceProvider.XMIReference xmiRef = XmiContext.this.toXMIReference(href);
                XmiContext.this.putReference(xmiRef.getSystemId(), xmiRef.getXmiId(), obj);
            }
            XmiContext.this.allUnresolvedHRefs.remove(href);
            List list = (List)this.refs.remove(href);
            if (list != null) {
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    ((XmiElement.UnresolvedReference)iter.next()).referenceResolved(obj);
                }
            }
        }
    }
}

