/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.jmi.xmi;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.jmi.reflect.RefPackage;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.xmi.XMIInputConfig;
import org.netbeans.lib.jmi.util.DebugException;
import org.netbeans.lib.jmi.util.Logger;
import org.netbeans.lib.jmi.xmi.InputConfig;
import org.netbeans.lib.jmi.xmi.XmiContext;
import org.netbeans.lib.jmi.xmi.XmiElement;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmiSAXReader
extends DefaultHandler {
    private URL docURL = null;
    private XmiElement currentElement;
    private XmiContext context;
    private HashMap diffs = null;
    private boolean contentIsRead = false;
    private boolean elementIsDeleted = false;
    private int lastTimeStamp = 0;
    private Stack stack = new Stack();
    private Locator locator = null;
    private String rootElementName = null;
    private final Object DELETED = new Integer(0);
    private final Object EMPTY = new Integer(1);
    private XMIInputConfig config;

    public XmiSAXReader() {
        this(null, null);
    }

    public XmiSAXReader(XMIInputConfig config) {
        this(null, config);
    }

    public XmiSAXReader(XmiContext context, XMIInputConfig config) {
        this.context = context;
        this.config = config == null ? new InputConfig() : config;
    }

    public Collection read(InputStream input, String uri, RefPackage[] extents, String encoding) throws IOException, SAXException, ParserConfigurationException {
        InputSource is = new InputSource(input);
        if (encoding != null) {
            is.setEncoding(encoding);
        }
        if (uri != null) {
            is.setSystemId(uri);
        }
        return this.read(is, extents);
    }

    public Collection read(URL url, RefPackage[] extents, String encoding) throws IOException, SAXException, ParserConfigurationException {
        this.docURL = url;
        InputSource is = new InputSource(url.toString());
        if (encoding != null) {
            is.setEncoding(encoding);
        }
        return this.read(is, extents);
    }

    public Collection read(URL url, RefPackage[] extents, String encoding, HashMap diffs) throws IOException, SAXException, ParserConfigurationException {
        this.diffs = diffs;
        return this.read(url, extents, encoding);
    }

    public Collection read(InputSource input, RefPackage[] extents) throws IOException, SAXException, ParserConfigurationException {
        if (this.diffs == null) {
            Logger.getDefault().log("XMI reader started");
        }
        long time = System.currentTimeMillis();
        if (this.context == null) {
            this.context = new XmiContext(extents, this.docURL, this.config);
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(input, (DefaultHandler)this);
        time = System.currentTimeMillis() - time;
        if (this.diffs == null) {
            Logger.getDefault().log("finished, TIME: " + (double)time / 1000.0 + "[s]");
        }
        return this.context.getOutermostObjects();
    }

    void initConsumer(RefPackage pkg) throws SAXException {
        this.context = new XmiContext(new RefPackage[]{pkg}, null, this.config);
    }

    public void startDocument() throws SAXException {
        this.rootElementName = null;
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        try {
            if (this.elementIsDeleted) {
                this.stack.push(this.EMPTY);
                return;
            }
            if (this.rootElementName == null) {
                this.rootElementName = qName;
                this.currentElement = new XmiElement.Document(null, this.context, qName, attrs);
                return;
            }
            if (this.currentElement == null) {
                throw new DebugException("Not an XMI document. Root element must be <XMI>");
            }
            if (qName.equals("XMI.content")) {
                this.stack.push(this.EMPTY);
                this.contentIsRead = true;
            } else {
                if (this.contentIsRead && qName.equals("XMI.extension") || !this.contentIsRead && qName.equals("XMI.extensions")) {
                    this.stack.push(this.DELETED);
                    this.elementIsDeleted = true;
                    return;
                }
                if (this.contentIsRead && this.diffs != null) {
                    String xmiId = attrs.getValue("xmi.id");
                    List list = null;
                    if (xmiId != null) {
                        list = (List)this.diffs.get(xmiId);
                    }
                    if (list != null) {
                        String elementName = null;
                        Iterator iter = list.iterator();
                        LinkedList<XmiElement.Difference.Diff> modifs = new LinkedList<XmiElement.Difference.Diff>();
                        while (iter.hasNext()) {
                            XmiElement.Difference.Diff diff = (XmiElement.Difference.Diff)iter.next();
                            if (diff.timeStamp <= this.lastTimeStamp) continue;
                            switch (diff.kind) {
                                case 1: {
                                    this.stack.push(this.DELETED);
                                    this.elementIsDeleted = true;
                                    return;
                                }
                                case 0: {
                                    modifs.add(diff);
                                    break;
                                }
                                case 2: {
                                    XmiElement.Difference.Item item = (XmiElement.Difference.Item)diff.items.removeFirst();
                                    qName = item.qName;
                                    attrs = item.attrs;
                                    elementName = qName;
                                    diff.items.removeLast();
                                    modifs.add(diff);
                                }
                            }
                        }
                        this.stack.push(new StackElement(modifs, elementName));
                    } else {
                        this.stack.push(this.EMPTY);
                    }
                }
            }
            this.currentElement = this.currentElement.startSubElement(qName, attrs);
            if (this.currentElement == null) {
                throw new DebugException("XmiElement.startSubElement(" + qName + ", ..) returned null");
            }
            if (this.contentIsRead && this.diffs != null) {
                this.applayDiffs();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.getDefault().annotate((Throwable)e, "Error parsing XMI" + this.getLineNumberErrorString());
            throw (SAXException)Logger.getDefault().annotate((Throwable)new SAXException("XMI parsing error" + this.getLineNumberErrorString() + ": " + (e.getMessage() != null ? e.getMessage() : e.toString()), e), (Throwable)e);
        }
    }

    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        try {
            Object obj;
            if (this.elementIsDeleted) {
                if (this.stack.pop() == this.DELETED) {
                    this.elementIsDeleted = false;
                }
                return;
            }
            if (qName.equals("XMI.content")) {
                this.contentIsRead = false;
            } else if (this.contentIsRead && this.diffs != null && (obj = this.stack.pop()) instanceof StackElement && ((StackElement)obj).replacedName != null) {
                qName = ((StackElement)obj).replacedName;
            }
            this.currentElement = this.currentElement.endElement(qName);
            if (this.currentElement == null && !qName.equals(this.rootElementName)) {
                throw new DebugException("XmiElement.endElement(" + qName + ") returned null");
            }
            if (this.contentIsRead && this.diffs != null) {
                this.applayDiffs();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SAXException ne = new SAXException("XMI parsing error" + this.getLineNumberErrorString() + ": " + (e.getMessage() != null ? e.getMessage() : e.toString()), e);
            Logger.getDefault().annotate((Throwable)ne, (Throwable)e);
            throw (SAXException)Logger.getDefault().annotate((Throwable)ne, ne.getMessage());
        }
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        String s = new String(buf, offset, len);
        try {
            if (!this.elementIsDeleted && this.currentElement != null) {
                this.currentElement.characters(buf, offset, len);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SAXException ne = new SAXException("XMI parsing error" + this.getLineNumberErrorString() + ": " + (e.getMessage() != null ? e.getMessage() : e.toString()), e);
            Logger.getDefault().annotate((Throwable)ne, (Throwable)e);
            throw (SAXException)Logger.getDefault().annotate((Throwable)ne, "XMI parsing error" + this.getLineNumberErrorString());
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    private String getLineNumberErrorString() {
        if (this.locator != null) {
            return " at line: " + this.locator.getLineNumber();
        }
        return "";
    }

    public InputSource resolveEntity(String publicID, String systemID) {
        Logger.getDefault().log("resolving reference: " + publicID + ", " + systemID);
        return new InputSource(new StringReader(""));
    }

    private void applayDiffs() throws SAXException {
        Object elem = this.stack.peek();
        if (elem != this.EMPTY) {
            ++((StackElement)elem).position;
            Iterator iter = ((StackElement)elem).diffs.iterator();
            while (iter.hasNext()) {
                XmiElement.Difference.Diff diff = (XmiElement.Difference.Diff)iter.next();
                if (diff.position != ((StackElement)elem).position || diff.timeStamp <= this.lastTimeStamp) continue;
                int temp = this.lastTimeStamp;
                this.lastTimeStamp = diff.timeStamp;
                this.addContent(diff);
                this.lastTimeStamp = temp;
            }
        }
    }

    private void addContent(XmiElement.Difference.Diff diff) throws SAXException {
        Iterator iter = diff.items.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof XmiElement.Difference.Item) {
                XmiElement.Difference.Item item = (XmiElement.Difference.Item)obj;
                if (item.isStart) {
                    this.startElement(null, "", item.qName, item.attrs);
                    continue;
                }
                this.endElement(null, "", item.qName);
                continue;
            }
            this.characters(((String)obj).toCharArray(), 0, ((String)obj).length());
        }
    }

    private static class StackElement {
        public int position = 0;
        public List diffs;
        public String replacedName;

        public StackElement(List diffs, String replacedName) {
            this.diffs = diffs;
            this.replacedName = replacedName;
        }
    }
}

