/*
 * Decompiled with CFR 0.152.
 */
package test.yu.org.goodoldai.air.common.constraint;

import junit.framework.Assert;
import junit.swingui.TestRunner;
import test.yu.org.goodoldai.air.common.constraint.ConstraintTest;
import yu.org.goodoldai.air.common.constraint.Constraint;
import yu.org.goodoldai.air.common.constraint.ConstraintComposite;
import yu.org.goodoldai.air.common.constraint.predefined.IsTypeOfConstraint;

public class ConstraintCompositeTest
extends ConstraintTest {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("test.yu.org.goodoldai.air.common.constraint.ConstraintCompositeTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    protected void setUp() throws Exception {
        super.setUp();
        Constraint constraint = this.getConstraint();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        constraint.add(new IsTypeOfConstraint(clazz, "Test"));
    }

    public ConstraintCompositeTest(String name) {
        super(name);
    }

    protected Constraint createConstraint() {
        return new ConstraintComposite("Test ConstraintComposite");
    }

    protected Object createRightObject() {
        return new Boolean(true);
    }

    protected Object createWrongObject() {
        return new Integer(0);
    }

    public void testAdd() {
        this.getConstraint().clear();
        Constraint constraint = this.getConstraint();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Assert.assertTrue((boolean)constraint.add(new IsTypeOfConstraint(clazz, "Test")));
        Assert.assertTrue((boolean)this.getConstraint().check(this.createRightObject()));
        Assert.assertTrue((!this.getConstraint().check(this.createWrongObject()) ? 1 : 0) != 0);
    }

    public void testGet() {
        this.getConstraint().clear();
        Constraint con = this.createConstraint();
        this.getConstraint().add(con);
        Assert.assertEquals((Object)con, (Object)this.getConstraint().get(0));
    }

    public void testRemoveCondition() {
        Assert.assertTrue((boolean)this.getConstraint().remove(this.getConstraint().get(0)));
        Assert.assertTrue((boolean)this.getConstraint().check(this.createWrongObject()));
    }

    public void testRemoveInt() {
        Assert.assertNotNull((Object)this.getConstraint().remove(0));
        Assert.assertTrue((boolean)this.getConstraint().check(this.createWrongObject()));
    }

    public void testClear() {
        this.getConstraint().clear();
        Assert.assertTrue((boolean)this.getConstraint().check(this.createWrongObject()));
    }

    public final void testIsLeaf() {
        Assert.assertTrue((!this.getConstraint().isLeaf() ? 1 : 0) != 0);
    }
}

