/*
 * Decompiled with CFR 0.152.
 */
package test.yu.org.goodoldai.air.mdr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.jmi.model.ModelPackage;
import javax.jmi.model.MofPackage;
import javax.jmi.reflect.RefPackage;
import javax.jmi.xmi.MalformedXMIException;
import junit.framework.Assert;
import org.netbeans.api.mdr.CreationFailedException;
import test.yu.org.goodoldai.air.mdr.AirRepositoryTestCase;
import test.yu.org.goodoldai.air.mdr.impl.test.TestPackage;
import yu.org.goodoldai.air.mdr.AirMDRepository;

public abstract class AirMDRepositoryTest
extends AirRepositoryTestCase {
    public static final String TEST_METAMODEL_FILEPATH = "resources/testmof.xmi";
    public static final String TEST_METAMODEL_PACKAGE_NAME = "test";
    public static final String TEST_MOF_MODEL_NAME = "TEST";
    static /* synthetic */ Class class$0;

    public AirMDRepositoryTest(String name) {
        super(name);
    }

    public final void testLoadMofModel() {
        try {
            this.loadMofModel();
        }
        catch (CreationFailedException e) {
            Assert.fail((String)("Metamodel cannot be loaded: " + e.getMessage()));
            e.printStackTrace();
        }
        catch (IOException e) {
            Assert.fail((String)"IO Error - this is not a problem within repository");
            e.printStackTrace();
        }
        catch (MalformedXMIException e) {
            Assert.fail((String)"MailformedXMI - this is not a problem within repository");
            e.printStackTrace();
        }
    }

    public final void testLoadMofModelExsisting() {
        try {
            this.getAirMDRepository().beginTrans(true);
            this.loadMofModel();
            this.getAirMDRepository().endTrans(false);
            this.loadMofModel();
        }
        catch (CreationFailedException e) {
            Assert.assertTrue((String)"Metamodel already exists. The new Metamodel can notbe loaded into the repository.", (boolean)true);
            e.printStackTrace();
        }
        catch (IOException e) {
            Assert.fail((String)"IO Error - this is not a problem within the repository");
            e.printStackTrace();
        }
        catch (MalformedXMIException e) {
            Assert.fail((String)"MailformedXMI - this is not a problem within the repository");
            e.printStackTrace();
        }
    }

    public final void testLoadModel() {
        try {
            this.loadMofModel();
            RefPackage model = this.createModel("Model1");
            File file = new File("testModel.xmi");
            this.getAirMDRepository().saveExtent(new FileOutputStream(file), model);
            RefPackage loadedModel = this.getAirMDRepository().loadModel(new FileInputStream(file), "Model2", (MofPackage)model.refMetaObject());
            file.delete();
        }
        catch (CreationFailedException e) {
            Assert.fail((String)("Metamodel cannot be loaded: " + e.getMessage()));
            e.printStackTrace();
        }
        catch (IOException e) {
            Assert.fail((String)"IO Error - this is not a problem within repository");
            e.printStackTrace();
        }
        catch (MalformedXMIException e) {
            Assert.fail((String)"MailformedXMI - this is not a problem within repository");
            e.printStackTrace();
        }
    }

    public void testGetMofModel() throws Exception {
        this.loadMofModel();
        ModelPackage mofModel = this.getAirMDRepository().getMofModel("nonExistingExtent");
        Assert.assertNull((Object)mofModel);
        mofModel = this.getAirMDRepository().getMofModel(TEST_MOF_MODEL_NAME);
        Assert.assertNotNull((Object)mofModel);
        mofModel = this.getAirMDRepository().getMofModel("MOF");
        Assert.assertNotNull((Object)mofModel);
    }

    public void testGetMetaModelPackage() throws Exception {
        Assert.assertNull((Object)this.getAirMDRepository().getMetaModelPackage(TEST_METAMODEL_PACKAGE_NAME, this.getAirMDRepository().getMofModel(TEST_MOF_MODEL_NAME)));
        this.loadMofModel();
        Assert.assertNotNull((Object)this.getAirMDRepository().getMetaModelPackage(TEST_METAMODEL_PACKAGE_NAME, this.getAirMDRepository().getMofModel(TEST_MOF_MODEL_NAME)));
    }

    public void testIsMetaModel() throws Exception {
        this.loadMofModel();
        Assert.assertTrue((boolean)this.getAirMDRepository().isMetaModel(this.getAirMDRepository().getMetaModelPackage(TEST_METAMODEL_PACKAGE_NAME, this.getAirMDRepository().getMofModel(TEST_MOF_MODEL_NAME))));
    }

    public void testGetMetaModels() throws Exception {
        Assert.assertEquals((int)3, (int)this.getAirMDRepository().getMetaModels().size());
        this.loadMofModel();
        Assert.assertEquals((int)4, (int)this.getAirMDRepository().getMetaModels().size());
    }

    public void testGetMetaModelsModelPackage() throws Exception {
        Assert.assertEquals((int)3, (int)this.getAirMDRepository().getMetaModels((ModelPackage)this.getAirMDRepository().getExtent("MOF")).size());
        this.loadMofModel();
        Assert.assertEquals((int)3, (int)this.getAirMDRepository().getMetaModels((ModelPackage)this.getAirMDRepository().getExtent("MOF")).size());
    }

    public void testGetExtents() throws Exception {
        Assert.assertEquals((int)1, (int)this.getAirMDRepository().getExtents().size());
        this.loadMofModel();
        Assert.assertEquals((int)2, (int)this.getAirMDRepository().getExtents().size());
    }

    protected void loadMofModel() throws CreationFailedException, IOException, MalformedXMIException {
        AirMDRepository airMDRepository = this.getAirMDRepository();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("test.yu.org.goodoldai.air.mdr.impl.test.TestPackage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        airMDRepository.loadMofModel(clazz.getResourceAsStream(TEST_METAMODEL_FILEPATH), TEST_MOF_MODEL_NAME);
    }

    protected RefPackage createModel(String modelName) throws CreationFailedException {
        TestPackage test = (TestPackage)this.getAirMDRepository().provideModel(modelName, this.getAirMDRepository().getMetaModelPackage(TEST_METAMODEL_PACKAGE_NAME, this.getAirMDRepository().getMofModel(TEST_MOF_MODEL_NAME)));
        test.getClass1().createClass1().setClass2(test.getClass2().createClass2());
        return test;
    }
}

