/*
 * Decompiled with CFR 0.152.
 */
package yu.org.goodoldai.air.mdr.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jmi.model.ModelPackage;
import javax.jmi.model.MofPackage;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.jmi.xmi.MalformedXMIException;
import org.netbeans.api.mdr.CreationFailedException;
import org.netbeans.api.mdr.MDRManager;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.xmi.XMIReader;
import org.netbeans.api.xmi.XMIReaderFactory;
import org.netbeans.api.xmi.XMIWriter;
import org.netbeans.api.xmi.XMIWriterFactory;
import yu.org.goodoldai.air.mdr.AirMDRepository;

public class AirMDRepositoryImpl
implements AirMDRepository {
    private MDRepository repository;
    static /* synthetic */ Class class$0;

    public AirMDRepositoryImpl(MDRepository repository) {
        AirMDRepositoryImpl.log("[INFO] AirMDRepositoryImpl: Constructor, setting repository: " + repository.getClass().getName());
        this.repository = repository;
        Thread shutDownThread = new Thread(new Runnable(){

            public void run() {
                AirMDRepositoryImpl.this.getRepository().shutdown();
            }
        });
        Runtime.getRuntime().addShutdownHook(shutDownThread);
    }

    public AirMDRepositoryImpl() {
        this(MDRManager.getDefault().getDefaultRepository());
    }

    public ModelPackage loadMofModel(InputStream metaModelInputStream, String extentName) throws CreationFailedException, IOException, MalformedXMIException {
        ModelPackage metaModel = this.provideMofModel(extentName);
        return this.loadMofModel(metaModelInputStream, metaModel);
    }

    public ModelPackage loadMofModel(InputStream metaModelInputStream, ModelPackage mofModel) throws CreationFailedException, IOException, MalformedXMIException {
        XMIReader xmiReader = XMIReaderFactory.getDefault().createXMIReader();
        AirMDRepositoryImpl.log("[INFO] AirMDRepositoryImpl.loadMetaModel: Reading metamodel from InputStream '" + metaModelInputStream.toString() + "';");
        xmiReader.read(metaModelInputStream, null, (RefPackage)mofModel);
        return mofModel;
    }

    public ModelPackage getMofModel(String mofModelName) {
        RefPackage mofModel = this.getExtent(mofModelName);
        if (this.isMofModel(mofModel)) {
            return (ModelPackage)mofModel;
        }
        return null;
    }

    public MofPackage getMetaModelPackage(String mofPackageName, ModelPackage mofModel) {
        if (mofModel == null) {
            return null;
        }
        Iterator it = this.getMetaModels(mofModel).iterator();
        while (it.hasNext()) {
            MofPackage metaModelPackage = (MofPackage)it.next();
            if (!mofPackageName.equals(metaModelPackage.getName())) continue;
            return metaModelPackage;
        }
        return null;
    }

    public boolean isMetaModel(MofPackage mofPackage) {
        return mofPackage != null && mofPackage.getContainer() == null;
    }

    public Collection getMetaModels() {
        LinkedList metaModels = new LinkedList();
        Collection mofModelNames = this.getMofModelNames();
        Iterator it = mofModelNames.iterator();
        while (it.hasNext()) {
            ModelPackage mofModel = (ModelPackage)this.getExtent((String)it.next());
            metaModels.addAll(this.getMetaModels(mofModel));
        }
        return metaModels;
    }

    public Collection getMetaModels(ModelPackage mofModel) {
        LinkedList<MofPackage> result = new LinkedList<MofPackage>();
        if (mofModel == null) {
            return null;
        }
        Iterator it = mofModel.getMofPackage().refAllOfClass().iterator();
        while (it.hasNext()) {
            MofPackage mofPackage = (MofPackage)it.next();
            if (!this.isMetaModel(mofPackage)) continue;
            result.add(mofPackage);
        }
        return result;
    }

    public RefPackage loadModel(InputStream modelInputStream, String modelName, MofPackage metaModel) throws CreationFailedException, IOException, MalformedXMIException {
        RefPackage model = this.provideModel(modelName, metaModel);
        return this.loadModel(modelInputStream, model);
    }

    public RefPackage loadModel(InputStream modelInputStream, RefPackage model) throws CreationFailedException, IOException, MalformedXMIException {
        XMIReader xmiReader = XMIReaderFactory.getDefault().createXMIReader();
        AirMDRepositoryImpl.log("[INFO] AirMDRepositoryImpl.loadModel: Reading model from InputStream '" + modelInputStream.toString() + "';");
        xmiReader.read(modelInputStream, null, model);
        return model;
    }

    public void saveExtent(OutputStream modelOutputStream, RefPackage extent) throws IOException {
        XMIWriter writer = XMIWriterFactory.getDefault().createXMIWriter();
        writer.write(modelOutputStream, extent, "1.2");
    }

    public ModelPackage provideMofModel(String mofModelName) throws CreationFailedException {
        RefPackage mofModel = this.getExtent(mofModelName);
        if (this.isMofModel(mofModel)) {
            return (ModelPackage)mofModel;
        }
        return (ModelPackage)this.createExtent(mofModelName);
    }

    public RefPackage provideModel(String modelName, MofPackage metaModel) throws CreationFailedException {
        RefPackage model = this.getModel(modelName);
        if (model == null) {
            return this.createExtent(modelName, (RefObject)metaModel);
        }
        return model;
    }

    public RefPackage getModel(String modelName) {
        RefPackage model = this.getExtent(modelName);
        if (this.isModel(model)) {
            return model;
        }
        return null;
    }

    public Collection getModelNames() {
        LinkedList<String> result = new LinkedList<String>();
        String[] modelNames = this.getExtentNames();
        int i = 0;
        while (i < modelNames.length) {
            if (this.isModel(modelNames[i])) {
                result.add(modelNames[i]);
            }
            ++i;
        }
        return result;
    }

    public Collection getMofModelNames() {
        LinkedList<String> result = new LinkedList<String>();
        String[] metaModelNames = this.getExtentNames();
        int i = 0;
        while (i < metaModelNames.length) {
            if (this.isMofModel(metaModelNames[i])) {
                result.add(metaModelNames[i]);
            }
            ++i;
        }
        return result;
    }

    private static void log(Object object) {
        System.out.println(object);
    }

    public boolean extentExists(String extentName) {
        return this.getExtent(extentName) != null;
    }

    public boolean isModel(String extentName) {
        return this.isModel(this.getExtent(extentName));
    }

    public boolean isModel(RefPackage extent) {
        return !this.isMofModel(extent);
    }

    public boolean isModelOf(RefPackage model, MofPackage metaModel) {
        if (model == null || metaModel == null) {
            return false;
        }
        if (metaModel.equals((Object)model.refMetaObject())) {
            return true;
        }
        return true;
    }

    public Collection getModels() {
        LinkedList<RefPackage> models = new LinkedList<RefPackage>();
        Iterator it = this.getModelNames().iterator();
        while (it.hasNext()) {
            String modelName = (String)it.next();
            models.add(this.getExtent(modelName));
        }
        return models;
    }

    public Collection getModels(MofPackage metaModel) {
        LinkedList<RefPackage> models = new LinkedList<RefPackage>();
        Iterator it = this.getModelNames().iterator();
        while (it.hasNext()) {
            String modelName = (String)it.next();
            RefPackage model = this.getExtent(modelName);
            if (!this.isModelOf(model, metaModel)) continue;
            models.add(model);
        }
        return models;
    }

    public Collection getExtents() {
        String[] extentNames = this.getExtentNames();
        ArrayList<RefPackage> extents = new ArrayList<RefPackage>(extentNames.length);
        int i = 0;
        while (i < extentNames.length) {
            extents.add(this.getExtent(extentNames[i]));
            ++i;
        }
        return extents;
    }

    public boolean isMofModel(RefPackage extent) {
        return this.isModelOf(extent, this.getMetaModelPackage("Model", (ModelPackage)this.getExtent("MOF")));
    }

    public boolean isMofModel(String extentName) {
        return this.isMofModel(this.getExtent(extentName));
    }

    public void clean() {
        String[] extentNames = this.getExtentNames();
        int i = 0;
        while (i < extentNames.length) {
            RefPackage extent = this.getExtent(extentNames[i]);
            if (!"MOF".equals(extentNames[i])) {
                extent.refDelete();
            } else {
                Collection metaModels = this.getMetaModels((ModelPackage)extent);
                Iterator it = metaModels.iterator();
                while (it.hasNext()) {
                    MofPackage mofPackage = (MofPackage)it.next();
                    if (!mofPackage.getName().equals("CorbaIdlTypes") || !mofPackage.getName().equals("Model") || !mofPackage.getName().equals("PrimitiveTypes")) continue;
                    mofPackage.refDelete();
                }
            }
            ++i;
        }
    }

    public boolean deleteMofPackage(MofPackage metaModel) {
        if (!this.isMetaModel(metaModel)) {
            return false;
        }
        Collection models = this.getModels(metaModel);
        Iterator it = models.iterator();
        while (it.hasNext()) {
            RefPackage model = (RefPackage)it.next();
            model.refDelete();
        }
        metaModel.refDelete();
        return true;
    }

    public String getExtentName(RefPackage extent) {
        String[] extentNames = this.getExtentNames();
        int i = 0;
        while (i < extentNames.length) {
            if (extent.equals((Object)this.getExtent(extentNames[i]))) {
                return extentNames[i];
            }
            ++i;
        }
        return "";
    }

    public RefPackage createExtent(String substName) throws CreationFailedException {
        AirMDRepositoryImpl.log("[INFO] AirMDRepositoryImpl.createExtent: Creating extent '" + substName + "';");
        return this.repository.createExtent(substName);
    }

    public RefPackage createExtent(String substName, RefObject metaPackage) throws CreationFailedException {
        AirMDRepositoryImpl.log("[INFO] AirMDRepositoryImpl.createExtent: Creating extent '" + substName + "', metaPackage '" + metaPackage.getClass().getName() + "';");
        return this.repository.createExtent(substName, metaPackage);
    }

    public RefPackage createExtent(String substName, RefObject metaPackage, RefPackage[] existingPackages) throws CreationFailedException {
        return this.repository.createExtent(substName, metaPackage, existingPackages);
    }

    public RefPackage getExtent(String name) {
        return this.repository.getExtent(name);
    }

    public String[] getExtentNames() {
        return this.repository.getExtentNames();
    }

    public RefBaseObject getByMofId(String mofId) {
        return this.repository.getByMofId(mofId);
    }

    public void beginTrans(boolean writeAccess) {
        this.repository.beginTrans(writeAccess);
    }

    public void endTrans() {
        this.repository.endTrans();
    }

    public void endTrans(boolean rollback) {
        this.repository.endTrans(rollback);
    }

    public void shutdown() {
        this.repository.shutdown();
    }

    public void addListener(MDRChangeListener listener) {
        this.repository.addListener(listener);
    }

    public void addListener(MDRChangeListener listener, int mask) {
        this.repository.addListener(listener, mask);
    }

    public void removeListener(MDRChangeListener listener) {
        this.repository.removeListener(listener);
    }

    public void removeListener(MDRChangeListener listener, int mask) {
        this.repository.removeListener(listener, mask);
    }

    public MDRepository getRepository() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("yu.org.goodoldai.air.mdr.AirMDRepository");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isInstance(this.repository)) {
            return (AirMDRepository)this.repository;
        }
        return this.repository;
    }

    public void saveRefObject(OutputStream modelOutputStream, Collection refObjectCollection) throws IOException {
        XMIWriter writer = XMIWriterFactory.getDefault().createXMIWriter();
        writer.write(modelOutputStream, refObjectCollection, "1.2");
    }

    public boolean deleteMetaModelExtent(ModelPackage modelPackage) {
        return false;
    }
}

