/*
 * Decompiled with CFR 0.152.
 */
package yu.org.goodoldai.air.mdr.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jmi.model.ModelPackage;
import javax.jmi.model.MofPackage;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.jmi.xmi.MalformedXMIException;
import org.netbeans.api.mdr.CreationFailedException;
import org.netbeans.api.mdr.MDRepository;
import yu.org.goodoldai.air.mdr.AirMDRepository;
import yu.org.goodoldai.air.mdr.MetaModelManager;
import yu.org.goodoldai.air.mdr.ModelManager;
import yu.org.goodoldai.air.mdr.impl.AirMDRepositoryImpl;
import yu.org.goodoldai.air.mdr.impl.ModelManagerImpl;

public abstract class MetaModelManagerImpl
implements MetaModelManager {
    private MofPackage metaModelPackage;
    private AirMDRepository repository;
    static /* synthetic */ Class class$0;

    protected MetaModelManagerImpl(MDRepository repository, boolean rewrite) throws CreationFailedException, IOException, MalformedXMIException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("yu.org.goodoldai.air.mdr.AirMDRepository");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.repository = clazz.isInstance(repository) ? (AirMDRepository)repository : new AirMDRepositoryImpl(repository);
        this.init(rewrite);
    }

    protected MetaModelManagerImpl() throws CreationFailedException, IOException, MalformedXMIException {
        this(false);
    }

    protected MetaModelManagerImpl(boolean rewrite) throws CreationFailedException, IOException, MalformedXMIException {
        this(new AirMDRepositoryImpl(), rewrite);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init(boolean rewrite) throws CreationFailedException, IOException, MalformedXMIException {
        ModelPackage metaModelExtent;
        try {
            try {
                this.repository.beginTrans(true);
                if (rewrite) {
                    this.deleteMetaModel();
                }
                if (this.getMetaModel() == null) {
                    metaModelExtent = this.repository.loadMofModel(this.getMetaModelXMI(), this.getMetaModelExtentName());
                    this.metaModelPackage = this.repository.getMetaModelPackage(this.getMetaModelPackageName(), metaModelExtent);
                }
            }
            catch (CreationFailedException e) {
                this.repository.endTrans(true);
                throw new CreationFailedException(e.getMessage());
            }
            catch (IOException e) {
                this.repository.endTrans(true);
                throw new IOException(e.getMessage());
            }
            catch (MalformedXMIException e) {
                this.repository.endTrans(true);
                throw new MalformedXMIException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.repository.endTrans(false);
            metaModelExtent = (ModelPackage)this.repository.getExtent(this.getMetaModelExtentName());
            this.metaModelPackage = this.repository.getMetaModelPackage(this.getMetaModelPackageName(), metaModelExtent);
            throw throwable;
        }
        {
            Object var4_8 = null;
        }
        this.repository.endTrans(false);
        metaModelExtent = (ModelPackage)this.repository.getExtent(this.getMetaModelExtentName());
        this.metaModelPackage = this.repository.getMetaModelPackage(this.getMetaModelPackageName(), metaModelExtent);
    }

    public ModelManager createModelManager(String modelName) {
        return new ModelManagerImpl(modelName, this);
    }

    public abstract String getMetaModelExtentName();

    public abstract String getMetaModelPackageName();

    public abstract InputStream getMetaModelXMI();

    public ModelPackage getMetaModel() {
        return this.repository.getMofModel(this.getMetaModelExtentName());
    }

    public boolean isManagedModel(RefPackage extent) {
        return this.repository.isModelOf(extent, this.getMetaModelPackage());
    }

    public boolean isManagedModel(String extentName) {
        RefPackage extent = this.repository.getExtent(extentName);
        return this.isManagedModel(extent);
    }

    public boolean isManagedMetaModel(String extentName) {
        return this.getMetaModelExtentName().equals(extentName);
    }

    public RefPackage loadModel(InputStream modelInputStream, String modelName) throws CreationFailedException, IOException, MalformedXMIException {
        return this.repository.loadModel(modelInputStream, modelName, this.getMetaModelPackage());
    }

    public void saveModel(OutputStream modelOutputStream, RefPackage model) throws IOException {
        if (this.repository.isModel(model)) {
            this.repository.saveExtent(modelOutputStream, model);
        }
    }

    public RefPackage getModel(String modelName) {
        RefPackage model = this.repository.getModel(modelName);
        if (this.isManagedModel(model)) {
            return model;
        }
        return null;
    }

    public RefPackage provideModel(String modelName) throws CreationFailedException {
        RefPackage model = this.getModel(modelName);
        if (model == null) {
            model = this.repository.createExtent(modelName, (RefObject)this.getMetaModelPackage());
        }
        return model;
    }

    public Collection getManagedModelNames() {
        LinkedList<String> result = new LinkedList<String>();
        String[] modelNames = this.repository.getExtentNames();
        int i = 0;
        while (i < modelNames.length) {
            if (this.isManagedModel(modelNames[i])) {
                result.add(modelNames[i]);
            }
            ++i;
        }
        return result;
    }

    public Collection getManagedModels() {
        LinkedList<RefPackage> result = new LinkedList<RefPackage>();
        Collection modelNames = this.getManagedModelNames();
        Iterator it = modelNames.iterator();
        while (it.hasNext()) {
            result.add(this.getModel((String)it.next()));
        }
        return result;
    }

    public void deleteMetaModel() {
        try {
            Collection managedModels = this.getManagedModels();
            Iterator it = managedModels.iterator();
            while (it.hasNext()) {
                ((RefPackage)it.next()).refDelete();
            }
            this.repository.getMofModel(this.getMetaModelExtentName()).refDelete();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public MDRepository getRepository() {
        return this.repository;
    }

    public RefBaseObject getByMofId(String mofId) {
        RefPackage model;
        RefBaseObject result = this.repository.getByMofId(mofId);
        if (result != null && this.isManagedModel(model = result.refOutermostPackage())) {
            return result;
        }
        return result;
    }

    public MofPackage getMetaModelPackage() {
        return this.metaModelPackage;
    }

    public void beginTrans(boolean writeAccess) {
        this.repository.beginTrans(writeAccess);
    }

    public void endTrans() {
        this.repository.endTrans();
    }

    public void endTrans(boolean rollback) {
        this.repository.endTrans(rollback);
    }
}

