/*
 * Decompiled with CFR 0.152.
 */
package yu.org.goodoldai.air.mdr.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jmi.reflect.RefPackage;
import javax.jmi.xmi.MalformedXMIException;
import org.netbeans.api.mdr.CreationFailedException;
import yu.org.goodoldai.air.mdr.MetaModelManager;
import yu.org.goodoldai.air.mdr.ModelManager;

public class ModelManagerImpl
implements ModelManager {
    private String modelName;
    private MetaModelManager metaModelManager;

    public ModelManagerImpl(String modelName, MetaModelManager metaModelManager) {
        this.metaModelManager = metaModelManager;
        this.modelName = modelName;
    }

    public RefPackage loadModel(InputStream modelInputStream) throws CreationFailedException, IOException, MalformedXMIException {
        return this.loadModel(modelInputStream, false);
    }

    public RefPackage loadModel(InputStream modelInputStream, boolean rewriteExisting) throws CreationFailedException, IOException, MalformedXMIException {
        if (rewriteExisting && this.metaModelManager.isManagedModel(this.modelName)) {
            this.getModel().refDelete();
        }
        return this.metaModelManager.loadModel(modelInputStream, this.modelName);
    }

    public void saveModel(OutputStream modelOutputStream) throws IOException {
        this.metaModelManager.saveModel(modelOutputStream, this.getModel());
    }

    public RefPackage provideModel() throws CreationFailedException {
        return this.metaModelManager.provideModel(this.getModelName());
    }

    public RefPackage getModel() {
        return this.metaModelManager.getModel(this.modelName);
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String newModelName) throws CreationFailedException {
        try {
            this.beginTrans(true);
            RefPackage oldModel = this.getModel();
            this.metaModelManager.loadModel(this.getModelXMI(), newModelName);
            oldModel.refDelete();
            this.modelName = newModelName;
            this.endTrans(false);
        }
        catch (Exception e) {
            this.endTrans(true);
            e.printStackTrace();
            throw new CreationFailedException();
        }
    }

    public InputStream getModelXMI() {
        return null;
    }

    public MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    private void log(Object object) {
        System.out.println(object);
    }

    public void beginTrans(boolean writeAccess) {
        this.metaModelManager.beginTrans(writeAccess);
    }

    public void endTrans() {
        this.metaModelManager.endTrans();
    }

    public void endTrans(boolean rollback) {
        this.metaModelManager.endTrans(rollback);
    }
}

