/*
 * Decompiled with CFR 0.152.
 */
package yu.org.goodoldai.air.wb.core.adaptable.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import yu.org.goodoldai.air.wb.core.adaptable.IAdaptableFactory;
import yu.org.goodoldai.air.wb.core.adaptable.IAdaptableFactoryProvider;
import yu.org.goodoldai.air.wb.core.adaptable.IAdaptableObject;
import yu.org.goodoldai.air.wb.core.adaptable.events.AdaptableObjectEvent;
import yu.org.goodoldai.air.wb.core.adaptable.events.IAdaptableObjectEventSource;
import yu.org.goodoldai.air.wb.core.adaptable.events.IAdaptableObjectListener;

public class AdaptableFactory
implements IAdaptableObjectListener,
IAdaptableFactory {
    private Map adaptables = new HashMap();
    private Map adaptablesCache = new HashMap();
    private Map adaptedObjects = new HashMap();
    private String id;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public AdaptableFactory(String id) {
        this.id = id;
    }

    public Class getAdaptable(Class forClass) {
        Class adaptable = (Class)this.adaptablesCache.get(forClass);
        if (adaptable != null) {
            return adaptable;
        }
        adaptable = this.findAdaptableForClass(forClass);
        if (adaptable != null) {
            return adaptable;
        }
        adaptable = this.findAdaptableForInterfaces(forClass.getInterfaces());
        if (adaptable != null) {
            this.adaptablesCache.put(forClass, adaptable);
            return adaptable;
        }
        return null;
    }

    private Class findAdaptableForClass(Class forClass) {
        if (forClass == null) {
            return null;
        }
        Class adaptable = (Class)this.adaptables.get(forClass);
        if (adaptable == null) {
            adaptable = this.findAdaptableForClass(forClass.getSuperclass());
        }
        return adaptable;
    }

    private Class findAdaptableForInterfaces(Class[] forInterfaces) {
        int i = 0;
        while (i < forInterfaces.length) {
            Class interf = forInterfaces[i];
            Class adaptable = (Class)this.adaptables.get(interf);
            if (adaptable != null) {
                return adaptable;
            }
            if (interf.getInterfaces().length != 0) {
                return this.findAdaptableForInterfaces(interf.getInterfaces());
            }
            ++i;
        }
        return null;
    }

    private Collection computeInterfaces(Class forClass) {
        LinkedList interfacesCollection = new LinkedList();
        Class<?>[] directInterfaces = forClass.getInterfaces();
        int i = 0;
        while (i < directInterfaces.length) {
            interfacesCollection.add(directInterfaces[i]);
            ++i;
        }
        Class superclass = forClass.getSuperclass();
        if (superclass != null) {
            interfacesCollection.addAll(this.computeInterfaces(superclass));
        }
        return interfacesCollection;
    }

    public void registerAdaptable(Class adaptableClass, Class forClass) {
        this.adaptables.put(forClass, adaptableClass);
        this.adaptablesCache.put(forClass, adaptableClass);
    }

    public void unregisterAdaptable(Class adaptableClass) {
        Collection adaptablesColl = this.adaptables.values();
        adaptablesColl.remove(adaptableClass);
        Collection adaptablesCacheColl = this.adaptablesCache.values();
        adaptablesCacheColl.remove(adaptableClass);
    }

    public IAdaptableObject adapt(Object object) {
        if (object == null) {
            return null;
        }
        IAdaptableObject adaptable = null;
        adaptable = this.getAdaptedObject(object);
        if (adaptable != null) {
            return adaptable;
        }
        Class adaptableClass = this.getAdaptable(object.getClass());
        if (adaptableClass == null) {
            return null;
        }
        try {
            adaptable = (IAdaptableObject)adaptableClass.newInstance();
            adaptable.setElement(object);
            this.setupAdditionalInterfaces(adaptable);
            this.adaptedObjects.put(object, adaptable);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return adaptable;
    }

    protected void setupAdditionalInterfaces(IAdaptableObject adaptable) {
        IAdaptableFactoryProvider adaptableFactoryProvider;
        Class<?> clazz;
        IAdaptableObjectEventSource adaptableEventSource;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("yu.org.goodoldai.air.wb.core.adaptable.events.IAdaptableObjectEventSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adaptableEventSource = (IAdaptableObjectEventSource)adaptable.getAdapter(clazz2)) != null) {
            adaptableEventSource.addListener(this);
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("yu.org.goodoldai.air.wb.core.adaptable.IAdaptableFactoryProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adaptableFactoryProvider = (IAdaptableFactoryProvider)adaptable.getAdapter(clazz)) != null) {
            adaptableFactoryProvider.setAdaptableFactory(this);
        }
    }

    private IAdaptableObject getAdaptedObject(Object object) {
        return (IAdaptableObject)this.adaptedObjects.get(object);
    }

    public void change(AdaptableObjectEvent event) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("yu.org.goodoldai.air.wb.core.adaptable.events.AdaptableObjectDeletedEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(event.getClass())) {
            this.adaptedObjects.remove(((IAdaptableObject)event.getSource()).getElement());
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

