/*
 * Decompiled with CFR 0.152.
 */
package yu.org.goodoldai.air.wb.core.adaptable.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import yu.org.goodoldai.air.wb.core.adaptable.IAdaptableFactory;
import yu.org.goodoldai.air.wb.core.adaptable.IAdaptableFactoryManager;
import yu.org.goodoldai.air.wb.core.adaptable.IAdaptableObject;

public class AdaptableFactoryManager
implements IAdaptableFactoryManager {
    private Map adaptableFactories = new HashMap();

    public void addAdaptableFactory(IAdaptableFactory factory) {
        this.adaptableFactories.put(factory.getId(), factory);
    }

    public void removeAdaptableFactory(String id) {
        this.adaptableFactories.remove(id);
    }

    public IAdaptableObject adapt(Object object) {
        Collection factories = this.adaptableFactories.values();
        Iterator it = factories.iterator();
        while (it.hasNext()) {
            IAdaptableFactory factory = (IAdaptableFactory)it.next();
            IAdaptableObject adaptable = factory.adapt(object);
            if (adaptable == null) continue;
            return adaptable;
        }
        return null;
    }

    public IAdaptableObject adapt(Object object, String factoryId) {
        IAdaptableFactory adaptableFactory = (IAdaptableFactory)this.adaptableFactories.get(factoryId);
        if (adaptableFactory == null) {
            return null;
        }
        return adaptableFactory.adapt(object);
    }

    public IAdaptableFactory getAdaptableFactory(String id) {
        return (IAdaptableFactory)this.adaptableFactories.get(id);
    }
}

