class Bug {
  float bugX;
  float bugY;
  float changeX;
  float changeY;
  float bSize;
  //boolean alive;

  Bug(float x, float y, float chgX, float chgY, float sz) {
    bugX = x; 
    bugY = y; 
    changeX = chgX; 
    changeY = chgY; 
    bSize = sz; 
    //alive = true;
  }

  void drawBug() {
    //Drawing the bug 'i'
    pushMatrix();  //save the current coordinate system 
    translate(bugX, bugY);
    //if(alive) {    //if the bug is alive draw it as a normal bug
    //make the bug rotate
    if( changeX <0 ) {
      rotateY(PI);
    } 

    //The rest is exactly the same as the base program except for the last 
    // statement for popMatrix
    fill(0, 0, 60);
    ellipse(0, 0, bSize, bSize);  ////draw ladybug

    //draw the four dots
    fill(150, 150, 0);
    ellipse(-bSize/5, -bSize/5, bSize/6, bSize/6);
    ellipse(-bSize/5, bSize/5, bSize/6, bSize/6);
    ellipse(bSize/5, -bSize/5, bSize/6, bSize/6);
    ellipse(bSize/5, bSize/5, bSize/6, bSize/6);

    //draw the head as an arc
    fill(160, 0, 0);
    ellipseMode(CENTER);
    arc(bSize/2, 0, bSize/4, bSize/4, -PI/2, PI/2);

    //draw its body line and antenna
    stroke(160, 0, 0);
    line (-bSize/2, 0, bSize/2, 0);
    curve(bSize/2, 0, bSize/2, 0, bSize/2+bSize/4, -bSize/6, bSize/2-bSize/4, -bSize/3);
    curve(bSize/2, 0, bSize/2, 0, bSize/2+bSize/4, bSize/6, bSize/2+bSize/4, bSize/3);

    //Show enclosing circle
    noFill();
    stroke(0);
    //ellipse(0, 0, bSize+bSize/4, bSize);
    //}
    popMatrix();  //restore the coordinate system to previous state
  }

  void detectBound() {
    //Here we will check to see if our bug "i" hits the wall
    if (bugX+bSize/2 > width ) {
      //If it did, we will reset it's position to the wall and reverse it's direction
      bugX = width-bSize/2;
      changeX *= -1;
    }
    if (bugX-bSize < 0 ) {
      bugX = bSize;
      changeX *= -1;
    }
    if (bugY+bSize/2> height ) {
      bugY = height-bSize/2;
      changeY *= -1;
    }
    if (bugY-bSize/2 < 0) {
      bugY = bSize/2;
      changeY *= -1;
    }
  }

  boolean detectCollision(Bug otherBug) {

    if ( abs(bugX-otherBug.bugX)<(bSize/2+otherBug.bSize/2) && abs(bugY-otherBug.bugY)<(bSize/2+otherBug.bSize/2)) {
      return true;
    }
    return false;
  }
  void bounce(Bug otherBug) {
    float angle = atan2( bugY - otherBug.bugY, bugX - otherBug.bugX);
    changeX = 1 * cos(angle);
    changeY = 1 * sin(angle);
    //and send the otherBug away in the opposite direction of our angle
    otherBug.changeX = 1 * cos(angle - PI);
    otherBug.changeY = 1 * sin(angle - PI);
  }
  void destroy(ArrayList bugs) {
    bugs.remove(this);
  }
}

