/* IAT 265 Demo for lecture 7
 * Awatar bug - key controlled 
 * Bug objects - stored in an ArrayList
 * Author: Eric Yang
 * Date of creation: Feb 27, 11
 * Date of Modification: June 20,10
 */
import processing.opengl.PGraphicsOpenGL;

float gardenX=0, gardenY=0, gardenW=800, gardenH=600;

//This variable will determine how many bugs are created
int count = 30;
//These Arrays will store the bugs 
ArrayList bugs = new ArrayList();
AvatarBug avtBug;

// Key Mapping for Multi-Input using I/O method
boolean downKey, upKey, leftKey, rightKey;
void keyPressed() {
  if (key == CODED && keyCode == RIGHT) rightKey = true;
  if (key == CODED && keyCode == LEFT) leftKey = true;
  if (key == CODED && keyCode == UP) upKey = true;
  if (key == CODED && keyCode ==DOWN) downKey = true;
}
void keyReleased() {
  if (key == CODED && keyCode == RIGHT) rightKey = false;
  if (key == CODED && keyCode == LEFT) leftKey = false;
  if (key == CODED && keyCode == UP) upKey = false;
  if (key == CODED && keyCode ==DOWN) downKey = false;
}
//method respawn: respawn self at randome location
AvatarBug respawn() {
  return new AvatarBug(width/2, height/2, 4,4,20);
}
//Processing callbacks
void setup() {
  size(800, 600, OPENGL);
  smooth();
  for(int i=0; i<count; i++) {
    bugs.add(new Bug(random(width),random(height), random(-1,1),random(-1,1),random(12,36)));
  }
  avtBug = respawn();
}

void draw() {
  background(255);  //call background to redraw background
  fill(0, 200, 0);
  rect (gardenX, gardenY, gardenW, gardenH);  //draw garden

  //move avatar based on keypressed
  if (rightKey) avtBug.moveRigtht();  // Right Key to move avatar right
  if (leftKey) avtBug.moveLeft();    // Left Key to move avatar left
  if (upKey) avtBug.moveUp();        // Up Key to move avatar up
  if (downKey) avtBug.moveDown();      // Down Key to move avatar up
  
  avtBug.detectBound();

  avtBug.drawBug();
  //Loop through the array to draw and move the bugs one by one
  for(int i=0; i<bugs.size(); i++) {
    //Get bug out of the ArraList
    Bug bugi = (Bug)bugs.get(i);
    //change its position with randomized speed
    bugi.bugX += bugi.changeX;
    bugi.bugY += bugi.changeY;

    //Here we will check to see if our bug "i" hits the wall
    bugi.detectBound();

    //This loop will loop over every bug, here is where we check for a collision
    for (int k = 0; k < bugs.size(); k++) {
      Bug bugk = (Bug)bugs.get(k);
      if(avtBug.detectCollision(bugk) && avtBug.checkHeadOn(bugk)) {
        
        avtBug.eat(bugk);
        //If the avatar bug is dead, respawn
        if(!avtBug.alive) {
          avtBug = respawn();
        }
      }
      //This statement can be understood as:
      //If bug "i" and bug "k" are alive and touching at their edges
      //or intersecting each other AND bug "i" is not bug "k"
      if(i != k) {
        if(bugi.detectCollision(bugk)) {
          bugi.bounce(bugk);
        }
      }
    }
    bugi.drawBug();
  }
}

