// subclass of Bug
class AvatarBug extends Bug {
  AvatarBug(float x, float y, float chgX, float chgY, float sz) {
    super(x, y, chgX, chgY, sz);
  }

  //method eat: eat the other bug if bigger otherwise kill itself
  void eat(Bug otherBug) {
    if(bSize > otherBug.bSize) {
      //grow itself by 10%
      bSize *= 1.1;
    
      //kill the other bug
      otherBug.alive = false;
    }   
    else {
      this.alive = false;
      drawWaves();
    }
  }
  //method for drawing traces after avatar was killed
  void drawWaves() {
    stroke(200, 0, 0);
    noFill();
    for(int i=1; i<=2; i++) {
      ellipse(bugX, bugY, i*bSize, i*bSize);
    }
  }

  boolean checkHeadOn(Bug otherBug) {
    if(changeX*otherBug.changeX < 0 && abs(bugY-otherBug.bugY)< max(bSize/8,otherBug.bugY/8)) {
      return true;
    }
    return false;
  }
  
  //Methods for move left, rigth, up & down
  void moveRigtht(){
    if(changeX < 0)changeX *= -1;
    bugX += changeX;
  }
  
  void moveLeft(){
    if(changeX > 0)changeX *= -1;
    bugX += changeX;
  }
  
  void moveUp(){
    bugY -= changeY;
  }
  void moveDown(){
    bugY += changeY;
  }
  
  //Override parent's drawBug method
  void drawBug() {
    //call parent's drawBug() method to draw a regular bug
    super.drawBug();
    //Draw a center bigger dot on top of parent's version 
    pushMatrix();  //save the current coordinate system 
    translate(bugX, bugY);
    if(alive) {    //if the bug is alive draw it as a normal bug
      //make the bug rotate
      if( changeX <0 ) {
        rotateY(PI);
      } 
      //draw bug body with dark orange
      fill(165, 0, 0);
      //ellipseMode(CORNER);        //set to CORNER so that x,y refers to the top-left corner of its enclosing box
      ellipse(0, 0, bSize, bSize);  ////draw ladybug

      //draw the four dots
      fill(0);
      ellipse(-bSize/5, -bSize/5, bSize/6, bSize/6);
      ellipse(-bSize/5, bSize/5, bSize/6, bSize/6);
      ellipse(bSize/5, -bSize/5, bSize/6, bSize/6);
      ellipse(bSize/5, bSize/5, bSize/6, bSize/6);

      //ellipseMode(CENTER);
      arc(bSize/2, 0, bSize/4, bSize/4, -PI/2, PI/2);

      //redraw the body line
      stroke(0);
      line (-bSize/2, 0, bSize/2, 0);
    }
    popMatrix();  //restore the coordinate system to previous state
  }
}

