/* IAT 265 Demo for lecture 7
 * Awatar bug - key controlled 
 * Author: Eric Yang
 * Date of creation: Feb 27, 11
 * Date of Modification: June 20,10
 */
import processing.opengl.PGraphicsOpenGL;

float gardenX=0, gardenY=0, gardenW=800, gardenH=600;

//This variable will determine how many bugs are created
int count = 30;
//These Arrays will store the bugs 
Bug[] bugs = new Bug[count];
AvatarBug avtBug;

// Key Mapping for Multi-Input using I/O method
boolean downKey, upKey, leftKey, rightKey;
void keyPressed() {
  if (key == CODED && keyCode == RIGHT) rightKey = true;
  if (key == CODED && keyCode == LEFT) leftKey = true;
  if (key == CODED && keyCode == UP) upKey = true;
  if (key == CODED && keyCode ==DOWN) downKey = true;
}
void keyReleased() {
  if (key == CODED && keyCode == RIGHT) rightKey = false;
  if (key == CODED && keyCode == LEFT) leftKey = false;
  if (key == CODED && keyCode == UP) upKey = false;
  if (key == CODED && keyCode ==DOWN) downKey = false;
}
//method respawn: respawn self at randome location
AvatarBug respawn() {
  return new AvatarBug(width/2, height/2, 4,4,20);
}
//Processing callbacks
void setup() {
  size(800, 600, OPENGL);
  smooth();
  for(int i=0; i<count; i++) {
    bugs[i] = new Bug(random(width),random(height), random(-1,1),random(-1,1),random(12,36));
  }
  avtBug = respawn();
}

void draw() {
  background(255);  //call background to redraw background
  fill(0, 200, 0);
  rect (gardenX, gardenY, gardenW, gardenH);  //draw garden

  //move avatar based on keypressed
  if (rightKey) avtBug.moveRigtht();  // Right Key to move avatar right
  if (leftKey) avtBug.moveLeft();    // Left Key to move avatar left
  if (upKey) avtBug.moveUp();        // Up Key to move avatar up
  if (downKey) avtBug.moveDown();      // Down Key to move avatar up
  
  avtBug.detectBound();

  avtBug.drawBug();
  //Loop through the array to draw and move the bugs one by one
  for(int i=0; i<count; i++) {
    //change its position with randomized speed
    bugs[i].bugX += bugs[i].changeX;
    bugs[i].bugY += bugs[i].changeY;

    //Here we will check to see if our bug "i" hits the wall
    bugs[i].detectBound();

    //This loop will loop over every bug, here is where we check for a collision
    for (int k = 0; k < count; k++) {

      if(bugs[k].alive && avtBug.detectCollision(bugs[k]) && avtBug.checkHeadOn(bugs[k])) {
        
        avtBug.eat(bugs[k]);
        //If the avatar bug is dead, respawn
        if(!avtBug.alive) {
          avtBug = respawn();
        }
      }
      //This statement can be understood as:
      //If bug "i" and bug "k" are alive and touching at their edges
      //or intersecting each other AND bug "i" is not bug "k"
      if(bugs[i].alive && bugs[k].alive && i != k) {
        if(bugs[i].detectCollision(bugs[k])) {
          bugs[i].bounce(bugs[k]);
        }
      }
    }
    bugs[i].drawBug();
  }
}

