proc handle_kp {a k} {
   if {$a != {}} {return -code break}
   if {$k == "Delete"} {return -code break}
}


toplevel .bmehelp

source [file join [file dirname [info script]] bme_bmp.tcl]


text .bmehelp.t -width 68 -height 8 -font {times 13} -wrap word\
                  -spacing3 13p -padx 4 -pady 4 -setgrid 1\
                  -yscrollcommand {.bmehelp.sb set}
scrollbar .bmehelp.sb -command {.bmehelp.t yview} -orient vertical
pack .bmehelp.sb -side right -fill y
pack .bmehelp.t -fill both -expand 1

bind .bmehelp.t <KeyPress> {handle_kp %A %K}

.bmehelp.t insert end "Help for bitmap editor" title
.bmehelp.t tag configure title -font {helvetica 15 bold} -foreground blue\
            -justify center

.bmehelp.t insert end "\n     The bme program lets you design simple monochrome\
                        bitmaps, and output them in the peculiar format required\
                        by Tk's image create command."

.bmehelp.t insert end "\n     The program starts up by default with a 16x16 bitmap\
                        size. You can change this by entering numbers in the width\
                        and height entry boxes, and clicking the Reset button.\
                        The Reset button may be clicked at any time to clear and\
                        reinitialize the bitmap."

.bmehelp.t insert end "\n     Simple drawing is done by clicking with the left mouse\
                        button in the displayed grid. Each click toggles the state\
                        of the square clicked. If you hold down Control and click,\
                        a line is drawn (by toggling) between the last clicked point\
                        and the current point. If you hold down Shift and click,\
                        a filled rectangle is drawn between last and current points."

.bmehelp.t insert end "\n     The Input button lets you read in existing .xbm files\
                        for modification. The current bitmap will be destroyed."

.bmehelp.t insert end "\n     The Output button brings up a file selection dialogue.\
                        When you select a file name, the bitmap is written to that file\
                        in .xbm format. The contents of the file are\
                        suitable for use with the image create bitmap command."

.bmehelp.t insert end "\n     You can select an area of the bitmap by clicking and\
                        dragging with the right mouse button. Click outside of the\
                        grid, or press Esc to cancel the selection."


.bmehelp.t insert end "\n     The twelve tool buttons at the lower right perform\
                        operations on the selected region, if there is one, or otherwise\
                        on the whole bitmap.\n"
                        
.bmehelp.t window create end -create "button .bmehelp.t.b1 -image $bm_uarrow"
.bmehelp.t window create end -create "button .bmehelp.t.b2 -image $bm_darrow"
.bmehelp.t window create end -create "button .bmehelp.t.b3 -image $bm_larrow"
.bmehelp.t window create end -create "button .bmehelp.t.b4 -image $bm_rarrow"

.bmehelp.t insert end " These buttons move the selection, or the whole image, one\
                        pel in the indicated direction. Pels shifted off the edges\
                        are lost. If there is a selection, the selected area is not\
                        moved; rather the contents of the selection are moved within\
                        its boundaries.\n"


.bmehelp.t window create end -create "button .bmehelp.t.b5 -image $bm_osquare"
.bmehelp.t insert end " This button fills selection or whole image with white.\n"

.bmehelp.t window create end -create "button .bmehelp.t.b6 -image $bm_fsquare"
.bmehelp.t insert end " This button fills selection or whole image with black.\n"

.bmehelp.t window create end -create "button .bmehelp.t.b7 -image $bm_cboard"
.bmehelp.t insert end " This button does a 'chessboard' fill.\n"

.bmehelp.t window create end -create "button .bmehelp.t.b8 -image $bm_hsquare"
.bmehelp.t insert end " This button inverts all bits in selection or whole image.\n"

.bmehelp.t window create end -create "button .bmehelp.t.b9 -image $bm_vmup"
.bmehelp.t window create end -create "button .bmehelp.t.ba -image $bm_vmdn"
.bmehelp.t window create end -create "button .bmehelp.t.bb -image $bm_hmr"
.bmehelp.t window create end -create "button .bmehelp.t.bc -image $bm_hml"

.bmehelp.t insert end " These buttons fill one half of the selection or image\
                        with the mirror image of the other half. Data is replicated\
                        (by reflection) in the direction indicated by the arrow.\n"
