/* This program converts Hershey glyph strings from Peter Holzmann's
   internet distribution into tcl lists
   
   The input must be a file in the style of the .oc1 etc. files from
   the above distribution. Output is to stdout, which can be redirected.

   The input file is expected to have glyph descriptions that occupy one
   line each. The P. H. distribution contains some glyphs that extend
   over 2 or more lines. These must be concatenated into single lines
   before running this program.

   The output of this program is one line per glyph, beginning with 4
   decimal integers denoting Hershey glyph number, word count, left
   margin and right margin. These are followed by a variable number of
   tcl lists, one list for each stroke in the glyph.
*/

#include <stdio.h>
#include <stdlib.h>

char b[500];

main(int argc, char *argv[])
{
   FILE *in;
   int i;
   char c, *p;

   if(argc < 2) barf("Give Hershey file name as argument", "");

   in = fopen(argv[1], "rt");
   if (in == NULL) barf("Can't open", argv[1]);
   
   while (NULL != fgets(b, 500, in))
   {  for(i=0;  i<=4;  i++) putchar(b[i]);
      if(b[5] != ' ') putchar (' ');
      for(i=5;  i<=7;  i++) putchar(b[i]);
      
      printf(" %d %d", b[8]-'R', b[9]-'R');
      p = b + 10;
      printf(" {");
      while (0 != (c = *p++))
      {  if(c == '\n') break;
         if (c != ' ')
         {  i = c - 'R';
            printf(" %d", i);
         }
         else
         {  printf("} {");
            if(*p != 'R') barf("\nBad glyph string:", p);
            p++;
         }
      }
      printf("}\n");
   }
}


barf(char *s1, char *s2)
{
   fprintf(stderr, "%s %s\n", s1, s2);
   exit(1);
}
