# this program uses the hershoc.htc file which contains tcl list forms
# of all of the Hershey occidental glyphs. It generates ASCII-like 
# .htc encodings based on the .hmp encoding files of Peter Holzmann.

# each .htc file contains a series of tcl encodings, one per line, of
# ASCII characters 32 to 126, with degree sign in position 127, 
# Holtzmann style

   set name {cyrilc gothgbt gothgrt gothitt greekc greekcs greekp\
             greeks italicc italiccs italict romanc romancs romand\
             romanp romans romant scriptc scripts }


   set f [open "hershoc.htc" r]

   while {0 < [gets $f z]} {
      set k [lindex $z  0]
      set d($k) $z
   }
   close $f

foreach n $name {
   set in [file join ${n}.hmp]
   set fin [open $in r]
   set out [file join ${n}.htc]
   set fout [open $out w]

   set glist {}
   while {0 < [gets $fin z]} {
      if {-1 == [string first "-" $z]} {
         foreach i $z {
            lappend glist $i
         }
      } else {
         set m [split $z "-"]
         for {set i [lindex $m 0]} {$i <= [lindex $m 1]} {incr i} {
            lappend glist $i
         }
      }
   }
   foreach i $glist {
      puts $fout $d($i)
   }
   close $fin
   close $fout
}
         
