
proc hershey_glyph {win glist x y {scale 1} {lineparms {}} {angle 0}} {

# draw, in window win, the Hershey glyph encoded in the list glist
# with bottom left at x, y. The raw glyph strokes will be scaled by
# scale before drawing, and rendered at angle angle (degrees, counter-
# clockwise from horizontal (NYI!)
# lineparms will be appended to the canvas create command that draws
# the lines of the glyph
   
# glist consists of glyph no, Hershey pair count, left margin
# right margin, all as integers. This is followed by a tcl
# list of coordinates for each stroke. These are lists of
# x, y pairs, with the Hershey "R" bias removed

# The Hershey encodings assume 0 at top for y values.
#
# This routine assumes 'normal' fonts which have a bottom coordinate
# of -9, and moves up accordingly.
   
# This proc returns (right margin - left nmargin + 1), which is a
# reasonable distance to advance when drawing strings.

   set lmar [lindex $glist 2]
   set rmar [lindex $glist 3]
   set n [llength $glist]

if {$angle == 0} {
   set xoff [expr {$x - $lmar * $scale}]
   set yoff [expr {$y - 9 * $scale}]

   for {set i 4} {$i < $n} {incr i} {
      set plist {}
      foreach {x2 y2} [lindex $glist $i] {
         lappend plist [expr {$xoff + $scale * $x2}] [expr {$yoff + $scale * $y2}]
      }
      if {$plist == {}} continue
      eval $win create line $plist $lineparms
   }
} else {
   set s [expr {sin(0.0174532925199433 * -$angle)}]
   set c [expr {cos(0.0174532925199433 * $angle)}]
   
   set xoff [expr {$x + $scale * (-$lmar * $c + 9 * $s)}]
   set yoff [expr {$y + $scale * (-9 * $c - $lmar * $s)}]

   for {set i 4} {$i < $n} {incr i} {
      set plist {}
      foreach {x2 y2} [lindex $glist $i] {
         set px [expr {$x2 * $c - $y2 * $s}]
         set py [expr {$x2 * $s + $y2 * $c}]
         lappend plist [expr {$xoff + $scale * $px}] [expr {$yoff + $scale * $py}]
      }
      if {$plist == {}} continue
      eval $win create line $plist $lineparms
   }
}
   return [expr {round ($scale * ($rmar - $lmar + 1))}]
}



proc hershey_left_margin {glist} {
# return the left margin of specified glyph

   return [lindex $glist 2]
}


proc hershey_right_margin {glist} {
# return the left margin of specified glyph

   return [lindex $glist 3]
}


proc hershey_overstrike {win g1 g2 x y {scale 1} {lineparms {}} {angle 0}} {
# overstrike the glyphs g1 g2 at position x, y
   
   set dx1 [hershey_glyph $win $g1 $x $y $scale $lineparms $angle]
#puts $dx1
   set xx [expr {$x + [hershey_left_margin $g2] - [hershey_left_margin $g1]}]
#puts $xx
   set dx2 [hershey_glyph $win $g2 $xx $y $scale $lineparms $angle]
#puts $dx2
# allow for the fact that Hershey glyphs are centered at 0, whereas we
# draw the left margin at specified coordinate x

   return [expr { ($dx2 > $dx1) ? $dx2 : $dx1}]

# angle STILL TO DO 
}



proc hershey_draw_string {win str fa x y {scale 1} {lineparms {}} {angle 0}} {
# draw string in str with font loaded in fa
 
   set sl [split $str {}]
   set xx $x
   set yy $y
   set s [expr {sin(0.0174532925199433 * -$angle)}]
   set c [expr {cos(0.0174532925199433 * $angle)}]

   upvar $fa f
   foreach i $sl {
      set dx [hershey_glyph $win $f($i) $xx $yy $scale $lineparms $angle]
      set xx [expr {$xx + $dx * $c}]
      set yy [expr {$yy + $dx * $s}]
   }
}



proc hershey_load_font {file fa} {
# load a font encoded as tcl (.htc file) and store glyphs in array
# fa, indexed by ASCII characters
   
   upvar $fa ar
   set f [open $file r]

   for {set i 32} {$i < 128} {incr i} {
      if {0 >= [gets $f d]} break
      set m [binary format c $i]
      set ar($m) $d
   }
}



hershey_load_font "romanc.htc" rc

catch {destroy .c}
canvas .c -height 400 -width 700 -bg white
pack .c
#.c create line 100 0 100 199 -fill red
#.c create line 0 100 399 100 -fill red

   hershey_draw_string .c " !\"#$%&'()*+,-./" rc 10 50 1 {-fill blue}
   hershey_draw_string .c "0123456789:;<=>?" rc 10 100 1 {-fill red}
   hershey_draw_string .c "ABCDEFGHIJKLMNOPQRSTUVWXYZ\[\\\]^_`" rc 10 150 1 {-fill #cc0080}
   hershey_draw_string .c "abcdefghijklmnopqrstuvwxyz{|}~" rc 10 200 1 {-fill #004040}


wm deiconify .
raise .
