
proc hershey_glyph {win glist x y {scale 1} {lineparms {}} {angle 0}} {

# draw, in window win, the Hershey glyph encoded in the list glist
# with bottom left at x, y. The raw glyph strokes will be scaled by
# scale before drawing, and rendered at angle angle (degrees, counter-
# clockwise from horizontal (NYI!)
# lineparms will be appended to the canvas create command that draws
# the lines of the glyph
   
# glist consists of glyph no, Hershey pair count, left margin
# right margin, all as integers. This is followed by a tcl
# list of coordinates for each stroke. These are lists of
# x, y pairs, with the Hershey "R" bias removed

# The Hershey encodings assume 0 at top for y values.
#
# This routine assumes 'normal' fonts which have a bottom coordinate
# of -9, and moves up accordingly.
   
# This proc returns (right margin - left nmargin + 1), which is a
# reasonable distance to advance when drawing strings.

if {$angle == 0} {
   set lmar [lindex $glist 2]
   set rmar [lindex $glist 3]
   set n [llength $glist]

   set xoff [expr {$x - $lmar * $scale}]
   set yoff [expr {$y - 9 * $scale}]

   for {set i 4} {$i < $n} {incr i} {
      set plist {}
      foreach {x2 y2} [lindex $glist $i] {
         lappend plist [expr {$xoff + $scale * $x2}] [expr {$yoff + $scale * $y2}]
      }
      if {$plist == {}} continue
      eval $win create line $plist $lineparms
   }
   return [expr {round ($scale * ($rmar - $lmar + 1))}]
} else {
}
}


proc hershey_draw_string {win str fa x y {scale 1} {lineparms {}} {angle 0}} {
# draw string in str with font loaded in fa
 
   set sl [split $str {}]
   set xx $x
   set q $fa
   upvar $q f
   foreach i $sl {
      incr xx [hershey_glyph $win $f($i) $xx $y $scale $lineparms $angle]
   }
}



proc hershey_load_font {file fa} {
# load a font encoded as tcl (.htc file) and store glyphs in array
# fa, indexed by ASCII characters
   
   upvar $fa ar
   set f [open $file r]

   for {set i 32} {$i < 128} {incr i} {
      if {0 >= [gets $f d]} break
      set m [binary format c $i]
      set ar($m) $d
   }
}



hershey_load_font "romanc.htc" rc
hershey_load_font "romancs.htc" rcs
hershey_load_font "romanp.htc" rp

catch {destroy .c}
canvas .c -height 300 -width 850 -bg white
pack .c
 
   hershey_draw_string .c "c:1:1 AaBbCcDdEe  12345 +_<>*{}(6)" rc 50 40 1 {-width 1  -fill blue}
   hershey_draw_string .c "c:1.3:1 AaBbCcDdEe  12345 +_<>*{}(6)" rc 50 80 1.3 {-width 1  -fill blue}
   hershey_draw_string .c "c:1.3:2 AaBbCcDdEe  12345 +_<>*{}(6)" rc 50 120 1.3 {-width 2  -fill blue}
   hershey_draw_string .c "cs:2:2 AaBbCcDdEe  12345 +_<>*{}(6)" rcs 50 160 2 {-width 2  -fill blue}
   hershey_draw_string .c "cs:2:1 AaBbCcDdEe  12345 +_<>*{}(6)" rcs 50 200 2 {-width 1  -fill blue}

wm deiconify .
raise .
