# Windows Makefile for Microsoft Visual C++
# 2003/7/19 IVB

HOME = c:\project\dartmouth
BIN = $(HOME)\bin
DEBUG = $(HOME)

CC = "CL" 
LIB = "c:\Program Files\Microsoft Visual Studio\VC98\Bin\LIB"
LINK = "LINK"
Inc32 = "c:\Program Files\Microsoft Visual Studio\VC98\Include"
Lib = "c:\Program Files\Microsoft Visual Studio\VC98\Lib" 

OPT_DEBUG   = -DEBUG      -Od -Zi -Gm
OPT_RELEASE = -D "NDEBUG" -Og -O2

OPT =  $(OPT_DEBUG) /TP  -MLd -W3 -GX     -D "WIN32" \
          -D "_CONSOLE" -D "_MT" -D "_DLL" -D "_X86" 

INC = -I$(HOME) -I$(Inc32)


CCFLAGS = $(OPT) $(INC)


linkflags= \
 /WARN:3  /subsystem:console  /incremental:yes \
  /machine:I386 /pdbtype:sept  /debug 


LDIR =    msvcrt.lib /nodefaultlib:libcd.lib 

.cpp.obj:
	$(CC) -c $(CCFLAGS)  $*.cpp

.c.obj:
	$(CC) -c $(CCFLAGS)  $*.c

.cc.obj:
	$(CC) -c $(CCFLAGS)  $*.cc


# -----------------------------------------------------
all : PACKETIZE DEPACKETIZE

PACKETIZE = \
	$(HOME)\packetize.obj \
	$(HOME)\Arith.obj \
	$(HOME)\BitIO.obj \
	$(HOME)\iHisto.obj \
	$(HOME)\IntCoding.obj \
	$(HOME)\allocator.obj \
	$(HOME)\coder.obj \
	$(HOME)\coeffset.obj \
	$(HOME)\entropy.obj \
	$(HOME)\filter.obj \
	$(HOME)\global.obj \
	$(HOME)\image.obj \
	$(HOME)\quantizer.obj \
	$(HOME)\transform.obj \
	$(HOME)\wavelet.obj \
	$(HOME)\conceal.obj \
	$(HOME)\packet.obj
	

DEPACKETIZE = \
	$(HOME)\depacketize.obj \
	$(HOME)\Arith.obj \
	$(HOME)\BitIO.obj \
	$(HOME)\iHisto.obj \
	$(HOME)\IntCoding.obj \
	$(HOME)\allocator.obj \
	$(HOME)\coder.obj \
	$(HOME)\coeffset.obj \
	$(HOME)\entropy.obj \
	$(HOME)\filter.obj \
	$(HOME)\global.obj \
	$(HOME)\image.obj \
	$(HOME)\quantizer.obj \
	$(HOME)\transform.obj \
	$(HOME)\wavelet.obj \
	$(HOME)\conceal.obj \
	$(HOME)\packet.obj
	

# ---------------------------------------------------

packetize: $(PACKETIZE)
	$(LINK) $(PACKETIZE) -out:$(BIN)\packetize.exe $(LDIR) /pdb:"$(DEBUG)\packetize.pdb" $(linkflags)
	
depacketize: $(DEPACKETIZE)
	$(LINK) $(DEPACKETIZE) -out:$(BIN)\depacketize.exe $(LDIR) /pdb:"$(DEBUG)\depacketize.pdb" $(linkflags)	 
# ---------------------------------------------------

