#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>


int main (int argc, char **argv)
{
  long int prev, plost;
  int status, start, rows, nlost;
  float time, ptime, ftime, loss, dpncpsnr, dpcpsnr, bpcpsnr, bpncpsnr;
  FILE *simfile, *dpncfile, *dpcfile, *bpcfile, *bpncfile, *outfile;
  char *noloss = "0.000000 31.802370 31.802370 31.802370 31.802370\n";
  
  
  char *program = argv[0];

  if (argc < 6)  {
    fprintf (stderr, "Usage: %s [simulation file][DPNC file]
    [DPC file][BPC file][BPNC file][output file]\n", program);
    exit(0);
  }

  char *simfile_name = argv[1];
  char *dpncfile_name = argv[2];
  char *dpcfile_name = argv[3];
  char *bpcfile_name = argv[4];
  char *bpncfile_name = argv[5];
  char *outfile_name = argv[6];
  
  printf ("Reading files %s %s %s %s %s, writing %s\n\n", simfile_name, 
       dpncfile_name, dpcfile_name, bpcfile_name, bpncfile_name, outfile_name);
  
  if ((simfile = fopen(simfile_name, "r")) == NULL)
    printf ("Unable to open file %s\n", simfile_name);	  
  
  if ((dpncfile = fopen(dpncfile_name, "r")) == NULL)
    printf ("Unable to open file %s\n", dpncfile_name);	  
    
  if ((dpcfile = fopen(dpcfile_name, "r")) == NULL)
    printf ("Unable to open file %s\n", dpcfile_name);	  
  
  if ((bpcfile = fopen(bpcfile_name, "r")) == NULL)
    printf ("Unable to open file %s\n", bpcfile_name);
    
  if ((bpncfile = fopen(bpncfile_name, "r")) == NULL)
    printf ("Unable to open file %s\n", bpncfile_name);
      
  if ((outfile = fopen(outfile_name, "w")) == NULL)
    printf ("Unable to open file %s\n", outfile_name);	  
    
  // First line
  fprintf(outfile, "0.000000 %s", noloss);
  
  rows = 1;
  prev = 0;
  start = 1;
  ptime = 0.0;
  nlost = 0;
  
  while(!feof(simfile))
  {
    if (feof(simfile))
      //fprintf(outfile, "10000\n"); //??
      { }
    else 
    {
      if (fscanf(simfile, "%f %ld", &time, &plost) != 2)
        printf("Error reading %s, last read %ld\n", simfile_name, prev);
      //fprintf(outfile, "10000\n"); //??
      
      if (plost/16 > prev/16 | feof(simfile))          // new set of 16?
      {
        if (!start | feof(simfile))
        {
          fscanf(dpncfile, "%f", &dpncpsnr);    // read PSNR for the previous set
          fscanf(dpcfile, "%f", &dpcpsnr);
          fscanf(bpcfile, "%f", &bpcpsnr);
          fscanf(bpncfile, "%f", &bpncpsnr);
          loss = (float)nlost/16.0;
          // write results for previous set
          fprintf(outfile, "%f %f %f %f %f %f\n", ftime, loss, dpncpsnr, 
                                                  dpcpsnr, bpcpsnr, bpncpsnr);
          fprintf(outfile, "%f %f %f %f %f %f\n", ptime, loss, dpncpsnr, 
                                                  dpcpsnr, bpcpsnr, bpncpsnr);
          rows += 2;
        
          if (plost/16 > prev/16 +1)      // if not consecutive sets
          {
            // insert no loss portion
            fprintf(outfile, "%f %s", ptime, noloss);
            fprintf(outfile, "%f %s", time, noloss);
            rows += 2;
          }
        }
        else
        {
          fprintf(outfile, "%f %s", time, noloss);
          rows++;
        }
        
        ftime = time;
        nlost = 1;
      }
      else
        nlost++;
      
      ptime = time;
      prev = plost;
    }
    start = 0;
  }
  
  fclose(simfile);
  fclose(dpncfile);
  fclose(dpcfile);
  fclose(bpcfile);
  fclose(bpncfile);
  fprintf(outfile, "Number of rows: %d", rows);
  fclose(outfile);
}