#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>


int main (int argc, char **argv)
{
  long int prev, plost;
  int status, start;
  float time;
  FILE *infile, *outfile;
  
  
  char *program = argv[0];

  if (argc < 2)  {
    fprintf (stderr, "Usage: %s [simulation file][output file]\n", program);
    exit(0);
  }

  char *infile_name = argv[1];
  char *outfile_name = argv[2];
  
  printf ("Reading simulation file %s, writing %s\n\n", 
	  infile_name, outfile_name);
  
  if ((infile = fopen(infile_name, "r")) == NULL)
    printf ("Unable to open file %s\n", infile_name);	  
  
  if ((outfile = fopen(outfile_name, "w")) == NULL)
    printf ("Unable to open file %s\n", outfile_name);	  
  
  prev = 0;
  start = 1;
  
  while(!feof(infile))
  {
    if (feof(infile))
      fprintf(outfile, "10000\n");
    else if (fscanf(infile, "%f %ld", &time, &plost) != 2)
    {
      printf("Error reading %s, last read %ld\n", infile_name, prev);
      fprintf(outfile, "10000\n");
    }
    else
    {
      if (plost/16 > prev/16 && !start)          // new set of 16?
        fprintf(outfile, "10000\n");
      
      prev = plost;
      plost = plost%16;
      
      fprintf(outfile, "%d ", plost);
    }
    start = 0;
  }
  
  fclose(infile);
  fclose(outfile);
}