/*---------------------------------------------------------------------------*/
#ifndef _METRIC_
#define _METRIC_
/*---------------------------------------------------------------------------*/
class ErrorMetric {
public:
  virtual ~ErrorMetric () {};
  virtual Real operator()(Real x) = 0;
};

/*---------------------------------------------------------------------------*/
class LpError : public ErrorMetric {
public:
  LpError (Real newP) { p = newP; };
  ~LpError () {};

  Real operator()(Real x) { return pow(fabs(x),p); };
  Real p;
};

/*---------------------------------------------------------------------------*/
#endif
/*---------------------------------------------------------------------------*/
