/* Functions for packet object  */
/* IVB, 5/14/2001 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <iostream.h>
#include <iomanip.h>

#include "global.h"
#include "packet.h"


PacketEnc::PacketEnc (MultiLayerCoder *entropyLL, MultiLayerCoder *entropyHF) :
  entropyLL (entropyLL), entropyHF (entropyHF)
{
  rate = 0; temp = 0;
  
  entropyLL->reset(0);
  entropyHF->reset(0);
  
  //entropyLL = (MultiLayerCoder *) new LayerCoder (4, 0, 512); //nQuant = 4, capacity = 512
  //entropyHF = (MultiLayerCoder *) new LayerCoder (4, 1, 512); 
}

PacketEnc::~PacketEnc ()
{
  //delete entropyLL;
  //delete entropyHF;
}

Real PacketEnc::writeLLsymbol (Encoder *encoder, int symbol, int layer, int context)
{
  temp = entropyLL->write (encoder, symbol, 1, layer, context);
  rate += temp;
  return temp;
}

Real PacketEnc::writeHFsymbol (Encoder *encoder, int symbol, int layer, int context)
{
  temp = entropyHF->write (encoder, symbol, 1, layer, context);
  rate += temp;
  return temp;
}


PacketDec::PacketDec (MultiLayerCoder *entropyLL, MultiLayerCoder *entropyHF) :
  entropyLL (entropyLL), entropyHF (entropyHF)
{
  
  entropyLL->reset(0);
  entropyHF->reset(0);
  
  //entropyLL = (MultiLayerCoder *) new LayerCoder (4, 0, 512); //nQuant = 4, capacity = 512
  //entropyHF = (MultiLayerCoder *) new LayerCoder (4, 1, 512); 
}

PacketDec::~PacketDec ()
{
  //delete entropyLL;
  //delete entropyHF;
}

int PacketDec::readLLsymbol (Decoder *decoder, int layer, int context)
{
  return entropyLL->read (decoder, 1, layer, context, 0);
}

int PacketDec::readHFsymbol (Decoder *decoder, int layer, int context)
{
  return entropyHF->read (decoder, 1, layer, context, 0);
}

