function [Crgb] = colorSegMap(img_y, iMap, scale)

uv = [220,  200; 
         0,   0; 
         2, 200; 
        60, 240; 
       220,  10; 
       128, 128;
       220, 110; 
        60,  60;
       128,  10];

L = kron(iMap, ones(scale));
maxM=max(iMap(:));
imgY = img_y.*(L./maxM);
img_u = ones(size(imgY));
img_v = ones(size(imgY));
for ii=1:maxM
    img_u(L==ii)=uv(ii,1);
    img_v(L==ii)=uv(ii,2);
end

% upsampling
Cycbcr(:,:,1) = uint8(imgY);
Cycbcr(:,:,2) = uint8(img_u);
Cycbcr(:,:,3) = uint8(img_v);
Crgb=ycbcr2rgb(Cycbcr);% convert to RGB format

    