close all
clear all

fprintf(1,'****************************************************\n');
fprintf(1,'*      GME-SEGMENTATION performance analysis       *\n');
fprintf(1,'****************************************************\n');
fprintf(1,'       Designed by Yue-Meng Chen, Aug,  2009      \n\n');

%% parameter initialization

% the threshold for gradient-descendant(GD) GME (with cascade)
REJRATE = 0.65; 
% iteration number
MAXITER = 1; % For GME with the cascade

% Sample segmentation - City, frame #2
seq_in = '.\ES_MVs\city\city_cif.yuv';
MOT_PATH = '.\ES_MVs\city';
nColumn = 352;
nRow = 288;
nFrm = 2;
ENA_REGION_MERGE = 0; 
gmc_seg(seq_in, MOT_PATH, ENA_REGION_MERGE, nColumn, nRow, nFrm, REJRATE, MAXITER);
disp('generate segmentation result for Fig. 12 - City')

% Sample segmentation - Stefan, frame #27
seq_in = '.\ES_MVs\stefan\stefan_cif.yuv';
MOT_PATH = '.\ES_MVs\stefan';
nColumn = 352;
nRow = 288;
nFrm = 27;
ENA_REGION_MERGE = 1; 
gmc_seg(seq_in, MOT_PATH, ENA_REGION_MERGE, nColumn, nRow, nFrm, REJRATE, MAXITER);
disp('generate segmentation result for Fig. 12 - Stefan');

% Sample segmentation - Coastguard, frame #3
seq_in = '.\ES_MVs\coastguard\coastguard_cif.yuv';
MOT_PATH = '.\ES_MVs\coastguard';
nColumn = 352;
nRow = 288;
nFrm = 3;
ENA_REGION_MERGE = 1; 
gmc_seg(seq_in, MOT_PATH, ENA_REGION_MERGE, nColumn, nRow, nFrm, REJRATE, MAXITER);
disp('generate segmentation result for Fig. 12 - Coastguard')

% Sample segmentaiton - Mobile, frame #5
seq_in = '.\ES_MVs\mobile\mobile_cif.yuv';
MOT_PATH = '.\ES_MVs\mobile';
nColumn = 352;
nRow = 288;
nFrm = 5;
ENA_REGION_MERGE = 1; 
gmc_seg(seq_in, MOT_PATH, ENA_REGION_MERGE, nColumn, nRow, nFrm, REJRATE, MAXITER);
disp('generate segmentation result for Fig. 12 - Mobile')


disp('done!')