close all
clear all

fprintf(1,'****************************************************\n');
fprintf(1,'*      GME performance analysis on real sequence   *\n');
fprintf(1,'****************************************************\n');
fprintf(1,'       Designed by Yue-Meng Chen, Aug,  2009      \n\n');

%% parameter initialization

% the percentage of inliers after the cascade filtering
rOUTLIERS = 0.75; 
% the threshold for gradient-descendant(GD) GME (with cascade)
REJRATE_CAS = 0.65; 
REJRATE_ORI = 0.65; 
% iteration number
MAXITER_CAS = 2; % For GME with the cascade
MAXITER_ORI = 2; % For GME without the cascade

for seq_id = 1 :7
    
    SEG_PATH = '';
    
switch seq_id
    case 1  % garden
        seq_in = '.\ES_MVs\garden\fg_sif.yuv';
        MOT_PATH = '.\ES_MVs\garden';
        SEG_PATH = '.\ES_MVs\garden';
        nColumn = 352;
        nRow = 240;
        nFrm = 100;
        disp('test sequence -- garden, 100 frames')
        TITLE='Global Motion Compensation -- Garden';
    case 2  % tempete
        seq_in = '.\ES_MVs\tempete\tempete_cif.yuv';
        MOT_PATH = '.\ES_MVs\tempete';
        SEG_PATH = '.\ES_MVs\tempete';
        nColumn = 352;
        nRow = 288;
        nFrm = 100;
        disp('test sequence -- tempete, 100 frames')
        TITLE='Global Motion Compensation -- Tempete';
    case 3  % stefan
        seq_in = '.\ES_MVs\stefan\stefan_cif.yuv';
        MOT_PATH = '.\ES_MVs\stefan';
        SEG_PATH = '.\ES_MVs\stefan';
        nColumn = 352;
        nRow = 288;
        nFrm = 85;
        disp('test sequence -- stefan, 85 frames')
        TITLE='Global Motion Compensation -- Stefan';
    case 4  % City
        seq_in = '.\ES_MVs\city\city_cif.yuv';
        MOT_PATH = '.\ES_MVs\city';
        SEG_PATH = '.\ES_MVs\city';
        nColumn = 352;
        nRow = 288;
        nFrm = 100;
        disp('test sequence -- city, 100 frames')
        TITLE='GMC (ES ME) -- City';
    case 5  % coastguard
        seq_in = '.\ES_MVs\coastguard\coastguard_cif.yuv';
        MOT_PATH = '.\ES_MVs\coastguard';
        SEG_PATH = '.\ES_MVs\coastguard';
        nColumn = 352;
        nRow = 288;
        nFrm = 100;
        disp('test sequence -- coastguard, 100 frames')
        TITLE='Global Motion Compensation -- Coastguard';
    case 6  % waterfall
        seq_in = '.\ES_MVs\waterfall\waterfall_cif.yuv';
        MOT_PATH = '.\ES_MVs\waterfall';
        SEG_PATH = '.\ES_MVs\waterfall';
        nColumn = 352;
        nRow = 288;
        nFrm = 100;
        disp('test sequence -- waterfall, 100 frames')
        TITLE='Global Motion Compensation -- Waterfall';
    case 7  % mobile
        seq_in = '.\ES_MVs\mobile\MOBILE_cif.yuv';
        MOT_PATH = '.\ES_MVs\mobile';
        SEG_PATH = '.\ES_MVs\mobile';
        nColumn = 352;
        nRow = 288;
        nFrm = 100;
        disp('test sequence -- mobile, 100 frames')
        TITLE='Global Motion Compensation -- Mobile';
end

mpsnrCas = 0; mpsnrFlt = 0; mpsnrOri = 0; mpsnrRan = 0;
% tic;
% the GME couple with the proposed cascade
[psnrCas] = gme_cas_psnr(seq_in, MOT_PATH, SEG_PATH, nColumn, nRow, nFrm, REJRATE_CAS, MAXITER_CAS);
mpsnrCas = mean(psnrCas);
% toc;
% tic;
% the GME using pure gradient-descent GME -- ref. [3]
[psnrOri] = gme_ori_psnr(seq_in, MOT_PATH, nColumn, nRow, nFrm, REJRATE_ORI, MAXITER_ORI);
mpsnrOri = mean(psnrOri);
% % toc;
% % tic;
% % the GME couple with outlier removal filter -- ref. [6]
[psnrFlt] = gme_flt_psnr(seq_in, MOT_PATH, nColumn, nRow, nFrm, REJRATE_CAS, MAXITER_CAS);
mpsnrFlt = mean(psnrFlt);
% % toc;
% % tic;
% % % the GME couple with RANSAC
[psnrRan, iter] = gme_ransac_psnr(seq_in, MOT_PATH, nColumn, nRow, nFrm, REJRATE_CAS, MAXITER_CAS);
mpsnrRan = mean(psnrRan);
% % % mIter=mean(iter)
% % toc;
[mpsnrCas mpsnrFlt mpsnrOri mpsnrRan]

figure, 
plot(psnrCas,'r-', 'LineWidth',2),
hold on
plot(psnrOri,'b:', 'LineWidth',2)
hold on
plot(psnrFlt,'k-.', 'LineWidth',2)
hold on
plot(psnrRan,'g--', 'LineWidth',2)
hold off
legend('SEG\_GD','GD', 'FLT\_GD', 'RAN\_GD','FontSize',12)
box on
grid off
xlabel('Frame index','FontSize',18)
ylabel('PSNR (dB)','FontSize',18)
set(gca,'FontSize',18)
title(TITLE,'FontSize',18)
end
disp('done!')
return;
