function gme_synth_mvf_ls();

clear all
close all
warning off all

fprintf(1,'****************************************************\n');
fprintf(1,'*      GME performance analysis on synthetic MVF   *\n');
fprintf(1,'****************************************************\n');
fprintf(1,'       Designed by Yue-Meng Chen, Jul,  2009      \n\n');

%% parameters of a synthetic motion field
%
blkSiz = 16; % block size
MVRES = 1;  % integer-pixel: 1, half-pixel: 2
height = 288; nH = height/blkSiz;
width =352; nW = width/blkSiz;

% get the coordinates
[coorBlkY,coorBlkX]=ndgrid(1:nH,1:nW);
coorX = coorBlkX.*blkSiz-blkSiz/2;
coorY = coorBlkY.*blkSiz-blkSiz/2;

% four global motion models to be tested!
m(1, :) =   [0.95     0        10.4238    0      0.95      5.7927    0           0];
m(2, :) =   [0.9964   -0.0249  1.0981     0.0856 0.9457    -7.2      0           0];
m(3, :) =   [0.9964   -0.0249  6.0981     0.0249 0.9964    2.5109    -2.7e-5     1.9e-5];
m(4, :) =   [1        0        4.4154     0      1         0         -1.1263e-4  0];

para = [ 0.7, 0.20;     % stdDev: 0.7, fgSiz: 0.20
         3.0, 0.02;     % stdDev: 3.0, fgSiz: 0.02
         1.5, 0.10;     % stdDev: 1.5, fgSiz: 0.10
         2.2, 0.10; ];  % stdDev: 2.2, fgSiz: 0.10
         
% the parameters for the cascade
MAXITER = [20 20 20 500];
TEST_GMID = [1];
TEST_SCENARIO = [1];
ENA_FIGURE = 0;
for GMID = 1:4
    
    if find(TEST_GMID==GMID)
    
        disp(sprintf('GMID: %d,', GMID));
    
        for ii = 1:4 % Four types of outlier sizes
        
            if find(TEST_SCENARIO==ii)
            
                disp(sprintf('scenario: %d,', ii));
                
                % generate motion field in floating point
                [px, py] = mvGen_f(m(GMID, :), coorX, coorY);

                % test 4 algorithms with different noise level and object size
                iter_seg_all_LS(px, py, para(ii, :), MAXITER, nH, nW, coorX, coorY, blkSiz);
            end
        end
        
    end
end

disp('done!')
