function [psnr] = gme_flt_psnr(seq_in, mv_path, pC, pR, nFrm, REJRATE, MAXITER)

%% input file
[fid_seq_in message]= fopen(seq_in,'rb');

%% parameters of a synthetic motion field
%
blkSiz = 8; % block size
bC=pC/blkSiz; % number of column in blocks
bR=pR/blkSiz; % number of row in blocks

% get the coordinates
[coorBlkY,coorBlkX]=ndgrid(1:bR,1:bC);
coorX = coorBlkX.*blkSiz-blkSiz/2;
coorY = coorBlkY.*blkSiz-blkSiz/2;

GM_TRAN = 1;  % translational model
GM_ISOT = 2;  % isotripic model
GM_AFFI = 3;  % affine model
GM_PERS = 4;  % perspective model
HALFPIX=2; % Half pixel

for ii = 1:nFrm
    % get one frame from YUV sequence (YUV: 411 format) 
    [yCurr, uCurr, vCurr] = readOneFrame(fid_seq_in, pR, pC);
    if ii == 1
        iniMM=[];
    else
        %% get input noisy motion field
        [npx, npy] = readMVs(mv_path,ii, bC, bR, HALFPIX);

        %% GME with cascade

        % the MV outliers removal cascade
        iMap = MVRemFlt(npx, npy);
        
        % GME based on all inliers using Newton-Raphson method
        mmPers = mvGME_NR(GM_PERS, npx(:), npy(:), iMap(:), ...
            coorX(:), coorY(:), MAXITER, REJRATE, iniMM);
        % PSNR for perspective motion model
        iniMM = mmPers(MAXITER+1,:);
        psnr(ii-1)=psnrGMC(yPrev, yCurr, iniMM); 
%         psnr(ii-1) = 0;
    end
    yPrev = yCurr;  % copy it as a reference frame
end

fclose(fid_seq_in);

% the PSNR after applying global motion compensation.
function psnr = psnrGMC(yPrev, yCurr, M)
yWarp=gmeTF(yCurr, M, 1);
D=yWarp-yPrev;
[pR, pC] = size(D);
mse=sum(D(:).*D(:))/(pC*pR);
psnr=10*log10(255^2/mse); % PSNR for affine motion model
