function [snr] = mvSNR(px, py, npx, npy, iMap)

% generate motion field
sig = (px.^2+py.^2).*iMap;
ssig = sum(sig(:));
noi = ((px-npx).^2+(py-npy).^2).*iMap;
snoi = sum(noi(:));

if ssig <= 1
    snr = 0;
else
    if snoi <= 1
        snr = 10*log10(ssig);
    else
        snr = 10*log10(ssig/snoi);
    end
end

end