function outMap = noiseSup(inMap, iter)

outMap = inMap;
[m, n] = size(inMap);

for ii = 1:iter
    
    padMap = wextend(2,'sym',outMap,1);
    
%     testSegMap(segMap, 16); % for testing

    r = padMap(2:end-1,3:end  ); % right
    l = padMap(2:end-1,1:end-2); % left
    u = padMap(1:end-2,2:end-1); % upper
    b = padMap(3:end,  2:end-1); % bottom

    % check r+l+u
    e = zeros(m,n);
    rlu = abs(r-l)+abs(r-u)+abs(l-u);
    e(rlu==0) = 1;
    outMap(e==1) = r(e==1);

    % check b+l+u
    e = zeros(m,n);
    blu = abs(b-l)+abs(b-u)+abs(l-u);
    e(blu==0) = 1;
    outMap(e==1) = b(e==1);

    % check b+l+r
    e = zeros(m,n);
    blr = abs(b-l)+abs(b-r)+abs(l-r);
    e(blr==0) = 1;
    outMap(e==1) = r(e==1);

    % check b+u+r
    e = zeros(m,n);
    bur = abs(b-u)+abs(b-r)+abs(u-r);
    e(bur==0) = 1;
    outMap(e==1) = u(e==1);
end
