function [ranM, nIter, inliers] = ranGME(GMMODE, rcoorX, rcoorY, coorX, coorY, INITER)
x1 = [coorX'; coorY'; ones(1,length(coorX))];
x2 = [rcoorX'; rcoorY'; ones(1,length(rcoorX))];    

t = .001;  % Distance threshold for deciding outliers

if GMMODE == 4
    [H, inliers, nIter] = ransacfithomography(x1, x2, t, INITER);
else
    warning('ransac fitting for homography only');
end

if ~isempty(H)
    H=H';
    ranM=H(:);
    ranM = ranM./H(3,3);
else
    ranM=[];
end
