/* ========================================================================= */
/* Description: member functions of class EzbcCodec3d                        */
/* Author: Shih-Ta Hsiang                                                    */
/* Version: v0.a                                                             */
/* Last Revised: Aug. 15, 2000                                               */
/* ========================================================================= */

#include "..\\TempSub\\structN.h"
#include "ezbc_codec_3d.h"


EzbcCodec3d::EzbcCodec3d()
{}

EzbcCodec3d::EzbcCodec3d(videoinfo& info)
{
  int i; 

  dim.y = info.ywidth; dim.x = info.yheight;
  cdim.y = info.cwidth; cdim.x = info.cheight;
  GOPsz = info.GOPsz; byte_budget = info.GOPbytes;

  NEW_VECTOR(imgY, GOPsz, Image_BW, "imgY");
  NEW_VECTOR(pyrY, GOPsz, SUBBAND_TREE_TYPE*, "pyrY");
  for(i = GOPsz - 1; i >= 0; pyrY[i--] = NULL);

  if(cdim.x > 0){
    NEW_VECTOR(imgU, GOPsz, Image_BW, "imgU");
    NEW_VECTOR(imgV, GOPsz, Image_BW, "imgV");
    NEW_VECTOR(pyrU, GOPsz, SUBBAND_TREE_TYPE*, "pyrU");
    NEW_VECTOR(pyrV, GOPsz, SUBBAND_TREE_TYPE*, "pyrV");
    for(i = GOPsz - 1; i >= 0; i--) {
      pyrU[i]= pyrV[i] = NULL;
    }
  }else{
    imgU = imgV = NULL;
    pyrU = pyrV = NULL;
  }
}

EzbcCodec3d::
~EzbcCodec3d(void)
{
  int i;

 //  cout << "before delete" << endl;

//   for(i = 0; i <GOPsz; i++)
//     cout << "pyrY[" << i << "] = " << pyrY[i] << endl;

  if(imgY){
    DELETE_VECTOR(imgY);
  }

  if(imgU){
    DELETE_VECTOR(imgU);
  }

  if(imgV){
    DELETE_VECTOR(imgV);
  }

  if(pyrY){
    for(i = GOPsz - 1; i >= 0; i--){
      //cout << "pyrY[" << i << "] = " << pyrY[i] << endl;
      if(pyrY[i])
        delete pyrY[i];
    }
    DELETE_VECTOR(pyrY);
  }

  if(pyrU){
    for(i = GOPsz - 1; i >= 0; i--){
      if(pyrU[i]){
        DELETE_OBJECT(pyrU[i]);}
    }
    DELETE_VECTOR(pyrU);
  }
  if(pyrV){
    for(i = GOPsz - 1; i >= 0; i--){
      //cout << "pyrV[" << i << "] = " << pyrV[i] << endl;
      if(pyrV[i]){
        DELETE_OBJECT(pyrV[i]);}
    }
    DELETE_VECTOR(pyrV);
  }
}
