/* ========================================================================= */
/* Description:menber functions for class Ezbcdec3d                          */
/* Author: Shih-Ta Hsiang                                                    */
/* Version: v0.a                                                             */
/* Last Revised: Aug. 15, 2000                                               */
/* ========================================================================= */
#include "z:\\3D_EZBC\\TempSub\\structN.h"
#include "ezbc_dec_3d.h"

EzbcDec3d::
EzbcDec3d(videoinfo &info, DECODER_TYPE *dec)
  : EzbcCodec3d(info), decoder(dec)
{
  decY = decU = decV = NULL;
}

EzbcDec3d::
~EzbcDec3d(void)
{
  if(decY)
    DELETE_VECTOR(decY);
  if(decU)
    DELETE_VECTOR(decU);
  if(decV)
    DELETE_VECTOR(decV);
}

void EzbcDec3d::
reset_pyrs(void)
{
  int i, nbds = 1 + 3*imgY[0].pyramid_levels();
  int *null_msb_layers;

  NEW_VECTOR( null_msb_layers, nbds, int, "null_msb_layers");

  for(i = 0; i < GOPsz; i++){
    if(pyrY[i])
      DELETE_OBJECT(pyrY[i]);
    //assert(pyrY[i] = new SUBBAND_TREE_TYPE(imgY[i], null_msb_layers));
	myassert(pyrY[i] = new SUBBAND_TREE_TYPE(imgY[i], null_msb_layers));
    imgY[i].dispose();
   if(cdim.x){
     if(pyrU[i])
       DELETE_OBJECT(pyrU[i]);
     //assert(pyrU[i] = new SUBBAND_TREE_TYPE(imgU[i], null_msb_layers));
	 myassert(pyrU[i] = new SUBBAND_TREE_TYPE(imgU[i], null_msb_layers));
     imgU[i].dispose();
     if(pyrV[i])
       DELETE_OBJECT(pyrV[i]);
     //assert(pyrV[i] = new SUBBAND_TREE_TYPE(imgV[i], null_msb_layers));
	 myassert(pyrV[i] = new SUBBAND_TREE_TYPE(imgV[i], null_msb_layers));
     imgV[i].dispose();
   }
  }
  delete [] null_msb_layers;

}

void EzbcDec3d::
initialization(void)
{
  int i;

  NEW_VECTOR(decY, GOPsz, DEC_SUBBAND_TREE_TYPE, "decY");
  if(cdim.x > 0){
    NEW_VECTOR(decU, GOPsz, DEC_SUBBAND_TREE_TYPE, "decU");
    NEW_VECTOR(decV, GOPsz, DEC_SUBBAND_TREE_TYPE, "decV");
  }else{
    decU = decV = NULL;
  }

  for(i = GOPsz - 1; i >= 0; i--){
    decY[i].initialize(pyrY[i],  decoder);
    if(cdim.x > 0){
      decU[i].initialize(pyrU[i],  decoder);
      decV[i].initialize(pyrV[i],  decoder);
    }
  }
}

void EzbcDec3d::reset_GOP_dec(void)
{
  int i;

  for(i = GOPsz - 1; i >= 0; i--){
    decY[i].reset_tree_dec(pyrY[i]);
    if(cdim.x > 0){
      decU[i].reset_tree_dec(pyrU[i]);
      decV[i].reset_tree_dec(pyrV[i]);
    }
  }
}

void EzbcDec3d::
decode_GOP_header(void)
{
  int i;
  int mean, mean_shift;

  for(i = 0; i < GOPsz; i++){
    mean_shift = decoder->decode_bits(4);
    if(decoder->decode_bits(1))
      mean = -(decoder->decode_bits(10));
    else
      mean = decoder->decode_bits(10);
//    cout << "mean = " << mean << " mean_shift = " << mean_shift << endl;
    imgY[i].reset(dim, 1, mean, mean_shift, 0);

    if(cdim.x){
      mean_shift = decoder->decode_bits(4);
      if(decoder->decode_bits(1))
        mean = -(decoder->decode_bits(10));
      else
        mean = decoder->decode_bits(10);
//      cout << "mean = " << mean << " mean_shift = " << mean_shift << endl;
      imgU[i].reset(cdim, 1, mean, mean_shift, 0);

      mean_shift = decoder->decode_bits(4);
      if(decoder->decode_bits(1))
        mean = -(decoder->decode_bits(10));
      else
        mean = decoder->decode_bits(10);
//      cout << "mean = " << mean << " mean_shift = " << mean_shift << endl;
      imgV[i].reset(cdim, 1, mean, mean_shift, 0);
    }
  }

}

void EzbcDec3d::
decode_GOP(void)
{
  decode_GOP_RD_passes();
}


void EzbcDec3d::decode_GOP_subbitplane_passes(void)
{
  int i;

  for(i = 0; i < GOPsz; i++){
    decY[i].dec_subbitplane_passes();
    if(cdim.x > 0){
      decU[i].dec_subbitplane_passes();
      decV[i].dec_subbitplane_passes();
    }
  }
}

void EzbcDec3d::
reconstruct_subbands(void)
{
  int i;

  for(i = GOPsz - 1; i >= 0; i--){
    decY[i].rec_subbands();
   if(cdim.x){
     decU[i].rec_subbands();
     decV[i].rec_subbands();
   }
  }
}

void EzbcDec3d::
reconstruct_images(YUVimage *Frs)
{
  int i, mean, mean_shift;

  for(i = GOPsz - 1; i >= 0; i--){
    mean = imgY[i].transform_mean();
    mean_shift = imgY[i].mean_shift();
    imgY[i].reset(dim, 1, mean, mean_shift, 0);
    pyrY[i]->SubSetLayer2Image_BW(imgY[i]);
	imgY[i].add_mean();

	if(i==0) imgY[i].density_intensity();

    imgY[i].recover();




    imgY[i].write_float_image(Frs[i].Y);
    imgY[i].dispose();

    if(cdim.x){
      mean = imgU[i].transform_mean();
      mean_shift = imgU[i].mean_shift();
      imgU[i].reset(cdim, 1, mean, mean_shift, 0);
      pyrU[i]->SubSetLayer2Image_BW(imgU[i]);

	  imgU[i].add_mean();

 //     imgU[i].density_intensity();
	  
	  imgU[i].recover();


      imgU[i].write_float_image(Frs[i].U);
      imgU[i].dispose();

      mean = imgV[i].transform_mean();
      mean_shift = imgV[i].mean_shift();
      imgV[i].reset(cdim, 1, mean, mean_shift, 0);
      pyrV[i]->SubSetLayer2Image_BW(imgV[i]);

	  imgV[i].add_mean();

//	  imgV[i].density_intensity();

      imgV[i].recover();



      imgV[i].write_float_image(Frs[i].V);
      imgV[i].dispose();
    }
  }
}


void EzbcDec3d::
decode_GOP_RD_passes(void)
{
  int i, j, m, n, k, pass_idx, lev, max_depth, msb, max_msb;
  int ncomps, nbands[3];
  DecSubband *dec_band;
  DEC_SUBBAND_TREE_TYPE *decGOP[3] = {decY, decU, decV};
  int total_byte_budget;

  total_byte_budget = byte_budget;
  SubbandCodec::set_byte_budget(total_byte_budget);

  ncomps = (cdim.x > 0)?  3 : 1;
  for(max_msb = 0, i = 0; i < GOPsz; i++){
    for(m = 0; m < 3; m++){ // componenets
      nbands[m] =  decGOP[m][i].subband_tree->get_nband();
      for(k = 0; k < nbands[m]; k++)
        decGOP[m][i].dec_subs[k].start_dec_subband();
      decGOP[m][i].subband_tree->reset_max_msb();
      msb = decGOP[m][i].subband_tree->get_max_msb();  //printf("msb = %d\n", msb);
      if(max_msb < msb) max_msb = msb;
    }
  }

  max_depth = decY[GOPsz-1].dec_subs[nbands[0]-1].get_qtree_depth();

  printf("max_msb = %d EXTRA_BIT = %d(ezbc_dec_3d.cpp)\n", max_msb, EXTRA_BIT);

  for(n = max_msb + EXTRA_BIT; n >= EXTRA_BIT; n--){ //printf("bit_plane = %d\n", n); getchar();
    for(i = 0; i < GOPsz; i++){ // fr #     printf("frame= %d\n", i);

      for(m = 0; m < ncomps; m++) // componenets
        nbands[m] =  decGOP[m][i].subband_tree->get_nband();

      pass_idx = 0;
      for(m = 0; m < ncomps; m++){
        for(k = 0; k < nbands[m]; k++){
          dec_band = &(decGOP[m][i].dec_subs[k]);
          if(n < dec_band->max_bit_idx){
            dec_band->bit_idx = n;
            dec_band->cur_pass = pass_idx;
            dec_band->set_bit_idx_mask();
            dec_band->LSP_break_pt = dec_band->node_list.LSP_end + 1;
            dec_band->update_node_cxts();
            (dec_band->*(dec_band->decode_LIP))();

            if(decoder->bytes_used() > total_byte_budget){
				printf("decoding stopped at bit_plane = %d(ezbc_dec_3d.cpp)\n", n);
              return;
			}
          }
        }
      }

      pass_idx++;
      for(m = 0; m < ncomps; m++){
        for(k = 0; k < nbands[m]; k++){
          dec_band = &(decGOP[m][i].dec_subs[k]);

          if(n < dec_band->max_bit_idx){
            dec_band->cur_pass = pass_idx;
            (dec_band->*(dec_band->decode_LIS_leaves))();
            if(decoder->bytes_used() > total_byte_budget){
				printf("decoding stopped at bit_plane = %d(ezbc_dec_3d.cpp)\n", n);
              return;
			}
          }
        }
      }

      for(lev = 2; lev <= max_depth; lev++){
        pass_idx++;
        for(m = 0; m < ncomps; m++){
          for(k = 0; k < nbands[m]; k++){
            dec_band = &(decGOP[m][i].dec_subs[k]);

            if((n == dec_band->max_bit_idx) && (lev == dec_band->qtree.depth)){
              dec_band->bit_idx = n;
              dec_band->cur_pass = pass_idx;
              dec_band->set_bit_idx_mask();
              dec_band->LSP_break_pt = dec_band->node_list.LSP_end + 1;

#ifdef GET_PARENT_MODELS

    if(dec_band->par_cxt_qtree){


#ifdef INITIALIZE_SIGN_MODELS_FROM_PAR
     MODEL_TYPE *par_sign_models, *sign_models;

     sign_models =  dec_band->cxt_qtree.cxt_models +
       dec_band->cxt_qtree.sign_offset;
     par_sign_models = dec_band->par_cxt_qtree->cxt_models +
       dec_band->par_cxt_qtree->sign_offset;
     for(j = dec_band->cxt_qtree.sign_cxts - 1; j >= 0;){
       sign_models[j].reset(par_sign_models[j]);
       sign_models[j--].taub_scale();
     }
#endif

#ifdef INITIALIZE_JSIG_MODELS_FROM_PAR

     MODEL_TYPE *par_jsig_models, *jsig_models;
     int cxts, par_cxts;


     cxts = par_cxts = 0;
     for(j = dec_band->qtree.depth - 2; j >= 0; j--){
       //parent band with depth = qtree.depth - 1
       cxts += dec_band->cxt_qtree.sig_cxts[j];
       par_cxts += dec_band->par_cxt_qtree->sig_cxts[j];
       assert(cxts == par_cxts);
     }
     jsig_models = dec_band->cxt_qtree.cxt_models +
       dec_band->cxt_qtree.sig_offsets[0];
     par_jsig_models = dec_band->par_cxt_qtree->cxt_models +
       dec_band->par_cxt_qtree->sig_offsets[0];
     for(j = cxts-1; j >=0;){
       jsig_models[j].reset(par_jsig_models[j]);
       jsig_models[j--].taub_scale();
     }
#endif
    }   //par_cxt_qtree
#endif  //GET_PARENT_MODELS


#ifdef LSP_BIT_IDX
    //empty lists in the top plane
    for(j = dec_band->qtree.depth-1; j >=0; j--)
      dec_band->node_list.LSP_ids[n][j] = dec_band->node_list.LSP_end;
#endif
//printf("%d\n", lev);
             (dec_band->*(dec_band->decode_sig_node))(0, lev-1); //root node
             dec_band->decode_LIS_stack();
             if(decoder->bytes_used() > total_byte_budget){
			     printf("decoding stopped at bit_plane = %d(ezbc_dec_3d.cpp)\n", n);
                 return;
			 }
            }else if((n < dec_band->max_bit_idx)
                     && (lev < dec_band->qtree.depth)){
	      dec_band->cur_pass = pass_idx;
	      dec_band->cur_lev = lev;
	      (dec_band->*(dec_band->decode_cur_qtree_level))();

		  if(decoder->bytes_used() > total_byte_budget){
			    printf("decoding stopped at bit_plane = %d(ezbc_dec_3d.cpp)\n", n);
				return;
		  }
	    } //else if
	  } // for k
	} // for m
      } // for lev

      pass_idx++;
      for(m = 0; m < ncomps; m++){
        for(k = nbands[m] - 1; k >= 0; k--){
          dec_band = &(decGOP[m][i].dec_subs[k]);
          if(n <= dec_band->max_bit_idx){
            dec_band->cur_pass = pass_idx;
            (dec_band->*(dec_band->decode_LSP))();

            if(decoder->bytes_used() > total_byte_budget){
				  printf("decoding stopped at bit_plane = %d(ezbc_dec_3d.cpp)\n", n);
              return;
			}

            dec_band->reset_cxt_models();

          }//if(n <= dec_band->max_bit_idx){
        }
      } //for m

    } // for i
  } // for n

}


void EzbcDec3d::
free_lists(void)
{
  int i, m, k;
  int nbands, ncomps;
  DEC_SUBBAND_TREE_TYPE *decGOP[3] = {decY, decU, decV};

  ncomps = (cdim.x > 0)?  3 : 1;

  for(m = 0; m < ncomps; m++){ // componenets
    for(i = 0; i < GOPsz; i++){
      nbands =  decGOP[m][i].subband_tree->get_nband();
      for(k = 0; k < nbands; k++){
        decGOP[m][i].dec_subs[k].clear_node_list();
        decGOP[m][i].dec_subs[k].delete_coding_stats();
      }
    }
  }

}
