/* ========================================================================= */
/* Description: menber functions for class EzbcEnc3d                         */
/* Author: Shih-Ta Hsiang                                                    */
/* Version: v0.a                                                             */
/* Last Revised: Aug. 15, 2000                                               */
/* ========================================================================= */
#include "z:\\3D_EZBC\\TempSub\\structN.h"
#include "ezbc_enc_3d.h"

EzbcEnc3d::
EzbcEnc3d(videoinfo &info, ENCODER_TYPE *enc)
  : EzbcCodec3d(info), encoder(enc)
{
  encY = encU = encV = NULL;
}

EzbcEnc3d::
~EzbcEnc3d(void)
{
  if(encY)
    DELETE_VECTOR(encY);
  if(encU)
    DELETE_VECTOR(encU);
  if(encV)
    DELETE_VECTOR(encV);
}


void EzbcEnc3d::
load_images( YUVimage *Frs)
{
  int i;

  for(i = GOPsz - 1; i >= 0; i--){
    //for(i = 0; i >= 0; i--){
    imgY[i].read_float_image(dim, Frs[i].Y);  printf("Y component ");
    imgY[i].transform(); 
	if(i==0) imgY[i].intensity_density();
    imgY[i].subtract_mean();

    if(pyrY[i])
      DELETE_OBJECT(pyrY[i]);
    //assert(pyrY[i] = new SUBBAND_TREE_TYPE(imgY[i]));
	myassert(pyrY[i] = new SUBBAND_TREE_TYPE(imgY[i]));
    imgY[i].dispose();

    if(cdim.x){
      imgU[i].read_float_image(cdim, Frs[i].U);  printf("U component ");
      imgU[i].transform();
//   	  imgU[i].intensity_density();

      imgU[i].subtract_mean();



      if(pyrU[i])
        DELETE_OBJECT(pyrU[i]);
      //assert(pyrU[i] = new SUBBAND_TREE_TYPE(imgU[i]));
	  myassert(pyrU[i] = new SUBBAND_TREE_TYPE(imgU[i]));
      imgU[i].dispose();

      imgV[i].read_float_image(cdim, Frs[i].V);  printf("V component ");
      imgV[i].transform();
//   	  imgV[i].intensity_density();

      imgV[i].subtract_mean();



      if(pyrV[i])
        DELETE_OBJECT(pyrV[i]);
      //assert(pyrV[i] = new SUBBAND_TREE_TYPE(imgV[i]));
	  myassert(pyrV[i] = new SUBBAND_TREE_TYPE(imgV[i]));
      imgV[i].dispose();
    }
  }





}


void EzbcEnc3d::
initialization(void)
{
  int i;

  NEW_VECTOR(encY, GOPsz, ENC_SUBBAND_TREE_TYPE, "encY");

  if(cdim.x > 0){
    NEW_VECTOR(encU, GOPsz, ENC_SUBBAND_TREE_TYPE, "encU");
    NEW_VECTOR(encV, GOPsz, ENC_SUBBAND_TREE_TYPE, "encV");
  }else{
    encU = encV = NULL;
  }

  for(i = GOPsz - 1; i >= 0; i--){
    encY[i].initialize(pyrY[i],  encoder);
    if(cdim.x > 0){
      encU[i].initialize(pyrU[i],  encoder);
      encV[i].initialize(pyrV[i],  encoder);
    }
  }
}

void EzbcEnc3d::
reset_GOP_enc(void)
{
  int i;

  for(i = GOPsz - 1; i >= 0; i--){
    encY[i].reset_tree_enc(pyrY[i]);
    if(cdim.x > 0){
      encU[i].reset_tree_enc(pyrU[i]);
      encV[i].reset_tree_enc(pyrV[i]);
    }
  }
}

void EzbcEnc3d::
encode_GOP_header(void)
{
  int i;
  int mean, mean_shift;

  for(i = 0; i < GOPsz; i++){
    mean = imgY[i].transform_mean();
    mean_shift = imgY[i].mean_shift();

    encoder->code_bits(4, mean_shift);
    if(mean >= 0){
      encoder->code_bits(1, 0);
      encoder->code_bits(10, mean);
   }else{
      encoder->code_bits(1, 1);
      encoder->code_bits(10, -mean);
    }

    if(cdim.x > 0){
      mean = imgU[i].transform_mean();
      mean_shift = imgU[i].mean_shift();

      encoder->code_bits(4, mean_shift);
      if(mean > 0){
        encoder->code_bits(1, 0);
        encoder->code_bits(10, mean);
      }else{
        encoder->code_bits(1, 1);
        encoder->code_bits(10, -mean);
      }
      mean = imgV[i].transform_mean();
      mean_shift = imgV[i].mean_shift();

      encoder->code_bits(4, mean_shift);
      if(mean > 0){
        encoder->code_bits(1, 0);
        encoder->code_bits(10, mean);
      }else{
        encoder->code_bits(1, 1);
        encoder->code_bits(10, -mean);
      }
    }
  }

}


void EzbcEnc3d::
encode_GOP(void)
{

  encode_GOP_RD_passes();
}


void EzbcEnc3d::
encode_GOP_subbitplane_passes(void)
{
  int i;

  for(i = 0; i < GOPsz; i++){
    encY[i].enc_subbitplane_passes();
    if(cdim.x > 0){
      encU[i].enc_subbitplane_passes();
      encV[i].enc_subbitplane_passes();
    }
  }
}

void EzbcEnc3d::
encode_GOP_RD_passes(void)
{
  int i, j, m, n, k, pass_idx, lev, max_depth, msb, max_msb;
  int ncomps, nbands[3];
  EncSubband *enc_band;// class EncSubband defined in dwt_bitplane_enc.h
  ENC_SUBBAND_TREE_TYPE *encGOP[3] = {encY, encU, encV};
  int total_byte_budget;

  total_byte_budget = MAX_STD_INT;
  ncomps = (cdim.x > 0)?  3 : 1;

  for(max_msb = 0, i = 0; i < GOPsz; i++){  
    for(m = 0; m < ncomps; m++){// componenets  
      nbands[m] =  encGOP[m][i].subband_tree->get_nband();
      for(k = 0; k < nbands[m]; k++)
        encGOP[m][i].enc_subs[k].start_enc_subband();
      msb = encGOP[m][i].subband_tree->get_max_msb(); //printf("msb = %d\n", msb); getchar();
      if(max_msb < msb) max_msb = msb;
    }
  }


  max_depth = encY[GOPsz-1].enc_subs[nbands[0]-1].get_qtree_depth();
  
  printf("max_msb = %d Extra_bit = %d(ezbc_enc_3d.c)\n", max_msb, EXTRA_BIT);

  for(n = max_msb + EXTRA_BIT; n >= EXTRA_BIT; n--){ //printf("bit_plane = %d\n", n);  
// bit_idx
    for(i = 0; i < GOPsz; i++){ // fr #     //printf("frame = %d\n", i);

      for(m = 0; m < ncomps ; m++)
        nbands[m] =  encGOP[m][i].subband_tree->get_nband();

      pass_idx = 0;
      for(m = 0; m < ncomps; m++){
	for(k = 0; k < nbands[m]; k++){
	  enc_band = &(encGOP[m][i].enc_subs[k]);
	  if(n < enc_band->max_bit_idx){
	    enc_band->bit_idx = n;
	    enc_band->cur_pass = pass_idx;
	    enc_band->set_mag_mask();
	    enc_band->set_bit_idx_mask();
	    enc_band->update_node_cxts();
	    (enc_band->*(enc_band->encode_LIP))(); // void EncSubband::encode_LIP_cxt_AC() in dwt_bitplane_enc_cxt_AC.C
	    if(encoder->bytes_used() > total_byte_budget)
	      return;
	  }
	}
      }

      pass_idx++;
      for(m = 0; m < ncomps; m++){
	for(k = 0; k < nbands[m]; k++){
	  enc_band = &(encGOP[m][i].enc_subs[k]);
	  if(n < enc_band->max_bit_idx){
	    enc_band->cur_pass = pass_idx;
	    (enc_band->*(enc_band->encode_LIS_leaves))(); //void EncSubband::encode_LIS_leaves_cxt_AC() in dwt_bitplane_enc_cxt_AC.C
	    if(encoder->bytes_used() > total_byte_budget)
	      return;
	  }
	}
      }

      for(lev = 2; lev <= max_depth; lev++){
	pass_idx++;
	for(m = 0; m < ncomps; m++){
	  for(k = 0; k < nbands[m]; k++){
	    enc_band = &(encGOP[m][i].enc_subs[k]);
       
	    if((n == enc_band->max_bit_idx) && (lev == enc_band->qtree.depth)){
	      // the first bitplane
	      enc_band->bit_idx = n;
	      enc_band->cur_pass = pass_idx;
	      enc_band->set_mag_mask();
	      enc_band->set_bit_idx_mask();

#ifdef GET_PARENT_MODELS

    if(enc_band->par_cxt_qtree){


#ifdef INITIALIZE_SIGN_MODELS_FROM_PAR
      MODEL_TYPE *par_sign_models, *sign_models;

      sign_models =  enc_band->cxt_qtree.cxt_models +
	enc_band->cxt_qtree.sign_offset;
      par_sign_models = enc_band->par_cxt_qtree->cxt_models +
	enc_band->par_cxt_qtree->sign_offset;
      for(j = enc_band->cxt_qtree.sign_cxts - 1; j >= 0;){
	sign_models[j].reset(par_sign_models[j]);
	sign_models[j--].taub_scale();
      }
#endif

#ifdef INITIALIZE_JSIG_MODELS_FROM_PAR

     MODEL_TYPE *par_jsig_models, *jsig_models;
     int cxts, par_cxts;


     cxts = par_cxts = 0;
     for(j = enc_band->qtree.depth - 2; j >= 0; j--){
       //parent band with depth = qtree.depth - 1
       cxts += enc_band->cxt_qtree.sig_cxts[j];
       par_cxts += enc_band->par_cxt_qtree->sig_cxts[j];
       assert(cxts == par_cxts);
     }
     jsig_models = enc_band->cxt_qtree.cxt_models +
       enc_band->cxt_qtree.sig_offsets[0];
     par_jsig_models = enc_band->par_cxt_qtree->cxt_models +
       enc_band->par_cxt_qtree->sig_offsets[0];
     for(j = cxts-1; j >=0;){
       jsig_models[j].reset(par_jsig_models[j]);
       jsig_models[j--].taub_scale();
     }

#endif

    }   //par_cxt_qtree
#endif  //GET_PARENT_MODELS

#ifdef LSP_BIT_IDX
    //empty lists in the top plane
    for(j = enc_band->qtree.depth-1; j >=0; j--)
      enc_band->node_list.LSP_ids[n][j] = enc_band->node_list.LSP_end;
#endif

              (enc_band->*(enc_band->encode_sig_node))(0, lev-1); //root node
	      enc_band->encode_LIS_stack();

	      enc_band->coding_stats.bitplanes[n].passes[pass_idx].cumulative_bytes= enc_band->sub_encoder->bytes_used();

	      if(encoder->bytes_used() > total_byte_budget)
		return;

	    }else if((n < enc_band->max_bit_idx)
		     &&(lev < enc_band->qtree.depth)){
	      enc_band->cur_pass = pass_idx;
	      enc_band->cur_lev = lev;
	      (enc_band->*(enc_band->encode_cur_qtree_level))();

	      if(encoder->bytes_used() > total_byte_budget)
		return;
	    }
	  }  // for k
	} // for m
      } //lev




      pass_idx++;
      for(m = 0; m < ncomps; m++){
        for(k = nbands[m] - 1; k >= 0; k--){
          enc_band = &(encGOP[m][i].enc_subs[k]);
          if(n <= enc_band->max_bit_idx){
            enc_band->cur_pass = pass_idx;
            (enc_band->*(enc_band->encode_LSP))(); //void EncSubband::encode_LSP_cxt_AC()  in dwt_bitplane_enc_cxt_AC.C
            if(encoder->bytes_used() > total_byte_budget)
              return;
            enc_band->reset_cxt_models();
          }//if(n <= enc_band->max_bit_idx){
        }
      } //for m

    } // for i
  } // for n
}

void EzbcEnc3d::
free_lists(void)
{
  int i, m, k;
  int nbands, ncomps;
  ENC_SUBBAND_TREE_TYPE *encGOP[3] = {encY, encU, encV};

  ncomps = (cdim.x > 0)?  3 : 1;

  for(m = 0; m < ncomps; m++){ // componenets
    for(i = 0; i < GOPsz; i++){
      nbands =  encGOP[m][i].subband_tree->get_nband();
      for(k = 0; k < nbands; k++){
        encGOP[m][i].enc_subs[k].clear_node_list();
        encGOP[m][i].enc_subs[k].delete_coding_stats();
      }
    }
  }
}
