/* ========================================================================= */
/* Description: main program for the EZBC decoder                            */
/* Author: Shih-Ta Hsiang                                                    */
/* Version: v0.a                                                             */
/* Last Revised: Aug. 15, 2000                                               */
/* ========================================================================= */

#include "general.h"
#include "image_bw.h"
#include "subband.h"
#include "ar_code.h"
#include "dwt_bitplane_dec.h"

DECODER_TYPE data_file;

char names[3][80], * pic_f_name = names[0], * cod_f_name = names[1],
  * new_f_name = names[2];

Chronometer code_time, total_time;

int pel_bytes, pyramid_levels, smoothing;
int mean, mean_shift;

long byte_budget;

float bit_rate, rate_mult;

Image_Coord dimension, pyramid_dim;

Image_BW image;


void decode_head()
{
  dimension.x = data_file.decode_bits(6) << 8;

  dimension.y = data_file.decode_bits(6) << 8;

  dimension.x += data_file.decode_bits(8);

  dimension.y += data_file.decode_bits(8);

  pel_bytes = 1 + data_file.decode_bits(1);

  smoothing = data_file.decode_bits(3);

  mean_shift = data_file.decode_bits(4);

  mean = data_file.decode_bits(10);
}


int main(int numb_arg, char * arg[])
{

  if(numb_arg == 2) {
    printf("\n* Usage to compare the recovered image with the original:"
           "\n\n%s  coded_file  original_image  bpp_rate\n", arg[0]);
    printf("\n* Usage to save the recovered image:\n\n%s -s  "
           "coded_file  new_image_file  bpp_rate", arg[0]);

    puts(" \n");  exit(0); }

  FILE * plot_file;
  float mse, psnr, max_rate = 0.0, rate_inc, peak_2 = 0.0;
  boolean cont, comp, interactive, cml;

  if (cml = ((numb_arg == 4) || (numb_arg == 5))) {
    interactive = false;
    if (numb_arg == 4) {
      cod_f_name = arg[1];  pic_f_name = arg[2];
      bit_rate = atof(arg[3]);  comp = true;  peak_2 = 65025.0; }
    else {
      if ((arg[1][0] != '-') || (arg[1][1] != 's'))
        Error("invalid command-line option");
      cod_f_name = arg[2];  new_f_name = arg[3];
      bit_rate = atof(arg[4]);  comp = false; } }
  else {
    interactive = Input_Answer("Interactive mode");
    Input_Line("Name of the compressed image file", cod_f_name);
    comp = !interactive ||
      Input_Answer("Recovered image will be compared to original");
    if (comp)
      Input_Line("File with original image", pic_f_name);
    if (!interactive) {
      plot_file = Open_File("File with rate x PSNR results", "wt");
      bit_rate = Input_Float("First rate (bits/pixel)");
      max_rate = Input_Float("Last rate  (bits/pixel)");
      rate_inc = Input_Float("Rate increment"); } }

  do {

    data_file.open_file(cod_f_name);
    decode_head();

    rate_mult = 8.0 / (float(dimension.x) * float(dimension.y));
    printf("\n  Image size = %d x %d, %d byte(s)/pixel\n",
           dimension.x, dimension.y, pel_bytes);
    if (smoothing)
      printf("  Coded with smoothing factor %d\n", smoothing);
    if (interactive)
      bit_rate = Input_Float("Code rate (bits/pixel)");

    byte_budget = long(bit_rate / rate_mult) - 1;

    if (comp && (peak_2 == 0.0))
      peak_2 = (pel_bytes == 1 ? 65025.0 :
                Sqr(Input_Float("Peak value for PSNR computations")));

    code_time.reset();  total_time.reset();  total_time.start();

    image.reset(dimension, pel_bytes, mean, mean_shift, smoothing);

    pyramid_dim = image.pyramid_dim();

    int nbds = 1 + 3*image.pyramid_levels();

    int *null_msb_layers = new int[nbds];

    SUBBAND_TREE_TYPE pyr(image, null_msb_layers);

    delete [] null_msb_layers;

    SubbandCodec::setup_luts();

    DEC_SUBBAND_TREE_TYPE dec_subband_tree(&pyr, &data_file);

    dec_subband_tree.set_total_byte_budget(byte_budget);

    code_time.start("\n  Starting image recovery...");

    dec_subband_tree.dec_subbitplane_passes();

    code_time.display(" Image recovered in");

    data_file.close_file();

    dec_subband_tree.rec_subbands();

    pyr.SubSetLayer2Image_BW(image);

    image.recover();

    total_time.stop();

    if (comp) {
      printf("\n  Rate =%7.4f bits/pixel --> ", rate_mult *
             data_file.bytes_used());
      mse = image.compare(pic_f_name);
      if (mse > 0.0) {
        psnr = dBW(peak_2 / mse);
        printf("mean squared-error =%8.3f =%7.2f dB PSNR\n",
               mse, psnr); }
      else
        puts("no differences encountered"); }

    total_time.display("\n  Total execution time (I/O included) =");

    if (interactive) {
      if (Input_Answer("Save new image to disk")) {
        Input_Line("Name of the new image file", new_f_name);
        image.write_pic(new_f_name); }
      cont = Input_Answer("Test new rate"); }
    else
      if (cml) {
        if (!comp) image.write_pic(new_f_name);
        cont = false; }
      else {
        fprintf(plot_file, "%9.4f %9.4f\n", bit_rate, psnr);
        bit_rate += rate_inc;
        cont = (bit_rate <= max_rate); }

  } while (cont);

  if (!(cml || interactive)) fclose(plot_file);
  puts(" ");

  return 0;
}
