/* ========================================================================= */
/* Description: menber functions for class DecSubbandTree                    */
/* Author: Shih-Ta Hsiang                                                    */
/* Version: v0.a                                                             */
/* Last Revised: Aug. 15, 2000                                               */
/* ========================================================================= */

#include <math.h>
#include <assert.h>
#include "dwt_bitplane_dec.h"

DecSubbandTree::
DecSubbandTree(SUBBAND_TREE_TYPE *subs, DECODER_TYPE *dec)
  :SubbandTreeCodec(subs), decoder(dec)
{

  int nbands = subband_tree->get_nband();
  NEW_VECTOR(dec_subs, nbands, DEC_SUBBAND_TYPE, "SubbandDec");
  for(int k = 0; k < nbands; k++)
    dec_subs[k].initialize(subband_tree->get_band_ptr(k), this, dec);
}

void DecSubbandTree::
initialize(SUBBAND_TREE_TYPE *subs, DECODER_TYPE *dec)
{
  SubbandTreeCodec::initialize(subs);
  decoder = dec;

  int nbands = subband_tree->get_nband();
  NEW_VECTOR(dec_subs, nbands, DEC_SUBBAND_TYPE, "SubbandDec");
  for(int k = 0; k < nbands; k++)
    dec_subs[k].initialize(subband_tree->get_band_ptr(k), this, dec);

}

void DecSubbandTree::
reset_tree_dec(SUBBAND_TREE_TYPE *subs)
{
  reset_tree_codec(subs);
  int nbands = subband_tree->get_nband();
  for(int k = 0; k < nbands; k++){
    dec_subs[k].reset_band_dec(subband_tree->get_band_ptr(k));
  }
}

//------------------------------------------------------------------------

//   dec_subbitplane_passes(void)

//------------------------------------------------------------------------
void DecSubbandTree::
dec_subbitplane_passes(void)
{

  assert(subband_tree);
  int n, k, i, pass_idx;
  int nbands =  subband_tree->get_nband();

  SubbandCodec::set_byte_budget(total_byte_budget);

  for(k = 0; k <nbands; k++)
    dec_subs[k].start_dec_subband();
  subband_tree->reset_max_msb();

  int max_msb = subband_tree->get_max_msb();
  DecSubband *dec_band;

  for(n = max_msb + EXTRA_BIT; n >= EXTRA_BIT; n--){

    for(pass_idx = 0, k = 0; k < nbands; k++){
      dec_band = &(dec_subs[k]);
      if(n < dec_band->max_bit_idx){
        dec_band->bit_idx = n;
        dec_band->cur_pass = pass_idx;
        dec_band->set_bit_idx_mask();
        dec_band->LSP_break_pt = dec_band->node_list.LSP_end + 1;
        dec_band->update_node_cxts();
        (dec_band->*(dec_band->decode_LIP))();

        if(decoder->bytes_used() > total_byte_budget)
          return;
      }
    }

    for(pass_idx++, k = 0; k < nbands; k++){
      dec_band = &(dec_subs[k]);
      if(n < dec_band->max_bit_idx){
        dec_band->cur_pass = pass_idx;
        (dec_band->*(dec_band->decode_LIS_leaves))();
        if(decoder->bytes_used() > total_byte_budget)
          return;
      }
    }

    int lev, max_depth = dec_subs[nbands-1].qtree.depth;


    for(lev = 2; lev <= max_depth; lev++){
      for(pass_idx++, k = 0; k < nbands; k++){
        dec_band = &(dec_subs[k]);

        if((n == dec_band->max_bit_idx) && (lev == dec_band->qtree.depth)){
          dec_band->bit_idx = n;
          dec_band->cur_pass = pass_idx;
          dec_band->set_bit_idx_mask();
          dec_band->LSP_break_pt = dec_band->node_list.LSP_end + 1;

#ifdef GET_PARENT_MODELS

    if(dec_band->par_cxt_qtree){


#ifdef INITIALIZE_SIGN_MODELS_FROM_PAR
     MODEL_TYPE *par_sign_models, *sign_models;

     sign_models =  dec_band->cxt_qtree.cxt_models +
       dec_band->cxt_qtree.sign_offset;
     par_sign_models = dec_band->par_cxt_qtree->cxt_models +
       dec_band->par_cxt_qtree->sign_offset;
     for(i = dec_band->cxt_qtree.sign_cxts - 1; i >= 0;){
       sign_models[i].reset(par_sign_models[i]);
       sign_models[i--].taub_scale();
     }
#endif

#ifdef INITIALIZE_JSIG_MODELS_FROM_PAR

     MODEL_TYPE *par_jsig_models, *jsig_models;
     int cxts, par_cxts;


     cxts = par_cxts = 0;
     for(i = dec_band->qtree.depth - 2; i >= 0; i--){
       //parent band with depth = qtree.depth - 1
       cxts += dec_band->cxt_qtree.sig_cxts[i];
       par_cxts += dec_band->par_cxt_qtree->sig_cxts[i];
       assert(cxts == par_cxts);
     }
     jsig_models = dec_band->cxt_qtree.cxt_models +
       dec_band->cxt_qtree.sig_offsets[0];
     par_jsig_models = dec_band->par_cxt_qtree->cxt_models +
       dec_band->par_cxt_qtree->sig_offsets[0];
     for(i = cxts-1; i >=0;){
       jsig_models[i].reset(par_jsig_models[i]);
       jsig_models[i--].taub_scale();
     }
#endif

    }   //par_cxt_qtree
#endif  //GET_PARENT_MODELS




#ifdef LSP_BIT_IDX
    //empty lists in the top plane
    for(i = dec_band->qtree.depth-1; i >=0; i--)
      dec_band->node_list.LSP_ids[n][i] = dec_band->node_list.LSP_end;
#endif

          (dec_band->*(dec_band->decode_sig_node))(0, lev-1); //root node
	  dec_band->decode_LIS_stack();
	  if(decoder->bytes_used() > total_byte_budget)
	    return;

	}else if((n < dec_band->max_bit_idx)&&(lev < dec_band->qtree.depth)){
	  dec_band->cur_pass = pass_idx;
	  dec_band->cur_lev = lev;
	  (dec_band->*(dec_band->decode_cur_qtree_level))();

	  if(decoder->bytes_used() > total_byte_budget)
	    return;
	}

      }
    }
    //for(pass_idx++, k = 0; k < nbands; k++){
    for(pass_idx++, k = nbands - 1; k >= 0; k--){
      dec_band = &(dec_subs[k]);
      if(n <= dec_band->max_bit_idx){
        dec_band->cur_pass = pass_idx;
        (dec_band->*(dec_band->decode_LSP))();

        if(decoder->bytes_used() > total_byte_budget)
          return;

        dec_band->reset_cxt_models();

      }//if(n <= dec_band->max_bit_idx){

    }
  }
}

//-----------------------------------------------------------------------------

//      rec_subbands(void)

//-----------------------------------------------------------------------------
void DecSubbandTree::
rec_subbands(void)
{
  int pyr_lev = subband_tree->get_pyr_levels();
  int nband = subband_tree->get_nband();

  for(int k = 0; k < nband; dec_subs[k++].rec_subband());
}
