
#include "general.h"
#include "image_bw.h"
#include "subband.h"
#include "ar_code.h"
#include "dwt_bitplane_enc.h"
#ifdef NDEBUG
#define myassert(seq) seq
#else
#define myassert(seq) assert(seq)
#endif

ENCODER_TYPE data_file;

char names[3][80], * pic_f_name = names[0], * cod_f_name = names[1],
      * new_f_name = names[2];

Chronometer code_time, total_time;

int pel_bytes, threshold_bits, min_bits, pyramid_levels, smoothing,
  mean, mean_shift;

long byte_budget;

float bit_rate, rate_mult;

Image_Coord dimension, pyramid_dim, root_dim;

Image_BW image;

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

//  encode_head()

//----------------------------------------------------------------------
void encode_head()
{

    data_file.code_bits(6, dimension.x >> 8);
    data_file.code_bits(6, dimension.y >> 8);
    data_file.code_bits(8, dimension.x & 0xFF);
    data_file.code_bits(8, dimension.y & 0xFF);
    data_file.code_bits(1, pel_bytes - 1);
    data_file.code_bits(3, smoothing);
    data_file.code_bits(4, mean_shift);
    data_file.code_bits(10, mean);
}
//----------------------------------------------------------------------

//  main()

//----------------------------------------------------------------------
int main(int numb_arg, char * arg[])
{

  if (numb_arg != 2)
    printf("\n\t* Please read the file `codetree.doc' for "
      "instructions\n\t\tand Copyright/Patent information.\n\t* Use"
      " `%s -u' for command-line usage information\n\n", arg[0]);
  else {
    printf("\n* Usage:\n\n%s image_file coded_file number_lines\n\t"
      "pixels/line bytes/pixel bpp_rate [smoothing]", arg[0]);

    puts(" \n");  exit(0); }

  smoothing = 0;

  if ((numb_arg == 7) || (numb_arg == 8)) {
    pic_f_name = arg[1];  cod_f_name = arg[2];
    dimension.x = atoi(arg[3]);  dimension.y = atoi(arg[4]);
    pel_bytes = atoi(arg[5]);
    bit_rate = atof(arg[6]);
    if(numb_arg == 8)
       smoothing = atoi(arg[7]);
  }
  else {
    Input_Line("File with original image", pic_f_name);
    Input_Line("File with compressed image", cod_f_name);
    dimension.x = Input_Int("Number of image lines");
    dimension.y = Input_Int("Number of pixels per line");
    pel_bytes = Input_Int("Number of bytes per pixel");

    bit_rate = Input_Float("Rate (bits/pixel)");
    smoothing = Input_Int("Smoothing (0 = none, 7 = max)"); }

  rate_mult = 8.0 / (float(dimension.x) * float(dimension.y));
  if (Max(dimension.x, dimension.y)>8192) Error("Image is too large!");
  byte_budget = long(bit_rate / rate_mult) - 1;

  total_time.start();

  image.read_pic(dimension, pic_f_name, pel_bytes);

  image.transform(smoothing);  pyramid_dim = image.pyramid_dim();
  mean = image.transform_mean();  mean_shift = image.mean_shift();

  SUBBAND_TREE_TYPE *pyr;
  //assert(pyr = new SUBBAND_TREE_TYPE(image));
  myassert(pyr = new SUBBAND_TREE_TYPE(image));

  image.dispose();

  SubbandCodec::setup_luts();

  ENC_SUBBAND_TREE_TYPE enc_subband_tree;

  enc_subband_tree.initialize(pyr, &data_file);

  data_file.open_file(cod_f_name);

  encode_head();

  enc_subband_tree.set_total_byte_budget(byte_budget);

  code_time.start("\n  Starting bitplane compression...");

  enc_subband_tree.enc_subbitplane_passes();

  code_time.display("\n  Image compressed in");

  total_time.display("\n  Total execution time (I/O included) =");

  puts(" ");

  data_file.close_file();

  return 0;
}


// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =

// end of file < CodeTree.C >

