#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "structN.h"

#define EXTERN extern

#include "arcodemv.h"
void write_number();

/*H----------------------------*/
double log2(double f)
{
  double x;
 
  x = log10(f);
  x /= log10(2.0);
  return(x);
}
 
/*H----------------------------*/

/****************************************************************************/
/*                          bit_plus_follow()                               */
/****************************************************************************/
void bit_plus_follow(int bit)
{
  output_bit(bit);            /* output the bit */
  while(bits_to_follow>0){
    output_bit(!bit);         /* output bits_to_follow opposite bits */
    bits_to_follow--;         /* set bits_to_follow to zero */
  }
}



/****************************************************************************/
/*                           encode_symbol()                                */
/****************************************************************************/
void encode_symbol(int symbol, int num_symbol)
{
  int range;       /* size of the current code region */
  
  if(symbol<0 || symbol>num_symbol+1){
    printf("error in encode_symbol() %d\n", symbol);
    exit(1);
  }

  range =high-low+1;  
  high = low + (range*cmf[symbol-1])/cmf[0]-1;  /* narrow the code */
  low  = low + (range*cmf[symbol])/cmf[0];      /* region */

  for(;;){      /* loop to output bits */
    if(high<Half){
      bit_plus_follow(0);       /* output 0 if in low half */
    }
    else if(low>=Half){         /* output 1 if in high half */
      bit_plus_follow(1);
      low  -= Half;             /* subtract offset to top */
      high -= Half;
    }
    else if(low>=First_qtr && high<Third_qtr){  /* output an opposite bit */
      bits_to_follow++;                         /* later if in middle half */
      low  -= First_qtr;                        /* subtract offset to middle*/
      high -= First_qtr;
    }
    else break;        /* otherwise exit loop */

    low = 2*low;       /* scale up code range */
    high = 2*high+1;      
  }
}




/****************************************************************************/
/*                               append_bit()                               */
/****************************************************************************/
void append_bit(char *bitname, char *tmpname, int with)
{
  int i;

  /* open the bitfile and copy the number of data + bit data */
  if(!(fpbit =fopen(bitname, "a+b"))){
    printf("append_bit: %s\n", bitname); exit(1);
  }
  if(!(fptmp=fopen(tmpname,"rb"))){
    printf("append_bit: %s\n",tmpname); exit(1);
  }

  /* write the number of byte and copy data */
  if(with) write_number();  //printf("outbyte = %d\n", outbyte);
  for(i=0 ; i<outbyte ; i++) putc(getc(fptmp), fpbit);

  fclose(fpbit); fclose(fptmp);

  if(with){
	  outbyte += 4;
  }
    /*if     (outbyte<128)   outbyte++;
	else if(outbyte <= 0x7fff) outbyte +=2;
	else if(outbyte <= 0x7fffffff) outbyte +=4;
    else{ printf("error in append_bit()\n"); exit(1);}
  }*/
}
/****************************************************************************/
/*                               arencode_end()                             */
/****************************************************************************/
void arencode_end(int num_symbol, int with, videoinfo info)
{
  encode_symbol(num_symbol+1, num_symbol); /* EOF symbol */
  bits_to_follow++;                        /* output two bits for underflow */
  (low<First_qtr)? bit_plus_follow(0): bit_plus_follow(1); 

  if(bits_to_go<8){
    putc(buffer>>bits_to_go, fptmp);
    outbyte++;
  }
  fclose(fptmp);

  /* release the memory */
  free(freq); free(cmf); free(int2sym); free(sym2int);

  /* write to the bit file */
  append_bit(info.bitname, info.tmpname, with);
}

/****************************************************************************/
/*                            start_model()                                 */
/****************************************************************************/
void start_model(int num_symbol)
{
  int i;

  for(i=0 ; i<num_symbol ; i++){   /* setup the tables that */
    int2sym[i]   = i+1;             /* translate between symbol */
    sym2int[i+1] = i;               /*  indexes and characters */
  }

  for(i=0 ; i<=num_symbol+1 ; i++) {
    freq[i] = 1;
    cmf[i] = num_symbol+1-i;
  }
  freq[0]=0;     /* freq[0] must not be the same as freq[1] */
}



void encode_init(videoinfo info)
{
  /* open the bitfile */

	if(!(fptmp = fopen(info.tmpname, "wb"))){
    printf("can not open: %s\n", info.tmpname); exit(1);
  }

  /* initialize variables */
  buffer=0; bits_to_go=8; outbyte=0;

}

void encode_end(int with, videoinfo info)
{
  if(bits_to_go<8){
    putc(buffer>>bits_to_go, fptmp);
    outbyte++;
  }
  fclose(fptmp);

  /* write to the bit file */
  append_bit(info.bitname, info.tmpname, with);
}


/****************************************************************************/
/*                               arencode_init()                            */
/****************************************************************************/
void arencode_init(int num_symbol, videoinfo info)
{
  /* memory allocation */
  freq     = (int *) calloc(num_symbol+2, sizeof(int));
  cmf      = (int *) calloc(num_symbol+2, sizeof(int));
  int2sym  = (int *) calloc(num_symbol,   sizeof(int));
  sym2int  = (int *) calloc(num_symbol+2, sizeof(int));
  
  /* open the bitfile */
  if(!(fptmp=fopen(info.tmpname, "wb"))){ 
    printf("arencode_init: %s\n", info.tmpname); exit(1);
  }

  /* initialize variables */
  buffer=0; bits_to_go=8; bits_to_follow=0; outbyte=0;

  /* start model */
  start_model(num_symbol);
  low=0;  high=Top_value;
}

/****************************************************************************/
/*                              ardecode_end()                              */
/****************************************************************************/
void ardecode_end()
{
  /* read if there is something left */
  while(inbyte>0){ 
    getc(fpbit);
    inbyte--;
  }

  free(freq); free(cmf); free(int2sym); free(sym2int);
}

/****************************************************************************/
/*                              ardecode_init()                             */
/****************************************************************************/
void ardecode_init(int num_symbol)
{
  int i, bit;

  /* initialize */
  freq     = (int *) calloc(num_symbol+2, sizeof(int));
  cmf      = (int *) calloc(num_symbol+2, sizeof(int));
  int2sym  = (int *) calloc(num_symbol,   sizeof(int));
  sym2int  = (int *) calloc(num_symbol+2, sizeof(int));
  
  start_model(num_symbol);
  low=0;  high=Top_value;
  value = 0;                          /* input bits ot fill the */
  for(i=1; i<=Code_value_bits ; i++){ /* code value */
    input_bit(bit);
    value =2*value+bit;
  }
}




void decode_init()
{
//  int i, bit;

  garbage_bits=0; 
  bits_to_go=0;
}

void decode_end()
{
  /* read if there is something left */
  while(inbyte>0){ 
    getc(fpbit);
    inbyte--;
  }
}


/****************************************************************************/
/*                             decode_symbol()                              */
/****************************************************************************/
int decode_symbol()
{
  int range;              /* size of current code region */
  int cum;                /* cumulative frequency calculated */
  int symbol;             /* symbol decoded */
  int bit;


  range=high-low+1;
  cum = (((value-low)+1)*cmf[0]-1)/range;    /*find cum freq for value*/

  for(symbol=1; cmf[symbol]>cum; symbol++);  /* then find symbol */

  high = low+(range*cmf[symbol-1])/cmf[0]-1;
  low  = low+(range*cmf[symbol])/cmf[0];
  for(;;){                 /* loop to get rid of bits */
    if(high<Half);         /*  do nothing */
    else if(low>=Half){    /*  expand low half */
      value -= Half;
      low   -= Half;       /* subtract offset to top */
      high  -= Half;
    }
    else if(low>=First_qtr && high<Third_qtr){   /* expand middle half */
      value -= First_qtr;
      low   -= First_qtr;  /* subtract offset to middle */
      high  -= First_qtr;
    }
    else break;            /* otherwise exit loop */

    low  = 2*low;
    high = 2*high+1;       /* scale up code range */
    input_bit(bit);
    value = 2*value+bit;  /* move in next input bit */
  }

  return symbol;
}



/****************************************************************************/
/*                            update_model()                                */
/****************************************************************************/
void update_model(int symbol, int num_symbol)
{
  int i;       /* new index for symbol */
  int cum;
  int ch_i, ch_symbol;

  if(cmf[0] == Max_frequency){      /* see if frequency counts */
    cum=0;
    for(i=num_symbol+1 ; i>=0 ; i--){    /* if so, halve all the counts */
      freq[i]=(freq[i]+1)/2;             /*   (keeping them non-zero)   */
      cmf[i] = cum;
      cum += freq[i];
    }
  }

  for(i=symbol ; freq[i]==freq[i-1] ; i--); /* find symbol's new index */
  
  if(i<symbol){
    ch_i       = sym2int[i];         
    ch_symbol  = sym2int[symbol];     /* update the translation */
    sym2int[i]      = ch_symbol;      /*  tables if the symbol has */
    sym2int[symbol] = ch_i;           /*  moved */
    int2sym[ch_i]      = symbol;
    int2sym[ch_symbol] = i;
  }
  freq[i]++;        /* increment the frequency */
  while(i>0){ 
    i--;            /*  count for the symbol and */
    cmf[i]++;  /* update the cumulative freq. */
  }
}





/****************************************************************************/
/*                               est_number()                               */
/****************************************************************************/
int est_number(int inum)
{
  int numbyte;

  if(inum<0){
    printf("error in est_number() %d\n", inum); 
    exit(1);
  }

  if     (inum<128)   numbyte=1;
  /*else if(inum<32786) numbyte=2;*/
  else  if(inum<=0xffff) numbyte=2;
  else  if(inum<=0xffffffff) numbyte=4;
  else {printf("error in est_number() too large\n"); exit(1);}

  return numbyte;
}



/*****************************************************************************/
/*                                  entropy()                                */
/*****************************************************************************/
float entropy(int codeMAX, int total, int *pmf)
{
  int   i, sum;
  float H, tprob;

  if(!total) return 0.;

  H=0.; sum=0;
  for(i=0 ; i<codeMAX ; i++){
    tprob = (float)pmf[i]/total;
    if(tprob>0. && tprob<=1.) H += -tprob*(float)log2(tprob);
    else if(tprob<0. || tprob>1.){
      printf("error in entropy() 1\n");
      exit(1);
    }
    sum += pmf[i];
  }
  if(sum != total) printf("error in entropy() sum = %d, total = %d\n", sum, total);

  return H;
}


