#include <stdio.h>
#include <stdlib.h> 
#include <math.h> 
#include <string.h>
#include "basic.h" 
#include "structN.h"


void bit_alloc_VBR(videoinfo info, char *bit_alloc_name)
{
  int flag, i, j, exact_b, b1, header, seq_len, frame_rate, GOP_size, no_stream, FAT, max_msb, *GOP_max_msb,stream, bit_plane, remaining_frs;
  double b, sum_mv, *sum_r, budget, sum_k, s_r, k;
  long *mv, **r, **new_r, *rate;
  char seq_name[100], mvstatname[100], bitplanename[100];
  FILE *FID;


  header = sizeof(videoheader);
  printf("Size of header : %d\n", header);

  seq_len = info.last-info.start+1;
  printf("Sequence length:  %d\n", seq_len);

  frame_rate = info.framerate;
  printf("Frame_rate     :%d\n", frame_rate);
  GOP_size   = info.GOPsz;   
  printf("GOP_size       :%d\n", GOP_size);

  /* IVB 2003/6/17 ----------------------- */
  //strncpy(seq_name, info.bitname, 2);seq_name[2]='\0';printf("Sequence name  :%s\n", seq_name);
  sprintf(seq_name, "%s", info.bitname); //printf("Sequence name  :%s\n", seq_name);
  /* IVB 2003/6/17 -------- end ---------- */

  printf("Sequence name  :%s\n", seq_name);

  no_stream = seq_len/GOP_size;
  remaining_frs = seq_len - no_stream * info.GOPsz; 
  if(remaining_frs != 0){
    for(i=info.tPyrLev-1; i>=0; i--){ 
   	  if(((remaining_frs >> i) & 1) == 1){
		 no_stream += 1;
		 remaining_frs -= 0x1 << i;
	  }
	}
  }

  
  printf("Number of GOPs  :%d\n", no_stream);


  //space for FAT
  FAT = no_stream * 4;


  // read mv bytes
  sum_mv = 0;
  if(info.intra == NO){
    sprintf(mvstatname, "%s_mvby", seq_name);
    FID = fopen(mvstatname, "rb");
    if (FID == NULL){
      printf("can not open file mvby\n");  
      exit(1);
	}
    mv = (long *)getarray(no_stream, sizeof(long), "mv");
    for (i=0; i<no_stream; i++){
      fscanf(FID, "%d\n", &(mv[i]));
      sum_mv = sum_mv + mv[i];
	}
    fclose(FID);
  }

 // read bit plane file
  sprintf(bitplanename, "%s_rd_sample.dat", info.bitname);
  FID = fopen(bitplanename, "rb");
  if (FID == NULL){
    printf("can not open file bit_rd_sample.dat\n");  
    exit(1);
  }

  max_msb = 0;
  GOP_max_msb = (int *)getarray(no_stream, sizeof(int), "GOP_max_msb");
  r = (long **)getarray(no_stream, sizeof(long *), "r");

  for (i=0; i<no_stream; i++){
    fscanf(FID, "%d\n", &stream);
    fscanf(FID, "%d\n", &(GOP_max_msb[i]));

	r[i] = (long *)getarray(GOP_max_msb[i]+1, sizeof(long), "r[i]");
    if (GOP_max_msb[i] > max_msb){
      max_msb = GOP_max_msb[i];
    }      

	for (j=GOP_max_msb[i]; j>=0; j--){
      fscanf(FID, "%d", &bit_plane);      
      if (j != bit_plane){
         printf("bit plane index error!\n");
		 exit(1);
	  }
		 
	  fscanf(FID, "%d\n", &(r[i][j]));    
    }
  } // loop of i (no_stream)
  fclose(FID);

  new_r = (long **)getarray(no_stream, sizeof(long *), "new_r");
  for (i=0; i<no_stream; i++){
    new_r[i] = (long *)getarray(max_msb+1, sizeof(long), "new_r[i]");
    for(j=0; j<=GOP_max_msb[i]; j++)
	  new_r[i][j] = r[i][j];
 
	if(GOP_max_msb[i] < max_msb){
	  for(j=GOP_max_msb[i]+1; j<=max_msb; j++)
		new_r[i][j] = r[i][GOP_max_msb[i]];
	}
  }
  for(i=0; i<no_stream; i++){
	free(r[i]);
  }
  free(r);
  r = new_r;

  sum_r = (double *)getarray(max_msb+1, sizeof(double), "sum_r");

  for (j=0; j<=max_msb; j++){
    sum_r[j] = 0;
  }
   
  for (i=0; i<no_stream; i++){
	for (j=max_msb; j>=0; j--){
      sum_r[j] = sum_r[j] + r[i][j];
	}
  } // loop of i (no_stream)

    
  rate = (long *)getarray(no_stream, sizeof(long), "rate");



//allocate bytes to each GOP
    budget = (double)info.bitrate*1000/8*seq_len/frame_rate; 	     // byte
	//printf("mv %lf %d %d %d %f\n",sum_mv, info.bitrate, seq_len, frame_rate, budget);
    budget = budget - header -FAT - sum_mv; 
  
    if (sum_r[max_msb] > budget){ // bit plane max_msb
      printf("can not handle this case: budget is too small.\n");
	  printf("%ld\n", budget);
	  exit(1);
	}
    else{ // else1
	  if (sum_r[max_msb] == budget){
        exact_b = max_msb;
        flag = 0;
	  }
      else{ // else2
		if (sum_r[0] < budget){       
		  exact_b = 0;          		
		  flag = 0; 		
          printf("not more data in the bit stream for allocation.\n");
		}
        else{ //else3    // find the interval
          for (j=max_msb-1; j>=0; j--){  // the other bit planes    
            if (sum_r[j] > budget){
              b1 = j;             // record the index 
              flag = 1;
              break;
			}
            else{
			  if (sum_r[j] == budget){
                exact_b = j;    
                flag = 0;
                break;                
			  }
			}
		  } // for(j)
		} // else3
	  } // else2
	} // else1
   	


    FID = fopen(bit_alloc_name, "wb");
    if (flag == 0){  // perfect match
	  printf("\nStop exactly at bit plane %d\n", max_msb - exact_b);
	  for(j=0; j<no_stream; j++)
        fprintf(FID, "%d\n", r[j][exact_b]);
	}

	 // get the interpolated bytes
	if (flag == 1){
	
	  printf("\nStop at bit plane %d\n", max_msb - b1);
      sum_k = 0.;
      s_r = 0.;
      for (j=0; j<no_stream; j++){
        sum_k = sum_k + r[j][b1+1] - r[j][b1];
        s_r = s_r + r[j][b1];
      }
      b = (budget - s_r + b1 * sum_k)/sum_k;
   
      for(j=0; j<no_stream; j++){
        k = r[j][b1+1] - r[j][b1];
        rate[j] = (long)(r[j][b1] + k*(b-b1));
      }
	  for(j=0; j<no_stream; j++)
        fprintf(FID, "%d\n", rate[j]);    
   
	}
    fclose(FID);





  for(i=0; i<no_stream; i++){
	free(r[i]);
  }
  free(r);
  free(mv);
  free(rate);
  free(sum_r);
  free(GOP_max_msb);
}

