#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "basic.h"
#include "structN.h"
#include "bme_pruneN.h"
 

/*****************************************************************************/
/*                    est_mv_bit2() for a macroblock                         */
/*                    est_mv_bit() is for the whole motion field             */
/*                        no DPCM between macroblock                         */
/*****************************************************************************/
void est_mv_bit2(mvnode_ptr mvtop, vector_ptr fmv, 
                 int x, int y, int xblk, int yblk, int hor, int ver,
                 videoinfo info, int large, int subpel)
{
  int   i, small, itemp;
  int   num_symbol, *mvpmf, full;
  int   leaf, mapbit, mvD, mvbit;
  float pmvx, pmvy, mvbpp;

  small=xblk; itemp=info.level;
  while(itemp!=1){ small/=2; itemp--;}

  /* assign memory and initialize */
  full = (info.maxx!=1)? 1 : 0;
  num_symbol = get_numsymbol(info.level, info.maxx, large, subpel, full);
  mvpmf      = (int *) getarray(num_symbol, sizeof(int), "mvpmf");
  for(i=0 ; i<num_symbol ; i++) mvpmf[i]=0;

  /* estimate the size of the quad-tree map */
  mapbit=0;
  if(info.level!=1){
    est_child_map(fmv, &mapbit, x, y, xblk, yblk, hor, ver, small, info.adapt_flag);
  }

  /* estimate the mv bit by the zero-order entropy and distortion */
  leaf=0; mvD=0;
  pmvx=0.; pmvy=0.; /* no DCPM between marcoblock */
  est_child_mv(fmv, &pmvx, &pmvy, num_symbol, subpel,
               x, y, xblk, yblk, hor, ver, mvpmf, &leaf, &mvD);


  /* mv bit entropy */
  mvbpp = entropy(num_symbol, 2*leaf, mvpmf); /* mvx and mvy */
  mvbit = nint(mvbpp * (2*leaf));

  mvtop->leaf   = leaf;
  mvtop->mapbit = mapbit;
  mvtop->mvbit  = mvbit;
  mvtop->mvD    = mvD;
  mvtop->slope  = 0.;

  /* release the memory */
  free(mvpmf);
}
/****************************************************************************/
/*                             fill_mv_child2()                              */
/****************************************************************************/
void fill_mv_child2(mvnode_ptr mvtop, vector_ptr fmv_root, vector_ptr fmv, int x, int y, int xblk, int yblk, int hor, int ver,
                    videoinfo info, int large, int subpel)
{
  int    dL, dMAP, dMV, dD;
  float  slope;
  mvnode mvcurr;

  if(fmv->child){


    fill_mv_child2(mvtop, fmv_root, fmv->child0, x, y, xblk, yblk, hor, ver,
                   info, large, subpel);
    fill_mv_child2(mvtop, fmv_root, fmv->child1, x, y, xblk, yblk, hor, ver,
                   info, large, subpel);
    fill_mv_child2(mvtop, fmv_root, fmv->child2, x, y, xblk, yblk, hor, ver,
                   info, large, subpel);
    fill_mv_child2(mvtop, fmv_root, fmv->child3, x, y, xblk, yblk, hor, ver,
                   info, large, subpel);


	if(fmv->merge == NO){
	  fmv->slope = HUGE_VAL;
	}
	else{
      /* calculate without this child node */
      fmv->child=0;
      est_mv_bit2(&mvcurr, fmv_root, x, y, xblk, yblk, hor, ver,
               info, large, subpel);
      fmv->child=1;

      /* save the deltaH, deltaD and slope for each nod */
      dL   = mvtop->leaf   - mvcurr.leaf;  dMAP = mvtop->mapbit - mvcurr.mapbit;
      dMV  = mvtop->mvbit  - mvcurr.mvbit; dD   = mvcurr.mvD    - mvtop->mvD;
      slope  = (dMAP+dMV)?  (float)dD/(dMAP+dMV) : HUGE_VAL;

      fmv->dL = dL;   fmv->dMAP = dMAP; 
      fmv->dMV = dMV; fmv->dD = dD;  fmv->slope  = slope;
	}


	fmv->mslope = get_min(fmv->slope, fmv->child0->mslope,fmv->child1->mslope, 
		fmv->child2->mslope, fmv->child3->mslope);

  }
  else{  /* leaf node */
    fmv->dL  = fmv->dMAP = fmv->dMV = fmv->dD = 0;
    fmv->slope = fmv->mslope = HUGE_VAL;
  }
}





/*mvtop = (mvnode *)getarray(info.ynum*info.xnum, sizeof(mvnode), "mvnode_ptr");*/
/*****************************************************************************/
/*                             fill_mv_node2()                               */
/*                   fill the deltaD, deltaH and slope                       */
/*        for every node of the quad-tree structured motion vectors          */
/*****************************************************************************/
void fill_mv_node2(vector_ptr fmv, videoinfo info, int large, int subpel)
{
  int   pos, x, y, X, Y, xnum, ynum, xblk, yblk, hor, ver ;
  mvnode_ptr mvtop;

  xnum=info.xnum; ynum=info.ynum;
  xblk=info.xblk; yblk=info.yblk;
  hor =info.ywidth; ver =info.yheight;

  mvtop = (mvnode_ptr)getarray(xnum*ynum, sizeof(mvnode), "mvtop");  


  /* initial H and D */
  for(y=0, Y=0; Y<ynum; y+=yblk, Y++){  /* coding loop */
    for(x=0, X=0; X<xnum; x+=xblk, X++){
      pos=Y*xnum+X;
      est_mv_bit2(&mvtop[pos], &fmv[pos], x, y, xblk, yblk, hor, ver,
                  info, large, subpel);
    }
  }

  /* fill each node recursively */
  for(y=0, Y=0 ; Y<ynum ; y+=yblk, Y++){
    for(x=0, X=0 ; X<xnum ; x+=xblk, X++){
      pos=Y*xnum+X; /*printf("fill mv node %d\n", pos);*/
      fill_mv_child2(&mvtop[pos], &fmv[pos], &fmv[pos], x, y, xblk, yblk, hor, ver,
                     info, large, subpel);

		/*if(x == 192 && y == 64){
		  printf("pos %d parent %d slope %f child0 %d child1 %d child2 %d child3 %d\n",
			pos, fmv[pos].mode, fmv->slope, fmv[pos].child0->mode, fmv[pos].child1->mode, fmv[pos].child2->mode, fmv[pos].child3->mode);
		  getchar();
		}*/

    }
  }

  free(mvtop);
}






