/*****************************************************************************
 **                                                                         ** 
 **  comboYUV                                                               **
 **                                                                         ** 
 **  -. combine separate Y U V files into one YUV file                      **
 **                                                                         ** 
 **                                                                         ** 
 *****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "basic.h"
#include "structN.h"
#include "rasterfile.h"


void read_command(int argc, char **argv);

char  yuvname[80];
int   start, last, yhor, yver, chor, cver, ci, cj;

/****************************************************************************/
/*                                  usage()                                 */
/****************************************************************************/
void usage()
{
  printf("comboYUV: YUVfile  start last\n");
  printf("-h for help\n");
  printf("-s yhor yver chor cver (def. 352 240 176 120)\n");
}

void main(int argc, char *argv[])
{
 unsigned char *YUVframe;
 FILE *fpin;
  char name[80];

  /* command-line processing */
  read_command(argc, argv);      

  /* allocate memory */
  YUVframe  = (unsigned char*) calloc(yhor*yver*3, sizeof(unsigned char));

  while(start<=last){
    printf(" frame %d is converting ......\n", start);

    sprintf(name, "%s%03d.Y", yuvname, start);
    if(!(fpin  = fopen(name, "rb"))){
      printf("yuv2ras: can't open %s for reading.\n", yuvname);
      exit(1);
    }
    if(fread(YUVframe, sizeof(unsigned char), yhor*yver, fpin) != (unsigned)(yhor*yver)){
	  printf("%d\n", yhor*yver);
      printf("yuv2ras: can't read Y from %s\n", yuvname);
      exit(1);
    }
    fclose(fpin);

    sprintf(name, "%s%03d.U", yuvname, start);
    if(!(fpin  = fopen(name, "rb"))){
      printf("yuv2ras: can't open %s for reading.\n", yuvname);
      exit(1);
    }
    if(fread(YUVframe+yhor*yver, sizeof(unsigned char), chor*cver, fpin) != (unsigned)(chor*cver)){
      printf("yuv2ras: can't read U from %s\n", yuvname);
      exit(1);
    }
    fclose(fpin);
	
	sprintf(name, "%s%03d.V", yuvname, start);
    if(!(fpin  = fopen(name, "rb"))){
      printf("yuv2ras: can't open %s for reading.\n", yuvname);
      exit(1);
    }
    if(fread(YUVframe+yhor*yver+chor*cver, sizeof(unsigned char), chor*cver, fpin) != (unsigned)(chor*cver)){
      printf("yuv2ras: can't read V from %s\n", yuvname);
      exit(1);
    }
    fclose(fpin);


	sprintf(name, "%s%03d", yuvname, start);
    if(!(fpin  = fopen(name, "wb"))){
      printf("yuv2ras: can't open %s for write.\n", yuvname);
      exit(1);
    }
    if(fwrite(YUVframe, sizeof(unsigned char), yhor*yver+2*chor*cver, fpin) != (unsigned)(yhor*yver+2*chor*cver)){
      printf("yuv2ras: can't read V from %s\n", yuvname);
      exit(1);
    }
    fclose(fpin);


    start++;
  }   /******** while loop *************/

  free(YUVframe);
}
			   
/****************************************************************************/
/*                               read_command()                             */
/****************************************************************************/
void read_command(int argc, char **argv)
{
  int argnum=1, i;

  /* setting the default value */
  yhor=352; yver=240; chor=176; cver=120;
  start=0; last=0;
  
  /* read the argument and set the value */
  for(i=1; i<argc ; i++){
    if(*(argv[i])=='-'){
      switch(*(++argv[i])){
      default:
	printf("-%c such an option is not available\n", *(argv[i]));
	usage(); exit(1);
      case 's':
	yhor = atoi(argv[++i]); yver = atoi(argv[++i]); 
	chor = atoi(argv[++i]); cver = atoi(argv[++i]); 
	break;
      case 'h':
	usage(); exit(1);
      }
    }
    else{
      switch(argnum){
      default:
	printf("more parameters are specified\n");
	usage(); exit(1);
      case 1:
	strcpy(yuvname, argv[i]);
	argnum++; break;
      case 2:
	start = atoi(argv[i]);
	argnum++; break;
      case 3:
	last = atoi(argv[i]);
	argnum++; break;
      }
    }
  }
  
  ci = (cver)? yver/cver : 0;
  cj = (chor)? yhor/chor : 0;

  if(argnum==1){       /* print the usage */
    usage(); exit(1);
  }
  if(start<0 || start>last){
    printf("start %d last %d\n", start, last);
    printf("0<= start, last <1000 and start<=last\n");
    exit(1);
  }
}

