/************************************************************************

  The program is modified for 1-4 level temporal decomposition. Temporal 
  DPCM is not used. 

  Shih-Ta Hsiang
  Date: May 30, 1997

  *********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <time.h>
#include "basic.h"
#define EXTERN 
#include "coderN.h"
#include "initN.h"
#include "ioN.h"
#include "memoryN.h"
#include "miscN.h"
#include "dpx.h"
#include "init_decN.h"
#include "mvcodingN.h"
#include "analsyn.h"
#include "pstatN.h"
#include "chrom.h"
#include "display.h"
#include "..\\EZBC0a\\dwt_bitplane_dec.h" 
#include "..\\3dCodec\\ezbc_dec_3d.h"

/* IVB 2003/6/23 ----------------------- */
#define EC         0  /* 0 = no error concealment; 1 = use MC error concealment */
/* IVB 2003/6/23 --------- end --------- */

int read_GOPheader(enum FLAG **scene_change, videoinfo info);

int alloc_pyr_frames(YUVimage *pyrFrs, videoinfo &info);

//void read_header(char *name, videoheader_ptr header);
//void ezbc3d_dec(int curr, YUVimage *pyrFrs,  videoinfo info, int mvBytes,
//				EzbcDec3d& video_dec, DECODER_TYPE& decoder);

void ezbc3d_dec(YUVimage *pyrFrs,  videoinfo info, long total_bytes_past, long int GOP_counter);
void print_time(double sc);

void spatial_syn(float *full, int hor, int ver, float *ll, float *lh, float  *hl, float *hh, int filterType);
void calsnr_frame(YUVimage_ptr fr0, YUVimage_ptr fr1, int curr, videoinfo info);

void wcopyframe(YUVimage *source, YUVimage *dest, float weight);

/*****************************************************************************/
/*                                usage()                                    */
/*****************************************************************************/
void usage()
{
  printf("decoder: bitfile decname inname statname  \n");
}

void read_command(int argc, char **argv, videoinfo *info)
{
  int i, argnum=1;
  

  for(i=1; i<argc ; i++){
	if(*(argv[i])=='-'){

      switch(*(++argv[i])){
      default:
	    printf("-%c such an option is not available\n", *(argv[i]));
    	usage(); exit(1);
      case 'h':	 
		usage(); exit(1);
	    break;
	  }
	}
    else{
      switch(argnum){
      default:
	    printf("more parameters are specified\n");
 	    usage(); exit(1);
      case 1:
	    strcpy(info->bitname, argv[i]);
	    argnum++; break;
      case 2:
	    strcpy(info->decname, argv[i]);
	    argnum++; break;
      case 3:
	    strcpy(info->inname, argv[i]);
	    argnum++; break;
      case 4:
	    strcpy(info->statname, argv[i]);
	    argnum++; break;
      }
    }
  }

  if(argc != 5){  
    usage();
	exit(1);
  }


}


void main(int argc, char **argv)
{
  int  i, j, curr, last, mvBytes, downsamp, GOPheader_bytes, remaining_frs;//len, 
  long      mark, elp;   // initial and elapsed time
  double    duration;
  FILE      *fp_stat, *fpio;
  videoinfo info;
  videoinfo info2;
  long int  total_bytes_past = 0;
  long int  *read_GOP_bytes;
  short int default_tPyrLev;
  int       default_GOPsz;
  enum FLAG DENOISE;
  long int  num_of_GOP, GOP_counter; 
  YUVimage  *spatial_high[3], *FourGOP, tempfr, tempfr2; // only used in info.denoise_flag == YES this case
//  DECODER_TYPE decoder;

  /* IVB 12/5/02 ------------- */
  FILE *fppred;
  YUVimage predframe;
  int size, tPyrLev, half_len, n;
  enum FLAG bi_flag;
  /* IVB 12/5/02 ------------- */

  mark = clock();

  read_command(argc, argv, &info);      
  
  read_header(info.bitname, &info); total_bytes_past += sizeof(videoheader);
  
  switch(info.format){
  case YUV:
  case RAS:
	info.pixeldepth = 8;	 
	break;
  case DPX:
	info.pixeldepth = 10;	  
	break;
  /* IVB 2004/4/7 ---------------- */
  case FLT:
	info.pixeldepth = 32;	  
	break;
  /* IVB 2004/4/7 ---- end ------- */
  default:
	  printf("image format error format = %d(pstatN.c)\n", info.format);
	  exit(1);
  }

  DENOISE = info.denoise_flag;


  default_GOPsz = info.GOPsz;	
  default_tPyrLev = info.tPyrLev;



//  if(info.bi_flag == NO) printf("bi_flag = NO\n");
//  else {printf("bi_flag = YES\n"); exit(1);}

//  scene = (int *)getarray(info.last+2, sizeof(int), "scene");

   /*
   *4:4:4->4:2:0
   */
  downsamp = 0;
  if( (YUV420 == 1) && (info.yheight == info.cheight) && (info.ywidth == info.cwidth)){
	 downsamp = 1;
  }



  num_of_GOP = (info.last-info.start+1)/info.GOPsz; 
  remaining_frs = (info.last-info.start+1) - num_of_GOP * info.GOPsz; 
  if(remaining_frs != 0){
    for(i=info.tPyrLev-1; i>=0; i--){ 
   	  if(((remaining_frs >> i) & 1) == 1){
		 num_of_GOP += 1;
		 remaining_frs -= 0x1 << i;
	  }
	}
  }
  printf("number of GOPs = %d\n", num_of_GOP);
  //num_of_GOP = (info.last-info.start+1+info.GOPsz-1)/info.GOPsz; 

  read_GOP_bytes = (long int *)getarray(num_of_GOP, sizeof(long int), "read_GOP_bytes"); 
  if(!(fpio = fopen(info.bitname, "rb"))){
    printf("can not open: %s\n", info.bitname); exit(1);
  }
  fseek(fpio, total_bytes_past, SEEK_SET);
  fread(read_GOP_bytes, sizeof(long int), num_of_GOP, fpio); 

  //for(i=0;i<num_of_GOP;i++)
	//  printf("fat %d\n", read_GOP_bytes[i]);

  fclose(fpio);
//  for(i=0;i<num_of_GOP; i++) printf("%d\n", read_GOP_bytes[i]);
  total_bytes_past += num_of_GOP * sizeof(long int); //printf("%d\n", total_bytes_past);



  if(!(fp_stat = fopen(info.statname, "wt"))){
    printf("Can not open %s\n", info.statname);
	exit(1);
  }
  fprintf(fp_stat, "\n\tDecoding %.3d-%.3d\n",
          info.start, info.last);  
  fprintf(fp_stat, "\tY: %d x %d; C: %d x %d\n", info.ywidth,
          info.yheight, info.cwidth, info.cheight);
  fprintf(fp_stat, "\tOriginal video frame rate: %d fps\n", info.framerate);
  fprintf(fp_stat, "\tGOP size: %d frs\n", info.GOPsz);
//  fprintf(fp_stat, "\tTarget bytes for each GOP: %d\n", info.GOPbytes);
  fprintf(fp_stat, "\tHeader size: %d bytes\n\n", sizeof(videoheader));
  fclose(fp_stat);


     
  init_dec(info);
//  NEW_VECTOR(pyrFrs, info.GOPsz, YUVimage, "YUVimage");

//  EzbcDec3d video_dec(info, &decoder);
//  SubbandCodec::setup_luts();


  if(DENOISE == YES){
    FourGOP = (YUVimage *)getarray(4*info.GOPsz, sizeof(YUVimage), "FourGOP");
    for(i=0; i<3; i++){
      spatial_high[i] = (YUVimage *)getarray(info.GOPsz, sizeof(YUVimage), "spatial_high[i]");
	}
  }

  curr = info.start;  
  last = info.last;
  GOP_counter = 0;
  switch(info.intra){

  case YES:

	if(DENOISE == YES){
	  printf("In intraframe coding mode, denoise = YES is not allowed\n");
	  exit(1);
	}

//      alloc_pyr_frames(pyrFrs, info);  //release_memory

	  while(curr<=last){  /* MCTF decoding */
		  if(curr + info.GOPsz-1 > last){
			   remaining_frs = last - curr + 1; //printf("remaining frames = %d\n", remaining_frs);			
			   for(i=info.tPyrLev-1; i>=0; i--){					  
				   if(((remaining_frs >> i) & 1) == 1){						  
					   info.tPyrLev = i; //printf("tPyrLev = %d\n", i);// restored after MC-EZBC 						  
					   break;
				   }
			   }
               info.GOPsz = 0x1 << info.tPyrLev;			 // restored after MC-EZBC  
		   }

		    printf(" decoding %d - %d frame .....\n", curr, curr+info.GOPsz-1);

			info.GOPbytes = read_GOP_bytes[GOP_counter];

            ezbc3d_dec(pyrFrs, info, total_bytes_past, GOP_counter);
			total_bytes_past += info.GOPbytes;

#ifdef THREE_D
			alloc_pyrTemp_interior(info);
			if(info.GOPsz == 1){
				copyframe(&pyrFrs[0], &pyrTemp[0][0], info);
			}
			else{
			  t_syn(info);
			}
			for(i = 0; i < info.GOPsz; i++){
				write_frame(pyrTemp[0][i], info, info.decname, curr+i, info.format);
			}
            free_pyrTemp_interior(info);

#else
			for(i = 0; i < info.GOPsz; i++){

 			  write_frame(pyrFrs[i], info, info.decname, curr+i, info.format);
			}
#endif
 
			
			for(i = 0; i < info.GOPsz; i++){
             free_frame_interior(pyrFrs[i]);
			}
            /*calsnr_seq(&cfr, &pfr, curr, curr+nFrsPyr-1, info);*/ /* pstatN.c */ 
			/* cfr and pfr are just used as the memory in calsnr, and the data in cfr and pfr is not used in calsnr */

         curr += info.GOPsz;
		 GOP_counter++;
	  } // while

	 info.GOPsz = default_GOPsz;	 // restore default GOP size
	 info.tPyrLev = default_tPyrLev; // restore default pyramid levels

//	for(i = 0; i < info.GOPsz; i++){
//      free_frame_interior(pyrFrs[i]);
//	}


	  break;

  case NO:



/*

  if(DENOISE == YES){
    info.GOPsz *= 4;
    alloc_pyr_frames(FourGOP, info);
    info.GOPsz /= 4;
	}
  else{
    alloc_pyr_frames(pyrFrs, info); 
	}

	alloc_pyrTemp_interior(info);       
*/
	if(DENOISE == YES){
      info2 = info;
      info2.ywidth *= 2;  info2.yheight *= 2;
      info2.cwidth *= 2;  info2.cheight *= 2;
	}


	while(curr<=last){  /* MCTF decoding */
           
	  if(curr + info.GOPsz-1 > last){
		remaining_frs = last - curr + 1; //printf("remaining frames = %d\n", remaining_frs);			
		for(i=info.tPyrLev-1; i>=0; i--){					  
		  if(((remaining_frs >> i) & 1) == 1){						  
			info.tPyrLev = i; //printf("tPyrLev = %d\n", i);// restored after MC-EZBC 						  
			break;
		  }
		}
		info.GOPsz     = 0x1 << info.tPyrLev;			 // restored after MC-EZBC  
	  }
	  printf(" decoding %d - %d frame .....\n", curr, curr+info.GOPsz-1);
	        //reset(info);

// GOP header and motion fields
			//printf("total_bytes_past = %d\n", total_bytes_past);
		
	  if(info.tPyrLev >= 1){
		if(!(fpbit = fopen(info.bitname, "rb"))){    
		  printf("init_dec: %s\n",info.bitname); exit(1);
		}
		fseek(fpbit, total_bytes_past, SEEK_SET);
			  
		GOPheader_bytes = read_GOPheader(scene_change, info); //printf("%d\n", GOPheader_bytes);
		total_bytes_past += GOPheader_bytes;              
		mvBytes = mv_decoding(info, yfmv);
		total_bytes_past += mvBytes;   //printf("total_bytes_past = %d\n", total_bytes_past);
		fclose(fpbit);
	  }


// residual
	  info.GOPbytes = read_GOP_bytes[GOP_counter];
//	    	ezbc3d_dec(curr, pyrFrs, info, mvBytes, video_dec, decoder);

			
/***
EZBC
***/
/*
			if(GOP_counter <1){
   			  total_bytes_past += info.GOPbytes;
              free_mvs(yfmv, info);
			  GOP_counter++;
   		      curr += info.GOPsz;
              continue;
			}
*/

			if(DENOISE == YES){
			  if(downsamp == 1){
		        info.GOPsz *= 2;
	    	    ezbc3d_dec(FourGOP, info, total_bytes_past, GOP_counter);
		        info.GOPsz /= 2;  
 
 			    for(j=0; j<info.GOPsz; j++){
				  pyrFrs[j] = FourGOP[j];
				} 
                for(i=0; i<1; i++){
				  for(j=0; j<info.GOPsz; j++){
					spatial_high[i][j] = FourGOP[(i+1)*info.GOPsz+j];
				  }
				} 
			  }
			  else{
		        info.GOPsz *= 4;
	    	    ezbc3d_dec(FourGOP, info, total_bytes_past, GOP_counter);
		        info.GOPsz /= 4;  
 
 			    for(j=0; j<info.GOPsz; j++){
			      pyrFrs[j] = FourGOP[j];
				} 
                for(i=0; i<3; i++){
				  for(j=0; j<info.GOPsz; j++){
					spatial_high[i][j] = FourGOP[(i+1)*info.GOPsz+j];
				  }
				} 
			  }
			}			 
			else{			
			  ezbc3d_dec(pyrFrs, info, total_bytes_past, GOP_counter);
			}

			// IVB 2003/6/23 insert reading predframe here 

			/* IVB 2003/6/23 ------------------------------------------- */
			if (EC)
			{	
				tPyrLev = info.tPyrLev;
				bi_flag = info.bi_flag;

				frame_alloc(&predframe, info);

				/* open file for predicted frame */
				if(!(fppred = fopen("PredFrame","rb")))
				{
 					printf("main() in decoderN.c : cannot open PredFrame\n");
					exit(1);
				}

				size = (info.ywidth)*(info.yheight);
				if(fread(predframe.Y, sizeof(float), size, fppred) != (unsigned)size)
				{
					printf("main() in decoderN.c : cannot read predframe.Y\n"); exit(1);
				}

				size = (info.cwidth)*(info.cheight);
				if(size)
				{
					if(fread(predframe.U, sizeof(float), size, fppred) != (unsigned)size)
					{
						printf("main() in decoderN.c : cannot read predframe.U\n"); exit(1);
					}
					if(fread(predframe.V, sizeof(float), size, fppred) != (unsigned)size)
					{
						printf("main() in decoderN.c : cannot read predframe.V\n"); exit(1);
					}
				}

				/* replace pyrFrs[0] with predfframe */
				half_len = 1;
				n = 0;
				//for(i = tPyrLev-1; i >=info.t_level; i--)
				for(i = tPyrLev-1; i >= 0; i--)
				{
					if (i < tPyrLev-1) half_len *= 2;

					for(j = 0; j < half_len; j++)
					{
						/* This executs for all 0 <= j <half_len, so last value of n corresponds
							to j near half_len, i.e. near the end of GOP ??? what about break ??? */
						if ((bi_flag == YES && scene_change[i][j*2] == YES && scene_change[i][j*2+1] == YES)
							|| (bi_flag == NO && scene_change[i][j*2+1] == YES))
						{
							n = tPyrLev - 1 - i; /* 2/15/03 */
							//printf("n = %d, t_level = %d, frame = %d\n",n, i, j);
							break;
						}
						else
						{
							break;
						}
					}
				}

				//printf("mctf_syn_ezbc(): scaling n = %d\n",n);
				wcopyframe(&predframe, &pyrFrs[0], (float)pow(2.0, -(double)n/2.0), info);
  
				//copyframe(&predframe, &pyrFrs[0], info);
  
				/* close file and clear memory */
				fclose(fppred);
				free_frame_interior(predframe);
			}
			/* IVB 2003/6/23 ------------------- end ----------------------- */


			total_bytes_past += info.GOPbytes;
			alloc_pyrTemp_interior(info);     

			if(info.tPyrLev >= 1){
			  mc_syn(curr, info);
              free_mvs(yfmv, info);
			}
			else{					  
				copyframe(&pyrFrs[0], &pyrTemp[0][0], info);
			}

			if(info.bi_flag == YES){
			  copyframe(&pyrTemp[0][info.GOPsz-1], &end_of_lastGOP, info);
			  //wcopyframe(&pyrFrs[0], &end_of_lastGOP, (float)(1./pow(2., info.tPyrLev/2.)), info);

			}


			if(DENOISE == YES){
              /*			
			   float ysnr, usnr, vsnr; FILE *fpstat;			
			   fpstat = fopen(info.statname, "at+");    
			   if(fpstat == NULL){
			 	printf("can not open file\n");
				exit(1);
			   }
              */
/*******
 spatial 
synthesis
********/
              int filterType = 2;
			  if(Quater == 0){				
			    for(i = 0; i < info.GOPsz; i++){

				  frame_alloc(&tempfr, info2);   frame_alloc(&tempfr2, info2);

				  if(downsamp ==1){
 				    spatial_syn(tempfr.Y, info2.ywidth, info2.yheight, pyrTemp[0][i].Y, 
					  spatial_high[0][i].Y, spatial_high[0][i].U, spatial_high[0][i].V, filterType);
			 
				    for(j=0;j<info2.cwidth*info2.cheight/4;j++){
					  tempfr.U[j]=pyrTemp[0][i].U[j]*4;
					  tempfr.V[j]=pyrTemp[0][i].V[j]*4;
					}

				  }
				  else{
 				    spatial_syn(tempfr.Y, info2.ywidth, info2.yheight, pyrTemp[0][i].Y, 
					  spatial_high[0][i].Y, spatial_high[1][i].Y, spatial_high[2][i].Y, filterType);
				    if(info2.cwidth && info2.cheight){
					  spatial_syn(tempfr.U, info2.cwidth, info2.cheight, pyrTemp[0][i].U, 
						spatial_high[0][i].U, spatial_high[1][i].U, spatial_high[2][i].U, filterType);
					  spatial_syn(tempfr.V, info2.cwidth, info2.cheight, pyrTemp[0][i].V, 
   					    spatial_high[0][i].V, spatial_high[1][i].V, spatial_high[2][i].V, filterType);				
					}
				  }


			      if( downsamp == 1){
		            read_frame(&tempfr2, info2, info.inname, curr+i, info.format);  				  							
			        f444_420(info2, &tempfr2); 
										
					info2.cwidth /= 2; //printf("info2.ywidth %d info2.cwidth %d\n", info2.ywidth, info2.cwidth);
					info2.cheight /= 2;
					calsnr_frame(&tempfr, &tempfr2, curr+i, info2);
				    f420_444(info2, &tempfr);
					info2.cwidth *= 2;
				    info2.cheight *= 2;
				  }
				    
				
				  write_frame(tempfr, info2, info.decname, curr+i, info.format);
                  /*read_frame(&tempfr2, info2, info.inname, curr+i, info.format);
                  snr_frame(&ysnr, &usnr, &vsnr, &tempfr, &tempfr2, info2);
				  fprintf(fpstat, "%.2f\t  %.2f\t  %.2f\n", ysnr, usnr, vsnr);*/
			      free_frame_interior(tempfr); free_frame_interior(tempfr2);
				}        
			 // fclose(fpstat);
			  }            
			  else{

			    printf("only output spatial LL bands!!!!!\n");

			    for(i = 0; i < info.GOPsz; i++){
				  write_frame(pyrTemp[0][i], info, info.decname, curr+i, info.format);
				}
			  }


			  if(downsamp == 1){
			    for(i=0; i<info.GOPsz*2; i++)  
				  free_frame_interior(FourGOP[i]);
			  }
			  else{
			    for(i=0; i<info.GOPsz*4; i++)  
				  free_frame_interior(FourGOP[i]);
			  }
			} //DENOISE==YES
            else{
			  for(i = 0; i < info.GOPsz; i++){
				//write_frame(pyrTemp[0][i], info, info.decname, info.last+1-(curr+i), info.format);// REVERSE_SEQ
			 	 write_frame(pyrTemp[0][i], info, info.decname, curr+i, info.format);
			  }

#ifdef CASEMAP
            // analyze unconnected pixel
			  unconnected_pel(curr, 0, info); //current frame 
			  unconnected_pel(curr, 1, info); //reference frame
#endif

			  for(i = 0; i < info.GOPsz; i++){
                free_frame_interior(pyrFrs[i]); 
			  }
			}
  

            free_pyrTemp_interior(info);  

			/*calsnr_seq(&cfr, &pfr, curr, curr+info.GOPsz-1, info);*/ /* pstatN.c */ /* cfr and pfr are just used as the memory in calsnr, and the data in cfr and pfr is not used in calsnr */


  		   GOP_counter++;
		   curr += info.GOPsz;


	 } // while

	 info.GOPsz = default_GOPsz;	 // restore default GOP size
	 info.tPyrLev = default_tPyrLev; // restore default pyramid level

	 /*
	if(DENOISE == YES){
		for(i=0; i<info.GOPsz*4; i++)   
			free_frame_interior(FourGOP[i]);
    }
	else{
		for(i = 0; i < info.GOPsz; i++){  
           free_frame_interior(pyrFrs[i]); 
		}
    }
        free_pyrTemp_interior(info);   
*/

	
	 break;

	 default:
		 printf("error in decoderN.c\n");
		 exit(1);

  }

  if(DENOISE == YES){

    if(Quater == 0)
      calsnr(info.start, info.last, info2);
  }
  else{
    calsnr(info.start, info.last, info);
  }

  info.bitrate = (int)(8 * total_bytes_past * ((float)info.framerate/(info.last-info.start+1)));
  if(!(fp_stat = fopen(info.statname, "at+"))){
    printf("Can not open %s\n", info.statname);
	exit(1);
  }
  fprintf(fp_stat, "\n\t total bytes %d, rate %d bps \n",
          total_bytes_past, info.bitrate);  
  fclose(fp_stat);
//  SubbandCodec::delete_cxt_tables();





  dec_destructor(info);
  free(read_GOP_bytes);
	
  if(info.denoise_flag == YES){
	for(i=0; i<3; i++)
	  free(spatial_high[i]);
	free(FourGOP);
  }
 
  elp = clock() - mark;   
  duration = (double)elp / CLOCKS_PER_SEC;
  print_time(duration);


//	fclose(fpbit);
} 








