#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#define EXTERN extern
#include "coderN.h"
#include "basic.h"
/*#include "decN.h"*/

void  interpolate_filter();

void frame_alloc(YUVimage_ptr frame, videoinfo info);

/*****************************************************************************/
/*                         init_dec()                                        */
/*****************************************************************************/
void init_dec(videoinfo info)
{
  int   i, j, xnum, ynum, xblk, yblk, hor, ver, len;
  /*int   picture_rate, totalrate, illbit, pllbit, lhbit, hbit;*/

  interpolate_filter();

  
  printf("-------------------------------------------------\n");
  printf(" Bit file        : %s\n", info.bitname);
  printf(" Decoded sequence : %s\n", info.decname);
  if(info.level==1){
    printf(" Motion : FSBM with Bx %d By %d and",info.xblk,info.yblk);

    if(info.subpel == 4) printf("1/16-pixel accuracy\n");
    else if(info.subpel == 3) printf("1/8-pixel accuracy\n");
    else if(info.subpel == 2) printf("quater-pixel accuracy\n");
    else if(info.subpel == 1) printf("half-pixel accuracy\n");
	else  printf("full-pixel accuracy\n");


  }
  else if(info.level==5){
    printf(" Motion : HVSBM and");
    if(info.subpel == 2) printf(" quater-pixel accuracy\n");
    else if(info.subpel == 1) printf(" half-pixel accuracy\n");
	else  printf(" full-pixel accuracy\n");
  }
  printf(" start           : %4d\n", info.start);
  printf(" last            : %4d\n", info.last);
  printf(" size            : (Y) %d x %d  (C) %d x %d in MCTF\n", 
	 info.ywidth, info.yheight, info.cwidth, info.cheight);
  printf(" framerate       : %d (frames/sec)\n", info.framerate);
  printf(" rate            : %d (kbits/sec)\n", info.bitrate);
  printf("-------------------------------------------------\n");

  /****************** initialize the sequence information ****************/
  hor  = info.ywidth; ver  = info.yheight;
  xblk = info.xblk;   yblk = info.yblk;
  xnum = info.xnum;   ynum = info.ynum;
//  nFrsPyr = (int)pow(2.0, (double)info.tPyrLev);

  /***************** allocate the 1st layer motion vectors ***************/
  if(info.level){
    /* mvtop = (mvnode_ptr)getarray(info.GOPsz, sizeof(mvnode), "mvtop");  */
    yfmv = (vector_ptr*) getarray(info.GOPsz, sizeof(vector_ptr), "yfmv_ptr");
    for(j = 1; j < info.GOPsz; j++){
      yfmv[j] = (vector_ptr) getarray(xnum*ynum, sizeof(vector), "yfmv");

      for(i=0 ; i<xnum*ynum ; i++){
        yfmv[j][i].child=0; yfmv[j][i].parent=NULL; yfmv[j][i].mode = DEFAULT;

      }
    }
  }

  /************ allocate the frame *************/
  if(info.level){
    frame_alloc(&pfr, info);
    frame_alloc(&cfr, info);

    frame_alloc(&end_of_lastGOP, info); 


  }
  else frame_alloc(&cfr, info);

 
  if(info.tPyrLev >= 1){
    pyrFrs = (YUVimage_ptr)getarray(info.GOPsz, sizeof(YUVimage), "pyrFrs_ptr");
//    for(i = 0; i < info.GOPsz; i++){
//      frame_alloc(&pyrFrs[i], info);
//   }

    pyrTemp = (YUVimage_ptr*)getarray(info.tPyrLev, sizeof(YUVimage_ptr), 
                                      "pyrTemp");
/*    len = info.GOPsz/2; */

    len = info.GOPsz;               /*Chen Feb 23,00*/
/*    for(i = 1; i < info.tPyrLev; i++){*/
    for(i = 0; i < info.tPyrLev; i++){  /*Chen Feb 23,00*/
      pyrTemp[i] = (YUVimage_ptr)getarray(len, sizeof(YUVimage), 
                                       "pyrTemp[]");
//      for(j = 0; j < len; j++){
//        frame_alloc(&pyrTemp[i][j], info);
//      }
      len /= 2;
    }
  }
  else{
    pyrFrs = (YUVimage_ptr)getarray(info.GOPsz, sizeof(YUVimage), "pyrFrs_ptr");
	pyrTemp = (YUVimage_ptr*)getarray(1, sizeof(YUVimage_ptr), 
                                      "pyrTemp");
	pyrTemp[0] = (YUVimage_ptr)getarray(1, sizeof(YUVimage), 
                                       "pyrTemp[]");

  }



  frY = (float**)getarray(info.GOPsz, sizeof(float*), "*frY");
  frU = (float**)getarray(info.GOPsz, sizeof(float*), "*frU");
  frV = (float**)getarray(info.GOPsz, sizeof(float*), "*frV");

  scene_change = (enum FLAG **)getarray(info.tPyrLev, sizeof(enum Flag *), "scene_change");
  GOPscene = (int **)getarray(info.tPyrLev, sizeof(int *), "GOPscene");

  len = info.GOPsz;         
  for(i = 0; i < info.tPyrLev; i++){  
    GOPscene[i] = (int *)getarray(len+1, sizeof(int), "GOPscene");
	GOPscene[i] = GOPscene[i] + 1;// So the GOPscene[-1] is for the last frame of the previous GOP.
    scene_change[i] = (enum FLAG *)getarray(len, sizeof(enum FLAG), "scene_change");
    len /= 2;
  }


}

