#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include "structN.h"
#include "basic.h"


#define CLOCKS   1e6     /* for CPU time */

#define  Infinity  100000.0

long clock();



/*
 *    variance()   
 *  calculate variance of a sub_block inside an frame.
 *  frame : a pointer pointing the upper-left corner of this block
 *  lenx  : width of sub_block.
 *  leny  : height of sub_block.
 *  hor   : width of the original frame
 */
float variance(float *frame, int lenx, int leny, int hor)
{
  int        x, y, pos;
  double     data, mean, mean2;
  float *iptr;

  if(!(lenx*leny)) return 0.;
  iptr = frame;

  mean = mean2 = 0.;
  for(y=0; y<leny ; y++){
    for(x=0 ; x<lenx ; x++){
      mean  += *iptr;
      mean2 += (*iptr)*(*iptr);
      iptr++;
    }
    iptr += hor-lenx;
  }
  mean  /= lenx*leny;
  mean2 /= lenx*leny;

  mean2 -= mean*mean;

  return((float)mean2);

}
/*
 *    get_mean()   
 *  calculate mean of a sub_block inside a frame.
 *  frame : a pointer pointing the upper-left corner of this block
 *  lenx  : width of sub_block.
 *  leny  : height of sub_block.
 *  hor   : width of the original frame
 */

float get_mean(float *frame, int lenx, int leny, int hor)
{
  int        x, y, pos;
  double     mean;
  float *iptr;

  if(!(lenx*leny)) return 0.;
  iptr = frame;

  mean = 0.;
  for(y=0; y<leny ; y++){
    for(x=0 ; x<lenx ; x++){
      mean  += *iptr;
      iptr++;
    }
    iptr += hor-lenx;
  }
  mean  /= lenx*leny;
  return((float)mean);
}


double variance_mean(float *frame, int lenx, int leny, float *mean)
{
  int        x, y, pos;
  double     data, sum, sum2;

  if(!(lenx*leny)) return 0.;
  sum = sum2 = 0.;
  for(y=0; y<leny ; y++){
	  pos = y * lenx;
    for(x=0 ; x<lenx ; x++){
      data = frame[pos+x];
      sum  += data;
      sum2 += data*data;
    }
  }
  *mean  = (float)(sum / (lenx*leny));
  sum2 /= lenx*leny;
  sum2 -= (*mean)*(*mean);

  return(sum2);
}

/*****************************************************************************/
/*                                 varianceP1()                              */
/*****************************************************************************/
void varianceP1(YUVimage frame, videoinfo info, rateP1_ptr allocP1)
{
  int yhor, yver, chor, cver;

  yhor = info.ywidth; yver = info.yheight;
  chor = info.cwidth; cver = info.cheight;

  allocP1->yvar = variance(frame.Y, yhor, yver, yhor);
  allocP1->uvar = variance(frame.U, chor, cver, chor);
  allocP1->vvar = variance(frame.V, chor, cver, chor);
}


void varianceGOP(YUVimage_ptr frames, videoinfo info, Rate_ptr alloc)
{
  int i, yhor, yver, chor, cver;

  yhor = info.ywidth; yver = info.yheight;
  chor = info.cwidth; cver = info.cheight;

  for(i = 0; i < info.GOPsz; i++){
    alloc->yvar[i] = variance(frames[i].Y, yhor, yver, yhor);
    alloc->uvar[i] = variance(frames[i].U, chor, cver, chor);
    alloc->vvar[i] = variance(frames[i].V, chor, cver, chor);
  }

  return;
}
/*****************************************************************************/
/*                              header2info()                                */
/*****************************************************************************/
void header2info(videoinfo_ptr info, videoheader header)
{
  info->framerate = header.framerate;
  info->format = header.format;
  info->coding_domain = header.coding_domain;
  info->min    = header.min;        info->max       = header.max;

  info->intra  = header.intra;
  info->ywidth    = header.ywidth;  info->yheight   = header.yheight;  
  info->cwidth    = header.cwidth;  info->cheight   = header.cheight;
  info->start     = header.start;   info->last      = header.last;

  info->level = header.level; info->subpel  = header.subpel;
  info->xblk  = header.xblk;  info->yblk  = header.yblk;
  info->maxx  = header.maxx;  info->maxy  = header.maxy;
  info->xnum  = header.xnum;  info->ynum  = header.ynum;
  info->bitrate    = header.bitrate;
  info->adapt_flag = header.adapt_flag;

  info->bi_flag    = header.bi_flag;
  info->OPEN_GOP   = header.OPEN_GOP;
  info->CUT        = header.CUT;
  info->MCP_flag   = header.MCP_flag;
  info->tPyrLev    = header.tPyrLev;
  info->GOPsz      = 0x1 << header.tPyrLev;
  info->denoise_flag = header.denoise_flag;

/*
  info->ybandGOP = (int*)getarray(info.GOPsz, sizeof(int), "ybandgop");
  info->cbandGOP = (int*)getarray(info.GOPsz, sizeof(int), "cbandgop");
  printf("nlev = %d\n", header.tPyrLev);
  len = 1; count = 0;
  for(i = 0; i <= header.tPyrLev; i++){
    for(j = 0; j < len; j++){
      printf("count = %d i = %d j = %d\n", count, i, j);
      info->ybandGOP[count] = header.ybandGOP[i];
      info->cbandGOP[count] = header.cbandGOP[i];
      count++;
    }
    if(i) len *= 2;
  }
*/
}

/*****************************************************************************/
/*                              info2header()                                */
/*****************************************************************************/
void info2header(videoheader_ptr header, videoinfo info)
{
  header->framerate = (short int)info.framerate;
  header->format = info.format;
  header->coding_domain = info.coding_domain;
  header->min    = info.min;     header->max  = info.max;
  header->intra  = info.intra;
  header->ywidth    = (short int)info.ywidth;
  header->yheight   = (short int)info.yheight;
  header->cwidth    = (short int)info.cwidth;
  header->cheight   = (short int)info.cheight;
  header->start     = (short int)info.start;
  header->last      = (short int)info.last;

  header->level     = (short int)info.level;
  header->subpel      = (short int)info.subpel;
  header->xblk      = (short int)info.xblk;
  header->yblk      = (short int)info.yblk;
  header->maxx      = (short int)info.maxx;
  header->maxy      = (short int)info.maxy;
  header->xnum      = (short int)info.xnum;
  header->ynum      = (short int)info.ynum;
  header->bitrate   = info.bitrate;
  header->adapt_flag= info.adapt_flag;
  header->bi_flag   = info.bi_flag;
  header->OPEN_GOP  = info.OPEN_GOP;
  header->CUT       = info.CUT;
  header->MCP_flag  = info.MCP_flag;
  header->tPyrLev   = (unsigned char)info.tPyrLev;

  header->denoise_flag = info.denoise_flag;

/*
  j = 1; count = 0;
  for(i = 0; i <= info.tPyrLev; i++){
    printf("i = %d, count = %d\n", i, count);
    header->ybandGOP[i] = (unsigned char)info.ybandGOP[count];  
    header->cbandGOP[i] = (unsigned char)info.cbandGOP[count];
    j *= 2;
  }
*/

}



/*****************************************************************************/
/*                                get_mvBytes()                              */
/*****************************************************************************/

int get_mvBytes(FILE *fp_mv)
{
  int bytes;
  char iline[80];

  fgets(iline, 78, fp_mv);
  sscanf(iline, "%d", &bytes);
  return bytes;
}

/*****************************************************************************/
/*                                 timecheck()                               */
/*****************************************************************************/
void timecheck(long *pmark, int mode)
{
  float sec;
  long  cmark;

  cmark = clock();   /* current clock */
  sec  = (float)(cmark - *pmark)/CLOCKS;
  *pmark = cmark;

  switch(mode){
  default: printf("error in timecheck()\n"); exit(1);
  case 0: printf("ME   = %5.2f seconds.\n", sec); break;
  case 1: printf("MCTF = %5.2f seconds.\n", sec); break;
  case 2: printf("WAVE = %5.2f seconds.\n", sec); break;
  case 3: printf("FSSQ = %5.2f seconds.\n", sec); break;
  }
}

/*****************************************************************************/
/*                                 showtime()                                */
/*****************************************************************************/
void showtime(long pmark)
{
  int   hour, min;
  float sec;
  long  cmark;

  cmark = clock();   /* current clock */
  sec  = (float)(cmark - pmark)/CLOCKS;
  hour = (int)(sec/3600.0);  sec -= 3600.0 * hour;
  min  = (int)(sec/60.0);    sec -= 60.0 * min;

  printf("%d hour %d min %5.2f seconds.\n", hour, min, sec);
}




void computegain(YUVimage lowband, YUVimage highband, videoinfo info)
{
  int yhor, yver, chor, cver;
  double var0, var1, gain;

  yhor = info.ywidth; yver = info.yheight;
  chor = info.cwidth; cver = info.cheight;

  var0 = variance(lowband.Y, yhor, yver, yhor);
  var1 = variance(highband.Y, yhor, yver, yhor);
  gain = (var0 + var1) / 2.0;
  gain /= sqrt(var0 * var1);
  fprintf(stdout, "lowband yvar = %f highband yvar = %f coding gain = %f\n", (float)var0, (float)var1, (float)gain);

  if(chor){
    var0 = variance(lowband.U, chor, cver, chor);
    var1 = variance(highband.U, chor, cver, chor);
    gain = (var0 + var1) / 2.0;
    gain /= sqrt(var0 * var1);
    fprintf(stdout, "lowband uvar = %f highband uvar = %f coding gain = %f\n", (float)var0, (float)var1, (float)gain);
  
    var0 = variance(lowband.V, chor, cver, chor);
    var1 = variance(highband.V, chor, cver, chor);
    gain = (var0 + var1) / 2.0;
    gain /= sqrt(var0 * var1);
    fprintf(stdout, "lowband vvar = %f highband vvar = %f coding gain = %f\n", (float)var0, (float)var1, (float)gain);
  }

} 


void copyframe(YUVimage *source, YUVimage *dest, videoinfo info)
{
  int i;

  for(i = 0; i < info.ywidth * info.yheight; i++){
    dest->Y[i] = source->Y[i];
  }
  if(info.cwidth && info.cheight){
    for(i = 0; i < info.cwidth * info.cheight; i++){
      dest->U[i] = source->U[i];
      dest->V[i] = source->V[i];
    }
  }

}

void wcopyframe(YUVimage *source, YUVimage *dest, float weight, videoinfo info)
{
  int i;

  if (weight < Infinity)
  {
	  for(i = 0; i < info.ywidth * info.yheight; i++){
		  dest->Y[i] = source->Y[i] * weight;
	  }

      if(info.cwidth && info.cheight){
          for(i = 0; i < info.cwidth * info.cheight; i++){
              dest->U[i] = source->U[i] * weight;
              dest->V[i] = source->V[i] * weight;
		  }
	  }
  }
  else
  {
	  for(i = 0; i < info.ywidth * info.yheight; i++){
		  dest->Y[i] = Infinity;
	  }

      if(info.cwidth && info.cheight){
          for(i = 0; i < info.cwidth * info.cheight; i++){
              dest->U[i] = Infinity;
              dest->V[i] = Infinity;
		  }
	  }
  }

}

void blendframes(YUVimage *source1, YUVimage *source2, float weight1, float weight2, YUVimage *dest, videoinfo info)
{
  int i;

  for(i = 0; i < info.ywidth * info.yheight; i++){
    dest->Y[i] = source1->Y[i] * weight1 + source2->Y[i] * weight2;
  }
  if(info.cwidth && info.cheight){
    for(i = 0; i < info.cwidth * info.cheight; i++){
      dest->U[i] = source1->U[i] * weight1 + source2->U[i] * weight2;
      dest->V[i] = source1->V[i] * weight1 + source2->V[i] * weight2;
    }
  }

}

void blendframes2(YUVimage *source1, YUVimage *source2, float weight1, float weight2, unsigned char *yvalid, unsigned char *cvalid, YUVimage *dest, videoinfo info)
{
  int i;

  /*for(i = 0; i < info.ywidth * info.yheight; i++){
    dest->Y[i] = source1->Y[i] * weight1*yvalid[i] + source2->Y[i] * (1-weight1*yvalid[i]);
  }
  if(info.cwidth && info.cheight){
    for(i = 0; i < info.cwidth * info.cheight; i++){
      dest->U[i] = source1->U[i] * weight1*cvalid[i] + source2->U[i] * (1-weight1*cvalid[i]);
      dest->V[i] = source1->V[i] * weight1*cvalid[i] + source2->V[i] * (1-weight1*cvalid[i]);
    }
  }*/

  for(i = 0; i < info.ywidth * info.yheight; i++)
  {
	  //if (source1->Y[i] < Infinity) 2006/07/07
	  if ((source1->Y[i] <= 256.0) && (source1->Y[i] >= 0.0))
		  dest->Y[i] = source1->Y[i] * weight1 + source2->Y[i] * (1.0-weight1);
	  else
		  dest->Y[i] = source2->Y[i];
  }
  if(info.cwidth && info.cheight){
    for(i = 0; i < info.cwidth * info.cheight; i++)
	{   
		//if (source1->U[i] < Infinity) 2006/07/07
		if ((source1->U[i] <= 256.0) && (source1->U[i] >= 0.0))
		  dest->U[i] = source1->U[i] * weight1 + source2->U[i] * (1.0-weight1);
	    else
		  dest->U[i] = source2->U[i];

		//if (source1->V[i] < Infinity) 2006/07/07
		if ((source1->V[i] <= 256.0) && (source1->V[i] >= 0.0))
		  dest->V[i] = source1->V[i] * weight1 + source2->V[i] * (1.0-weight1);
	    else
		  dest->V[i] = source2->V[i];
    }
  }

}