/*
This file pulls out bit stream from the pre-encoded bit stream

Command line options with their arguments
     -C          CBR, default is VBR
     -r kbps     Average bit rate(kilobits per second)
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define EXTERN
#include "coderN.h"
#include "miscN.h"
#include "ioN.h"
#include "basic.h"
#include "dpx.h"

//#define TWO_LAYERS // IVB 2003/6/17: for BL (= header+MV) and EL
//#define PACKET_DELIMIT // insert packet delimiters into the bitstream
#define MAX_PACKET_SIZE 512

int read_number_core(FILE *fp);
void write_number_core(int outputbyte, FILE *fp);
int read_GOPheader(enum FLAG **scene_change, videoinfo info);
void bit_alloc_VBR(videoinfo info, char *bit_alloc_name);


void usage()
{
  printf("pull pre_encoded_stream -r kbps [-C]\n");
}

void read_command(int argc, char **argv, int *kbps, char *pre_stream, enum FLAG *CBR)
{
  int i, argnum=1;
  
  *CBR = NO;
  for(i=1; i<argc ; i++){
	if(*(argv[i])=='-'){

      switch(*(++argv[i])){
      default:
	    printf("-%c such an option is not available\n", *(argv[i]));
    	usage(); exit(1);
      case 'h':	 
		usage(); exit(1);
	    break;
      case 'r':
	    *kbps = atoi(argv[++i]); 
	    break;
	  case 'C':
		*CBR = YES;
		break;
	  }
	}
    else{
      switch(argnum){
      default:
	    printf("more parameters are specified\n");
 	    usage(); exit(1);
      case 1:
	    strcpy(pre_stream, argv[i]);
	    argnum++; break;
      }
    }
  }
  
}

void main(int argc, char **argv)
{
  int i, j, k, curr, last, num_of_GOP, GOPheader_bytes, len, remaining_frs ;
  int mvBytes, total_mv, nlev, nfrs;
  videoinfo   info;
  long int in_bytes = 0, out_bytes=0, *fat, *newfat;
  unsigned char *data;
  FILE *outfp, *fp;
  short int default_tPyrLev;
  int   default_GOPsz;
  int kbps;
  char pre_stream[100], post_stream[100], bit_alloc_name[100];
  enum FLAG CBR;

  /* files for 2-layer pull:

	name				pointer			function
	---------------------------------------------
	pre_stream			fpbit			EZBC bitstream (input)
	post_stream			outfp			EZBC enhancement layer
	post_alloc_name		fppostalloc		TOC for enhancement layer
	base_stream			basefp			EZBC base layer
	base-alloc_name		fpbasealloc		TOC for base layer
  */

   /* IVB 2003/6/17 -------------------- */
#if defined(TWO_LAYERS)
  char base_stream[100], base_alloc_name[100], post_alloc_name[100];
  FILE *basefp, *fpbasealloc, *fppostalloc;
#elif defined(PACKET_DELIMIT)
  unsigned char pkt_header[4], *pdata;
  int in_pkt_bytes = 0, out_pkt_bytes = 0, bytes1 = 0, bytes2 = 0;
  int GOP_number = 0, pkt_number = 0, pkt_size = 0;
  videoheader header;
#endif

  int strN, strN2;
  char tempstr[100], tempstr2[100];
  /* IVB 2003/6/17 ------- end -------- */


  kbps = 0;
  read_command(argc, argv, &kbps, pre_stream, &CBR);      
	
  if(kbps <=0 ){
	printf("this parameter is not right\n");	
	usage();	
	exit(1);
  }
 
/*****
header
*****/  
  read_header(pre_stream, &info); in_bytes += sizeof(videoheader);
  info.bitrate = kbps;
  strcpy(info.bitname, pre_stream);

  /* IVB 2003/6/17 -------------------- */
  //sprintf(post_stream, "%.2s_%d.bit", info.bitname, info.bitrate);
#if defined(TWO_LAYERS)
  // name is of the type "<sequence_name>_GOPXXX.bit" where XXX is the GOP number
  // search for first '_' in the pre_stream
  strN = (int) strcspn(pre_stream, "_");
  // copy initial segment to tempstr
  strncpy(tempstr, pre_stream, strN);
  tempstr[strN] = '\0'; // terminate the string
  // now tempstr contains <sequence name>

  strN2 = (int) strcspn(&pre_stream[strN], "."); // look for "."
  strncpy(tempstr2, &pre_stream[strN], strN2);
  tempstr2[strN2] = '\0';
  // now tempstr contains "_GOPXXX"

  //sprintf(post_stream, "%s_ezbc_el.m4v", tempstr);
  sprintf(post_stream, "%s_ezbc_el%s.m4v", tempstr, tempstr2);
  //sprintf(bit_alloc_name, "%s_ezbc_el_bytes_per_GOP", tempstr);
  //sprintf(post_alloc_name, "%s_ezbc_el_bytes_per_GOP", tempstr);
  sprintf(post_alloc_name, "%s_ezbc_el%s_bytes_per_GOP", tempstr, tempstr2);
#elif defined(PACKET_DELIMIT)
  // search for first '.' in the pre_stream
  strN = (int) strcspn(pre_stream, ".");
  // copy initial segment to tempstr
  strncpy(tempstr, pre_stream, strN);
  tempstr[strN] = '\0'; // terminate the string

  sprintf(post_stream, "%s_pkt_%d.bit", tempstr, info.bitrate);
#else
  // search for first '.' in the pre_stream
  strN = (int) strcspn(pre_stream, ".");
  // copy initial segment to tempstr
  strncpy(tempstr, pre_stream, strN);
  tempstr[strN] = '\0'; // terminate the string

  sprintf(post_stream, "%s_%d.bit", tempstr, info.bitrate);
  //sprintf(bit_alloc_name, "%.2s_bytes_per_GOP%d", info.bitname, info.bitrate);
#endif
  sprintf(bit_alloc_name, "%s_bytes_per_GOP%d", tempstr, info.bitrate);
  /* IVB 2003/6/17 ------- end -------- */


  default_GOPsz = info.GOPsz;	
  default_tPyrLev = info.tPyrLev;

  info.bitrate=kbps;

  /* IVB 2003/6/17 -------------------- */
#if defined(TWO_LAYERS)
  //sprintf(base_stream, "%s_ezbc_bl.m4v", tempstr);
  sprintf(base_stream, "%s_ezbc_bl%s.m4v", tempstr, tempstr2);
  write_header(base_stream, info);
  //sprintf(base_alloc_name, "%s_ezbc_bl_bytes_per_GOP", tempstr);
  sprintf(base_alloc_name, "%s_ezbc_bl%s_bytes_per_GOP", tempstr, tempstr2);
  // first entry into base stream - video header
  if(!(fpbasealloc = fopen(base_alloc_name, "wb")))
  {
    printf("can not open: %s\n", base_alloc_name); exit(1);
  }
#elif defined(PACKET_DELIMIT)
  pkt_size = 0;
  out_pkt_bytes = 0;
  GOP_number = 0;
  pkt_number = 0;
  // open output file
  if(!(outfp = fopen(post_stream, "w+b"))){
    printf("can not open: %s\n", post_stream); exit(1);
  }
  // write packet header
  pkt_header[0] = (unsigned char)(GOP_number%256);
  pkt_header[1] = (unsigned char)(pkt_number%256);
  pkt_header[2] = (unsigned char)(pkt_size/256);
  pkt_header[3] = (unsigned char)(pkt_size%256);
  fwrite(pkt_header, sizeof(unsigned char), 4, outfp);
  out_bytes += 4;
  out_pkt_bytes += 4;
  pkt_size += 4;
  //printf("pkt_size = %d\n", pkt_size);
  // write sequence header
  info2header(&header, info);
  //printf("info.tPyrLev = %d, header.tPyrLev = %d\n", info.tPyrLev, header.tPyrLev);
  fwrite(&header, sizeof(videoheader), 1, outfp);
  out_pkt_bytes += sizeof(videoheader);
  pkt_size += sizeof(videoheader);
  printf("pkt_size = %d\n", pkt_size);

  // go to start of packet header
  fseek(outfp, -pkt_size, SEEK_CUR);
  pkt_header[2] = (unsigned char)(pkt_size/256);
  pkt_header[3] = (unsigned char)(pkt_size%256);
  fwrite(pkt_header, sizeof(unsigned char), 4, outfp);
  fseek(outfp, pkt_size-4, SEEK_CUR);

  // close output file
  fclose(outfp);
#else
  write_header(post_stream, info);
#endif
  /* IVB 2003/6/17 ---------- end ----- */

  out_bytes += sizeof(videoheader);

   //printf("%d\n", sizeof(videoheader));


  if(CBR == NO)
    bit_alloc_VBR(info, bit_alloc_name);
/****
FAT
****/
  if(!(fpbit = fopen(pre_stream, "rb"))){
    printf("can not open: %s\n", pre_stream); exit(1);
  }

  /* IVB 2003/6/17 -------------------- */
#if defined(TWO_LAYERS)
  if(!(basefp = fopen(base_stream, "r+b"))){
    printf("can not open: %s\n", base_stream); exit(1);
  }
  if(!(outfp = fopen(post_stream, "w+b"))){
    printf("can not open: %s\n", post_stream); exit(1);
  }
  if(!(fppostalloc = fopen(post_alloc_name, "wb"))){
    printf("can not open: %s\n", post_alloc_name); exit(1);
  }
  printf("files open\n");
#else
  if(!(outfp = fopen(post_stream, "r+b"))){
    printf("can not open: %s\n", post_stream); exit(1);
  }
#endif
  /* IVB 2003/6/17 ------------ end --- */


  num_of_GOP = (info.last-info.start+1)/info.GOPsz; 
  remaining_frs = (info.last-info.start+1) - num_of_GOP * info.GOPsz; 
  if(remaining_frs != 0){
    for(i=info.tPyrLev-1; i>=0; i--){ 
   	  if(((remaining_frs >> i) & 1) == 1){
		 num_of_GOP += 1;
		 remaining_frs -= 0x1 << i;
	  }
	}
  }
  //printf("number of GOPs = %d\n", num_of_GOP);
  //num_of_GOP = (info.last-info.start+1+info.GOPsz-1)/info.GOPsz; 





  fat = (long int *)getarray(num_of_GOP, sizeof(long int), "fat"); 
  fseek(fpbit, in_bytes, SEEK_SET);
  fread(fat, sizeof(long int), num_of_GOP, fpbit); //printf("%d\n", fat[0]);
  in_bytes += num_of_GOP * sizeof(long int); 

  newfat = (long int *)getarray(num_of_GOP, sizeof(long int), "newfat");
  
  /* IVB 2003/6/17 -------------------- */
#if defined(TWO_LAYERS)
  fseek(basefp, out_bytes, SEEK_SET);
  fwrite(newfat, sizeof(long int), num_of_GOP, basefp);

  fprintf(fpbasealloc,"h %d\n", sizeof(videoheader) + num_of_GOP * sizeof(long int)); // video header bytes + FAT bytes
  fprintf(fpbasealloc,"f %d\n", info.start); // first frame
  fprintf(fpbasealloc,"l %d\n", info.last); // last frame
  fprintf(fpbasealloc,"G %d\n", info.GOPsz); // default GOP size
  fprintf(fpbasealloc,"T %d\n", info.tPyrLev); // default levels of temporal pyramid
  //fprintf(fpbasealloc,"t %d\n", info.t_level); // temporal level for decoding
  if (info.adapt_flag == NO)
	  fprintf(fpbasealloc,"a 0\n"); // adaptive GOP ?
  else
	  fprintf(fpbasealloc,"a 1\n");

#elif defined(PACKET_DELIMIT)
  fseek(outfp, out_bytes, SEEK_SET);
  fwrite(newfat, sizeof(long int), num_of_GOP, outfp);
  out_pkt_bytes += num_of_GOP * sizeof(long int);
  pkt_size += num_of_GOP * sizeof(long int);
  // go to start of packet header
  fseek(outfp, -pkt_size, SEEK_CUR);
  // new packet size
  pkt_header[2] = (unsigned char)(pkt_size/256);
  pkt_header[3] = (unsigned char)(pkt_size%256);
  fwrite(pkt_header, sizeof(unsigned char), 4, outfp);
  fseek(outfp, pkt_size-4, SEEK_CUR);

#else
  fseek(outfp, out_bytes, SEEK_SET);
  fwrite(newfat, sizeof(long int), num_of_GOP, outfp);
#endif
  /* IVB 2003/6/17 ------------ end --- */


  out_bytes += num_of_GOP * sizeof(long int);

  if(CBR == NO){
    if(!(fp = fopen(bit_alloc_name, "rb"))){
      printf("can not open %s(split.c)\n", bit_alloc_name);
      exit(1);
	}
    for(i=0; i<num_of_GOP; i++)
	  fscanf(fp, "%d\n", &(newfat[i]));
    fclose(fp);
  }


  if(info.intra == NO){
    scene_change = (enum FLAG **)getarray(info.tPyrLev, sizeof(enum Flag *), "scene_change");
    len = info.GOPsz;         
    for(i = 0; i < info.tPyrLev; i++){  
      scene_change[i] = (enum FLAG *)getarray(len, sizeof(enum FLAG), "scene_change");
      len /= 2;
	}
  }

  curr  = info.start;   
  last  = info.last;



  i = 0;

  while(curr<=last){  /* MCTF decoding */
	  if(curr + info.GOPsz-1 > last){	
		  remaining_frs = last - curr + 1; //printf("remaining frames = %d\n", remaining_frs);					
		  for(j=info.tPyrLev-1; j>=0; j--){					  		
			  if(((remaining_frs >> j) & 1) == 1){						  	
				  info.tPyrLev = j; //printf("tPyrLev = %d\n", j);// restored after MC-EZBC
				  break;
			  }
		  }          
		  info.GOPsz = 0x1 << info.tPyrLev;			 // restored after MC-EZBC  
	  }
	nlev = info.tPyrLev;


	printf("GOP %d: frame %d ~ frame %d\n", i, curr, curr+info.GOPsz-1);
	total_mv = 0;
    GOPheader_bytes = 0;
	if(info.intra == NO &&info.tPyrLev >= 1){
/*
      len = info.GOPsz;
      nlev = info.tPyrLev;
	  count = 0;
      for(k=0; k<nlev; k++){
	    for(j=0; j<len; j++){
		  count++;
		}
	    len /= 2;
	  }
      GOPheader_bytes = (count + 7)/8;
*/         	 
/********
GOPheader
********/
  	  GOPheader_bytes = read_GOPheader(scene_change, info); //printf("%d\n", GOPheader_bytes);
	  fseek(fpbit, -GOPheader_bytes, SEEK_CUR);

	  data = (unsigned char *)getarray(GOPheader_bytes, sizeof(unsigned char), "data");
      if(fread(data, sizeof(unsigned char), GOPheader_bytes, fpbit) != (unsigned)GOPheader_bytes){
	    printf("fread error1 \n");
	    exit(1);
	  }	      
	  in_bytes += GOPheader_bytes;

	  /* IVB 2003/6/17 -------------------- */
#if defined(TWO_LAYERS)
   	  fwrite(data, sizeof(unsigned char), GOPheader_bytes, basefp);
	  fprintf(fpbasealloc,"g %d\n", GOPheader_bytes);
	  // write scene changes to BL TOC
	  nfrs = 1;
	  for(j = info.tPyrLev-1; j >= 0; j--)
	  {
		  for(k = 0; k < nfrs; k++)
		  {
			  if (scene_change[j][k*2]==NO)
				  fprintf(fpbasealloc, "0 ");
			  else
				  fprintf(fpbasealloc, "1 ");
		  }
		  nfrs *= 2;
	  }
	  fprintf(fpbasealloc, "\n");

#elif defined(PACKET_DELIMIT)
	  fwrite(data, sizeof(unsigned char), GOPheader_bytes, outfp);
	  out_pkt_bytes += GOPheader_bytes;
	  pkt_size += GOPheader_bytes;
	  // go to start of packet header
	  fseek(outfp, -pkt_size, SEEK_CUR);
	  // new packet size
	  pkt_header[2] = (unsigned char)(pkt_size/256);
	  pkt_header[3] = (unsigned char)(pkt_size%256);
	  fwrite(pkt_header, sizeof(unsigned char), 4, outfp);
	  fseek(outfp, pkt_size-4, SEEK_CUR);

#else
   	  fwrite(data, sizeof(unsigned char), GOPheader_bytes, outfp);    
#endif
	  /* IVB 2003/6/17 ------------ end --- */

	  out_bytes += GOPheader_bytes;
      free(data);

/**
MV
**/
      nfrs = 1;
      for(j = nlev-1; j >= 0; j--){
        for(k = 0; k < nfrs; k++){
		  if(scene_change[j][k*2] == NO || scene_change[j][k*2+1] == NO || info.adapt_flag == NO){            

    	    //printf("about to read number core\n");

			mvBytes = read_number_core(fpbit); //printf("%d\n", mvBytes); // fpbit will move forward by 4 bytes 
	        in_bytes += 4;
			
			/* IVB 2003/6/17 -------------------- */
#if defined(TWO_LAYERS)
			write_number_core(mvBytes, basefp);
			//fprintf(fpbasealloc,"-c 4\n");
#elif defined(PACKET_DELIMIT)
			//printf("pkt_size = %d\n",pkt_size);
			if (pkt_size + 4 > MAX_PACKET_SIZE)
			{
				// start new packet
				pkt_number++;
				pkt_size = 0;
				out_pkt_bytes = 0;
				pkt_header[0] = (unsigned char)(GOP_number%256);
				pkt_header[1] = (unsigned char)(pkt_number%256);
				pkt_header[2] = (unsigned char)(pkt_size/256);
				pkt_header[3] = (unsigned char)(pkt_size%256);
				fwrite(pkt_header, sizeof(unsigned char), 4, outfp);
				out_bytes += 4;
				out_pkt_bytes += 4;
				pkt_size += 4;
			}
			write_number_core(mvBytes, outfp);
			out_pkt_bytes += 4;
			pkt_size += 4;
			// go to start of packet header
			fseek(outfp, -pkt_size, SEEK_CUR);
			// new packet size
			pkt_header[2] = (unsigned char)(pkt_size/256);
			pkt_header[3] = (unsigned char)(pkt_size%256);
			fwrite(pkt_header, sizeof(unsigned char), 4, outfp);
			fseek(outfp, pkt_size-4, SEEK_CUR);

#else
			write_number_core(mvBytes, outfp);
#endif
			/* IVB 2003/6/17 ----------- end ---- */

            out_bytes += 4;
            total_mv += 4;



			//printf("mvBytes %d\n", mvBytes);
            data = (unsigned char *)getarray(mvBytes, sizeof(unsigned char), "data");
            if(fread(data, sizeof(unsigned char), mvBytes,fpbit) != (unsigned)mvBytes){
		      printf("fread error2 %d\n", mvBytes);
		      exit(1);
			}
            in_bytes += mvBytes;


			/* IVB 2003/6/17 -------------------- */
#if defined(TWO_LAYERS)
            fwrite(data, sizeof(unsigned char), mvBytes, basefp);
			//fprintf(fpbasealloc,"-m %d\n", mvBytes);
			fprintf(fpbasealloc,"m %d\n", mvBytes+4);

#elif defined(PACKET_DELIMIT)
			bytes1 = MAX_PACKET_SIZE - pkt_size; // part that fits into current packet
			bytes2 = mvBytes; // bytes not yet written
			pdata = data; // 2003/12/06
			while (bytes2*sizeof(unsigned char) > bytes1)
			{
				// write bytes1 bytes
				//fwrite(data, sizeof(unsigned char), bytes1, outfp);
				fwrite(pdata, sizeof(unsigned char), bytes1, outfp); // 2003/12/06
				pkt_size += bytes1;
				out_pkt_bytes += bytes1;
				// move pointer
				//data += bytes1;
				pdata += bytes1; // 2003/12/06
				// go to start of packet header
				fseek(outfp, -pkt_size, SEEK_CUR);
				// new packet size
				pkt_header[2] = (unsigned char)(pkt_size/256);
				pkt_header[3] = (unsigned char)(pkt_size%256);
				fwrite(pkt_header, sizeof(unsigned char), 4, outfp);
				fseek(outfp, pkt_size-4, SEEK_CUR);
				
				// start new packet
				pkt_number++;
				pkt_size = 0;
				out_pkt_bytes = 0;
				pkt_header[0] = (unsigned char)(GOP_number%256);
				pkt_header[1] = (unsigned char)(pkt_number%256);
				pkt_header[2] = (unsigned char)(pkt_size/256);
				pkt_header[3] = (unsigned char)(pkt_size%256);
				fwrite(pkt_header, sizeof(unsigned char), 4, outfp);
				out_bytes += 4;
				out_pkt_bytes += 4;
				pkt_size += 4;
				bytes2 -= bytes1;
				bytes1 = MAX_PACKET_SIZE - pkt_size;
			}
			//fwrite(data, sizeof(unsigned char), bytes2, outfp);
			fwrite(pdata, sizeof(unsigned char), bytes2, outfp); // 2003/12/06
			pkt_size += bytes2;
			out_pkt_bytes += bytes2;
			// go to start of packet header
			fseek(outfp, -pkt_size, SEEK_CUR);
			// new packet size
			pkt_header[2] = (unsigned char)(pkt_size/256);
			pkt_header[3] = (unsigned char)(pkt_size%256);
			fwrite(pkt_header, sizeof(unsigned char), 4, outfp);
			fseek(outfp, pkt_size-4, SEEK_CUR);
			//data -= mvBytes; //2003/12/04
			
#else
            fwrite(data, sizeof(unsigned char), mvBytes, outfp);
#endif
			/* IVB 2003/6/17 ----------- end ---- */

            //printf("MV bytes written\n");
			
			out_bytes += mvBytes;
		    total_mv += mvBytes;
			free(data); 

			//printf("data freed\n");
			printf("(%d,%d): out_bytes = %d, mvBytes = %d\n", j, k, out_bytes, mvBytes);

		  }
		}
        nfrs *= 2;
	  }
	}//if(info.intra == NO &&info.tPyrLev >= 1)

	//printf("all MV bytes written\n");

// read bit plane
	data = (unsigned char *)getarray(fat[i], sizeof(unsigned char), "data");
    if(fread(data, sizeof(unsigned char), fat[i], fpbit) != (unsigned)fat[i]){
	  printf("read error3 %d %d\n", i, fat[i]);
	  exit(1);
	}		
    in_bytes += sizeof(unsigned char) * fat[i]; //printf("%d\n", in_bytes);

//write  bit plane      
    if(CBR == YES){   // calculate the fat according to bit rate
	  newfat[i] = (long)((kbps * 1000.0 / 8.0) * ((float)info.GOPsz/info.framerate)) - total_mv - GOPheader_bytes;
	  if(i == 0)
	    newfat[i] -= sizeof(videoheader) + sizeof(long int) * num_of_GOP;      
	}
    if(fat[i] < newfat[i]){
      printf("no enough bytes for allocation fat[i]=%d newfat[i]=%d!\n", fat[i], newfat[i]);
      newfat[i] = fat[i];
	}

#if defined(PACKET_DELIMIT)
			pdata = data; // 2003/12/06
			newfat[i] -= (pkt_number+1)*4; // previously written packet headers
			newfat[i] -= (newfat[i]*4)/MAX_PACKET_SIZE+1; // packet headers to be written
			bytes1 = MAX_PACKET_SIZE - pkt_size; // part that fits into first packet
			bytes2 = newfat[i]; // bytes not yet written
			while (bytes2*sizeof(unsigned char) > bytes1)
			{
				// write bytes1 bytes
				//fwrite(data, sizeof(unsigned char), bytes1, outfp);
				fwrite(pdata, sizeof(unsigned char), bytes1, outfp); // 2003/12/06
				pkt_size += bytes1;
				out_pkt_bytes += bytes1;
				// move pointer
				//data += bytes1;
				pdata += bytes1; // 2003/12/06
				// go to start of packet header
				fseek(outfp, -pkt_size, SEEK_CUR);
				// new packet size
				pkt_header[2] = (unsigned char)(pkt_size/256);
				pkt_header[3] = (unsigned char)(pkt_size%256);
				fwrite(pkt_header, sizeof(unsigned char), 4, outfp);
				fseek(outfp, pkt_size-4, SEEK_CUR);
				
				// start new packet
				pkt_number++;
				pkt_size = 0;
				out_pkt_bytes = 0;
				pkt_header[0] = (unsigned char)(GOP_number%256);
				pkt_header[1] = (unsigned char)(pkt_number%256);
				pkt_header[2] = (unsigned char)(pkt_size/256);
				pkt_header[3] = (unsigned char)(pkt_size%256);
				fwrite(pkt_header, sizeof(unsigned char), 4, outfp);
				out_bytes += 4;
				out_pkt_bytes += 4;
				pkt_size += 4;
				bytes2 -= bytes1;
				bytes1 = MAX_PACKET_SIZE - pkt_size;
			}
			//fwrite(data, sizeof(unsigned char), bytes2, outfp);
			fwrite(pdata, sizeof(unsigned char), bytes2, outfp); // 2003/12/06
			pkt_size += bytes2;
			out_pkt_bytes += bytes2;
			// go to start of packet header
			fseek(outfp, -pkt_size, SEEK_CUR);
			// new packet size
			pkt_header[2] = (unsigned char)(pkt_size/256);
			pkt_header[3] = (unsigned char)(pkt_size%256);
			fwrite(pkt_header, sizeof(unsigned char), 4, outfp);
			fseek(outfp, pkt_size-4, SEEK_CUR);
			//data -= newfat[i]; // 2003/12/04

#else
 	if(fwrite(data, sizeof(unsigned char), newfat[i], outfp) != (unsigned)newfat[i]){
	  printf("write error %d\n", newfat[i]);
	  exit(1);
	}
#endif

	out_bytes += sizeof(unsigned char) * newfat[i];



	
#if defined(TWO_LAYERS)
	fprintf(fppostalloc, "%d\n", sizeof(unsigned char) * newfat[i]);
#endif

    free(data); 


	 
	curr += info.GOPsz;


	i++;

#if defined(PACKET_DELIMIT)
	printf("GOP_number = %d, pkt_number = %d\n", GOP_number, pkt_number);
	if (curr<=last)
	{
		// new GOP => new packet
		GOP_number++;
		// start new packet
		pkt_number = 0;
		pkt_size = 0;
		out_pkt_bytes = 0;
		pkt_header[0] = (unsigned char)(GOP_number%256);
		pkt_header[1] = (unsigned char)(pkt_number%256);
		pkt_header[2] = (unsigned char)(pkt_size/256);
		pkt_header[3] = (unsigned char)(pkt_size%256);
		fwrite(pkt_header, sizeof(unsigned char), 4, outfp);
		out_bytes += 4;
		out_pkt_bytes += 4;
		pkt_size += 4;
	}

#endif
  } // while

/*********
write FAT
*********/
/* IVB 2003/6/17 ------------------ */
#if defined(TWO_LAYERS)
  fseek(basefp, sizeof(videoheader), SEEK_SET);
  if(fwrite(newfat, sizeof(long int), num_of_GOP, basefp) != (unsigned)num_of_GOP){	  
	  printf("write error \n");
	  exit(1);
  }
#elif defined(PACKET_DELIMIT)
  // skip first packet header (4 bytes) and video header
  fseek(outfp, 4+sizeof(videoheader), SEEK_SET);
  if(fwrite(newfat, sizeof(long int), num_of_GOP, outfp) != (unsigned)num_of_GOP){	  
	  printf("write error \n");
	  exit(1);
  }
#else
  fseek(outfp, sizeof(videoheader), SEEK_SET);
  if(fwrite(newfat, sizeof(long int), num_of_GOP, outfp) != (unsigned)num_of_GOP){	  
	  printf("write error \n");
	  exit(1);
  }
#endif
/* IVB 2003/6/17 --------- end ---- */


  //for(i=0; i<num_of_GOP; i++)
	//  printf("fat %d\n", newfat[i]);

  fclose(fpbit);
  fclose(outfp);

#if defined(TWO_LAYERS)
  fclose(basefp);
  fclose(fpbasealloc);
  fclose(fppostalloc);
#endif

  free(fat); free(newfat);


  info.GOPsz = default_GOPsz;	 // restore default GOP size	
  info.tPyrLev = default_tPyrLev; // restore default pyramid levels

  if(info.intra == NO){
	 for(i = 0; i < info.tPyrLev; i++){  
		 free(scene_change[i]);
	 }         
	 free(scene_change);
  }


  printf("total bytes read from %s is %d \n", pre_stream, in_bytes);
#if defined(TWO_LAYERS)
  printf("total bytes written to %s and %s is %d \n", base_stream, post_stream, out_bytes);
#elif defined (PACKET_DELIMIT)
  //printf("GOP_number = %d, pkt_number = %d\n", GOP_number, pkt_number);
  printf("total bytes written to %s is %d \n", post_stream, out_bytes);

#else
  printf("total bytes write to  %s is %d \n", post_stream, out_bytes);
#endif

}
