#define SCALE_DOWN
#define LIFTING
//#define BEST_TEMP_SCALABILITY
//#define INTRA_CODED_BLOCK    // at this mode, we transmit the means of INTRABLOCK separately, otherwise we still use MCP, but without update on temporal low subband
//#define  CASEMAP 
//#define  THREE_D
#define Quater 0  //  Quater takes effect only when DENOISE is defined. if Quater =1, then in decoderN.c we output the spatial low low subbands.
//#define  STATISTICS

#define YUV420 0  // downsample full resolution U V component


#define  BlockShift 3

/*********** general collection of necessary data for encoder **********/
//enum FORMAT {YUV, RAS, DPX};
enum FORMAT {YUV, RAS, DPX, FLT}; // IVB 2004/4/7
enum FLAG   {YES, NO};
enum CODING_DOMAIN {LOG, LINEAR, VIDEO};
enum PixelMode   {UNI, MULTI, INTRA, UNDEF};
  /* UNI: uniconnected; MULTI: multiconnected; INTRA: unmatched pixel; UNDEF: have not been decided
   In the reference, pixels could only be UNI, MULTI finally.
   In the current frame, pixels could be UNI, MULTI, and INTRA finally. 
   */
enum BlockMode {DEFAULT, INTRABLOCK, REVERSE};
     /*
	 DEFAULT represents the mainstream motion estimation direction.
     REVERSE represents the reverse direction of DEFAULT.
	 INTRABLOCK represent intra-coded mode
	 */


/* type definitions for variable length code table entries */

typedef struct
{
  unsigned char code; /* right justified */
  char len;
} VLCtable;

// The elements of blockmode should correspond to the elements of enum BlockMode
static VLCtable blockmodeVLC[3]=
{
  {0,1},  //DEFAULT    huffman code = 0
  {2,2},  //INTRABLOCK huffman code = 10
  {3,2}   //REVERSE    huffman code = 11
};

typedef struct {
  char inname[80];     /* input sequence */
  char decname[80];    /* decoded sequence */
  char bitname[80];    /* encoded bit file and temp file */
  char statname[80];   /* statistics */
  char tmpname[80];  
  char mvname[80];     /* motion vectors */

  char mvstatname[80]; /* number of bytes spent for individual GOPs*/
  char tsubname[80];   /* prefix of temporal subband files */

  int  framerate;      /* general information */
  int  ywidth;         /* spatial resolution for Y, U and V */
  int  yheight;  
  int  cwidth; 
  int  cheight;
  int  start;          /* start - last */
  int  last;
  int  verbose;        /* for debugging */

  enum FORMAT  format; /* image format */
  enum  CODING_DOMAIN coding_domain; // compression data in which domain, make sense only when format = DPX

  unsigned char pixeldepth;
  int  min;            /* minimum pixel value*/ 
  int  max;            /* maximum pixel value*/
  
  
  enum FLAG   intra;   /* intra coding */
  int  level;          /* fixed or variable-size block matching */
  int  ME;             /* motion estimation scheme */
  float lambda;        /* for HVSBM */
  int  subpel;           /* accuracy for MC temporal analysis */
  int  xblk;           /* block size */
  int  yblk;
  int  search;         /* search width/height motion */
  int  maxx;           /* search size */
  int  maxy;
  int  xnum;           /* number of blocks */
  int  ynum;



  int   bitrate;       /* overall target rate kbps*/
  int   GOPbytes;      /* target rate for GOP */

  enum FLAG denoise_flag;
  enum FLAG adapt_flag;
  enum FLAG bi_flag;
  enum FLAG OPEN_GOP;
  enum FLAG CUT; 
  enum FLAG MCP_flag;
  short int tPyrLev;
  int   GOPsz;


  float prate;         /* targer rate for one frame */
  int   i1bit;         /* target rate for I1 */
  int   p1bit;         /* target rate for P1 */
//  int   GOPbit;      /* target rate for GOP */
  int   CBR;
 // float maxD;

                        /* for buffer and rate control */
  int   generated;      /* actually generated bits */
  int   diff;           /* difference = goal (i4, p4, p1 bit) - generated */
  int   buff_full;      /* encoder buffer fullness */
  int   buff_max;       /* encoder buffer size = prate*6 */


//  int   *ybandGOP;
//  int   *cbandGOP;
//  int   yclassI1;       
//  int   cclassI1;
//  int   yclassP1;      
//  int   cclassP1;
//  int   *yclassGOP;
//  int   *cclassGOP;
//  int   ydpcmI1;
//  int   cdpcmI1;
//  int   ydpcmP1;
//  int   cdpcmP1;
//  int   *ydpcmGOP;
//  int   *cdpcmGOP;

//  int rateGOP;
//  int rateP;
//  int rateI;

  int nFrsGOP;
} videoinfo, *videoinfo_ptr;


/*********** general collection of necessary data for decoder **********/
typedef struct {
  short int    framerate;      /* general information */
  short int    ywidth;         /* spatial resolution for Y, U and V */
  short int    yheight;  
  short int    cwidth; 
  short int    cheight;
  enum  FORMAT format;
  enum  CODING_DOMAIN coding_domain; /* compression data in which domain */ 

  int  min;            /* minimum pixel value*/ 
  int  max;            /* maximum pixel value*/

  enum  FLAG  intra;
  short int  start;          /* start - last */
  short int  last;
  int        bitrate;
  short int  level;          /* fixed or variable-size block matching */
  short int  subpel;           /* accurate for MC temporal analysis */
  short int  xblk;           /* block size */ 
  short int  yblk;           
  short int  maxx;           /* search size */
  short int  maxy;
  short int  xnum;           /* number of blocks */
  short int  ynum;
  enum FLAG  denoise_flag;
  enum FLAG  adapt_flag;
  enum FLAG  bi_flag;
  enum FLAG  OPEN_GOP;
  enum FLAG  CUT;
  enum FLAG  MCP_flag;

  short int tPyrLev;

  /*unsigned char ybandP1;
  unsigned char cbandP1;*/
//  unsigned char ybandGOP[6];
//  unsigned char cbandGOP[6];
//  unsigned char yclassP1;
//  unsigned char cclassP1;
//  unsigned char yclassGOP[6];
//  unsigned char cclassGOP[6];
  /*unsigned char ydpcmP1;
  unsigned char cdpcmP1;
  unsigned char ydpcmGOP[6];
  unsigned char cdpcmGOP[6];
  unsigned char dummy[8];  for 100 bytes */

} videoheader, *videoheader_ptr;

typedef struct{
  float *Y;
  float *U;
  float *V;
} YUVimage, *YUVimage_ptr;

typedef struct RDpoint{
  float step;   
  float  Rate;
  float  D;
  float  dRate;
  float  dD;
  float slope;
  float mslope;
 
  struct RDpoint *next;
  struct RDpoint *parent;
} rdpoint, *rdpoint_ptr;

typedef struct{
  float Rate;
  float D;
  float mslope;
} rdsum, *rdsum_ptr;

typedef struct Vector{
  int   child;
  enum BlockMode mode;
  int   Ymean;
  int   Umean;
  int   Vmean;
  unsigned char meandepth;
  float mvx; 
  float mvy;
  float mad;  // Jan27  
  float mse; 
  float var;
  int dL;     /* decrease of number of leaf */
  int dMAP;   /* decrease of number of mvbit */
  int dMV;    /* decrease of number of mvbit */
  int dD;     /* increase of distortion */
  float slope;  /* slope */
  float mslope;
  enum FLAG merge;

  struct Vector *child0;
  struct Vector *child1;
  struct Vector *child2;
  struct Vector *child3;

  struct Vector* parent;
} vector, *vector_ptr;


typedef struct{
  int leaf;
  int mapbit;
  int mvbit;
  int mvD;
  float slope;
  float mslope;
} mvnode, *mvnode_ptr;

typedef struct{
  int *map;
  int *mv;

  int *ybit;
  int *ubit;
  int *vbit;

  float *yvar;
  float *uvar;
  float *vvar;
} Rate, *Rate_ptr;


typedef struct{
  int map;
  int mv;

  int ybit;
  int ubit;
  int vbit;

  float yvar;
  float uvar;
  float vvar;
} rateP1, *rateP1_ptr;

typedef struct{
  int map;
  int mv;

  int ybit;
  int ubit;
  int vbit;

  float yvar;
  float uvar;
  float vvar;
} rateI1, *rateI1_ptr;

typedef struct Qtree{
  int   value;

  struct Qtree *child0;
  struct Qtree *child1;
  struct Qtree *child2;
  struct Qtree *child3;

  struct Vector* parent;
} qtree, *qtree_ptr;

typedef struct{
  int map[4];             /* map bit for LH, H0, H1 */
  int mv[4];              /* motion vectors for LH, H0,H1 */

  int ybit[4];
  int ubit[4];
  int vbit[4];

  float yvar[4];
  float uvar[4];
  float vvar[4];
} rateI4, *rateI4_ptr;


typedef struct{
  int map[4];
  int mv[4];

  int ybit[4];
  int ubit[4];
  int vbit[4];

  float yvar[4];
  float uvar[4];
  float vvar[4];
} rateP4, *rateP4_ptr;


