clear all
close all

fprintf(1,'****************************************************\n');
fprintf(1,'*       The MV field smoothness analysis           *\n');
fprintf(1,'****************************************************\n');
fprintf(1,'       Designed by Yue-Meng Chen, Aug,  2009      \n\n');

MVRES = 1;  % half-pixel
height = 288; 
width =352; 

% the block size that will be tested: 
% 32x32, 16x16, 8x8, 4x4,
%

blkList = [32, 16, 8, 4];

for blkIdx=1:4
    blkSiz=blkList(blkIdx);
    nH = height/blkSiz;
    nW = width/blkSiz;
    for i = 1:nH
        coorBlkX(i, :) = -nW/2:nW/2-1;
    end
    for i = 1:nW
        coorBlkY(:,i) = -nH/2:nH/2-1;
    end
    % get the image coordinates
    coorX = coorBlkX.*blkSiz-blkSiz/2;
    coorY = coorBlkY.*blkSiz-blkSiz/2;

    % 90-percentile for the magnitude and orientation statistics
    perc = 0.90;
    
    ii = 1;
    % focal length: 200 ~ 1000
    for flen = 200:200:1000
        % the ratio of focal length change in two consecutive frames
        for fr = 0.9:0.03:1.1
            % rotation angle on x-axis
            for fi_x = -1.6:0.5:1.6
                % rotation angle on y-axis
                for fi_y = -1.6:0.5:1.6
                    % rotation angle on z-axis
                    for fi_z = -1.6:0.5:1.6
                        campara(1) = flen;
                        campara(2) = fr*flen;
                        campara(3) = (fi_x/360)*2*pi;
                        campara(4) = (fi_y/360)*2*pi;
                        campara(5) = (fi_z/360)*2*pi;

                        % generate homography
                        H = camPhy(campara);
                        m = reshape(H', 1, 9);

                        % generate motion field using 8-perameter
                        % perspective model
                        [px, py] = mvGen_f(m, coorX, coorY);

                        %% histogram of size difference

                        % magnitude difference -- horizontal
                        [f,x] = hMagDiff(px, py);
                        ind = find(f>perc);
                        mag(ii) = x(ind(1));
                        
                        % orientation difference -- horizontal
                        [f,x] = hOriDiff(px, py);
                        ind = find(f>perc);
                        orit(ii) = x(ind(1)); ii = ii+1;

                        % magnitude difference -- vertical
                        [f,x] = vMagDiff(px, py);
                        ind = find(f>perc);
                        mag(ii) = x(ind(1));
                        
                        % orientation difference -- vertical
                        [f,x] = vOriDiff(px, py);
                        ind = find(f>perc);
                        orit(ii) = x(ind(1)); ii = ii+1;

                        % magnitude difference -- diagonal - 45C
                        [f,x] = dMagDiff1(px, py);
                        ind = find(f>perc);
                        mag(ii) = x(ind(1));
                        
                        % orientation difference -- diagonal - 45C
                        [f,x] = dOriDiff1(px, py);
                        ind = find(f>perc);
                        orit(ii) = x(ind(1)); ii = ii+1;

                        % magnitude difference -- diagonal - 135C
                        [f,x] = dMagDiff2(px, py);
                        ind = find(f>perc);
                        mag(ii) = x(ind(1));
                        
                        % orientation difference -- diagonal - 135C
                        [f,x] = dOriDiff2(px, py);
                        ind = find(f>perc);
                        orit(ii) = x(ind(1)); ii = ii+1;

                    end
                end
            end
        end
    end
    clear coorBlkX;
    clear coorBlkY;
    figure,
    subplot(2,1,1), plot(1:1:ii-1, mag), 
    xlabel('camera setting combination','FontSize',16)
    ylabel('Mag. diff.','FontSize',16)
    title(sprintf('normalized MV mag. diff., %d x %d',blkSiz,blkSiz) ,'FontSize',16)
    xlim([0 14000])
%     ylim([0 0.8])
    set(gca,'FontSize',16)

    subplot(2,1,2), plot(1:1:ii-1, orit),
    xlabel('camera setting combination','FontSize',16)
    ylabel('rotation. diff. (degree)','FontSize',16)
    title(sprintf('MV rotation. diff., %d x %d',blkSiz,blkSiz) ,'FontSize',16)
    xlim([0 14000])
%     ylim([0 25])
    set(gca,'FontSize',16)
end
disp('Done!')