function GME_real_seq();

close all
clear all

fprintf(1,'****************************************************\n');
fprintf(1,'*      GME performance analysis on real sequence   *\n');
fprintf(1,'****************************************************\n');
fprintf(1,'       Designed by Yue-Meng Chen, Aug,  2009      \n\n');

%% parameter initialization

% the percentage of inliers after the cascade filtering
rOUTLIERS = 0.7; 
% the threshold for gradient-descendant(GD) GME (with cascade)
REJRATE_CAS = 0.9; 
% the threshold for GD-GME (without the cascade)
REJRATE_ORI = rOUTLIERS*REJRATE_CAS;
% iteration number
MAXITER_CAS = 1; % Maximum iterations for GD-GME with the cascade
MAXITER_ORI = 6; % Maximum iterations for plain GD-GME 
MAXITER_LSS = 3; % Maximum iterations for LSS-ME 

for seq_id = 1:7
    
    SEG_PATH = '';
    
switch seq_id
    case 1  % garden
        seq_in = 'Z:\SFU_Research\Sequences\PD_30fps\garden\fg_sif_30fps.yuv';
        MOT_PATH = 'Z:\My_Matlab\motionEstimation\garden';
        nColumn = 352;
        nRow = 240;
        nFrm = 100;
        disp('test sequence -- garden, 100 frames')
        TITLE='Global Motion Compensation -- Garden';
    case 2  % stefan
        seq_in = 'Z:\SFU_Research\Sequences\PD_30fps\stefan\stefan_cif.yuv';
        MOT_PATH = 'Z:\My_Matlab\motionEstimation\stefan';
        nColumn = 352;
        nRow = 288;
        nFrm = 85;
        disp('test sequence -- stefan, 85 frames')
        TITLE='Global Motion Compensation -- Stefan';
    case 3  % City
        seq_in = 'Y:\Sequences\raw\cif_352x288\CITY_352x288_30_orig.yuv';
        MOT_PATH = 'Z:\My_Matlab\motionEstimation\city';
        nColumn = 352;
        nRow = 288;
        nFrm = 100;
        disp('test sequence -- city, 100 frames')
        TITLE='Global Motion Compensation -- City';
    case 4  % tempete
        seq_in = 'Y:\Sequences\raw\cif_352x288\tempete_cif.yuv';
        MOT_PATH = 'Z:\My_Matlab\motionEstimation\tempete';
        nColumn = 352;
        nRow = 288;
        nFrm = 100;
        disp('test sequence -- tempete, 100 frames')
        TITLE='Global Motion Compensation -- Tempete';
    case 5  % waterfall
        seq_in = 'Y:\Sequences\raw\cif_352x288\waterfall_cif.yuv';
        MOT_PATH = 'Z:\My_Matlab\motionEstimation\waterfall';
        nColumn = 352;
        nRow = 288;
        nFrm = 100;
        disp('test sequence -- waterfall, 100 frames')
        TITLE='Global Motion Compensation -- Waterfall';
    case 6  % mobile
        seq_in = 'Y:\Sequences\raw\cif_352x288\MOBILE_352x288_30_orig.yuv';
        MOT_PATH = 'Z:\My_Matlab\motionEstimation\mobile';
        nColumn = 352;
        nRow = 288;
        nFrm = 100;
        disp('test sequence -- mobile, 100 frames')
        TITLE='Global Motion Compensation -- Mobile';
    case 7  % coastguard
        seq_in = 'Y:\Sequences\raw\cif_352x288\coastguard_cif.yuv';
        MOT_PATH = 'Z:\My_Matlab\motionEstimation\coastguard';
        nColumn = 352;
        nRow = 288;
        nFrm = 100;
        disp('test sequence -- coastguard, 100 frames')
        TITLE='Global Motion Compensation -- Coastguard';
end
mpsnrCas = 0; mpsnrFlt = 0; mpsnrOri = 0; mpsnrRan = 0; mpsnrLSSMS = 0;
tic;
% Global motion compensation using GD-GME with the cascade
[psnrCas] = gme_cas_psnr(seq_in, MOT_PATH, nColumn, nRow, nFrm, rOUTLIERS, REJRATE_CAS, MAXITER_CAS);
mpsnrCas = mean(psnrCas);
% Global motion compensation using GD-GME with the outlier rejection filter
% from Ref. [6]
[psnrFlt] = gme_flt_psnr(seq_in, MOT_PATH, nColumn, nRow, nFrm, rOUTLIERS, REJRATE_CAS, MAXITER_CAS);
mpsnrFlt = mean(psnrFlt);
% Global motion compensation using plain GD-GME 
[psnrOri] = gme_ori_psnr(seq_in, MOT_PATH, nColumn, nRow, nFrm, REJRATE_ORI, MAXITER_ORI);
mpsnrOri = mean(psnrOri);
% Global motion compensation using RANSAC with least square regression
[psnrRan, iter] = gme_ransac_psnr(seq_in, MOT_PATH, nColumn, nRow, nFrm);
mpsnrRan = mean(psnrRan);
% Global motion compensation using iterative LSS-MS
[psnrLSSMS] = gme_lssms_psnr(seq_in, MOT_PATH, nColumn, nRow, nFrm, MAXITER_LSS);
mpsnrLSSMS = mean(psnrLSSMS);

[mpsnrCas mpsnrFlt mpsnrOri mpsnrRan mpsnrLSSMS]
toc;
end

disp('done!')
return;
