function [m] = camPhy(para)

f0 = para(1);    % focal length of image plane at time 0
f1 = para(2);    % focal length of image plane at time 1
fi_x = para(3);  % rotation angle on X axis
fi_y = para(4);  % rotation angle on Y axis
fi_z = para(5);  % rotation angle on Z axis
K1 = eye(3);
IK0 = eye(3);

K1(1,1) = f1;   K1(2,2) = f1;
IK0(1,1) = 1/f0; IK0(2,2) = 1/f0;

R_FI_X = [1,         0,         0;
          0, cos(fi_x), -sin(fi_x);
          0, sin(fi_x),  cos(fi_x)];

R_FI_Y = [cos(fi_y),  0,         sin(fi_y);
          0,          1,                 0;
          -sin(fi_y), 0,          cos(fi_y)];

R_FI_Z = [cos(fi_z), -sin(fi_z),  0;
          sin(fi_z),  cos(fi_z),  0;
                  0,          0,  1];

m = K1 * R_FI_Z * R_FI_X * R_FI_Y * IK0;

m = m ./ m(3,3);
end